SNC21120
SN0#XO.WAV
SN1#XO.WAV
SIL#XO.WAV
KNOCK.WAV
WHO_IS_THERE.WAV
ACID.WAV
ACID_WHO.WAV
ACID_SIT_DOWN.WAV
ALASKA.WAV
ALASKA_WHO.WAV
ALASKA_QUESTION.WAV
TERESA.WAV
TERESA_WHO.WAV
TERESA_FLY.WAV
DOCTOR.WAV
DOCTOR_WHO.WAV
ARDWARGH.WAV
ARDWARGH_WHO.WAV
ARDWARGH_WALK.WAV
LAUGH.WAV
FUNNY.WAV
NOT_FUNNY.WAV
HILARIOUS.WAV
GREAT_JOB.WAV
HAHA.WAV
PROGRAM
deboc	equ	#0101b
	IR_MODE	EQU	#0000B
MRX	EQU	#1111B
MRXB	EQU	#0000B
MRX32	EQU	#1111B
MRX48	EQU	#1111B
MRX64	EQU	#1111B
KeyP1	EQU	#1111B
KeyP2	EQU	#1111B
KeyP3	EQU	#1111B
KeyP6	EQU	#1111B
Rand0Max	EQU	#0000B
Rand1Max	EQU	#0000B
Rand2Max	EQU	#0000B
;#####################################################
; For SNC10000 Series (SNC12120 to SNC12340)
; Instruction Cycle : 4 us
; I/O      : P1,P2,P3,P6
; Channel  : 1  ( DAC & PWM )
; Core program : SNC10KEZ_16.asm( 1-channel , 16 ports)
; ----------------------------------------------------
; Scan Key          : P2 --> P1  ( Max 16 keys)
; Direct Key        : P1,P2,P3 and P6 ( Max 16 keys)
; Flash with volume : P3 with CH1
; Output Control    : P1, P2,P3,P6
;#####################################################

;/////////////////////////////////////////
tr1_4           equ     m0
tr5_8           equ     m1
tr9_12          equ     m2
tr13_16         equ     m3
p2state         equ     m4
p3state         equ     m5
4mto8m          equ     m6
;;modify 2005/5/30 03:41U, temp2 can't share other flag.
; Bit 0 --> 1: Head being played, need play tail before power down
; Bit 1 --> 
; bit2 =1 ... 8ms
; Bit 3 --> Debonce
p3_fva          equ     m7    ; Flash with CH1
VolValue_Page0	equ	m8    ; Add by Allan for record Volume
v_state         equ     m9    ; Speech state
;----modify start;
;ret_flag	equ	m9    ; bit0 ....... CH 1
;                              ; bit1 ....... FG return flag ==> 1: FG play return / 0 : FG Delay return
;                              ; bit2 ....... BACK CH 1
;                              ; bit3 ....... BG return flag ==> 1: BG play return / 0 : BG Delay return

EZIO_FG			equ	m9	; bit0 ....... CH 1
                              		; bit1 ....... EZIO FG or BG choose ; 1:FG / 0:BG
                              		; bit2 ....... BACK CH 1
                              		; bit3 ....... X

ret_flag		equ	m12		; bit0 & 1 : FG return
						; bit2 & 3 : BG return
						; 00 : all not ret
						; 01 : EZIO ret
						; 10 : delay ret
						; 11 : play ret
;----modify end;
deboc_count	equ	m10
;bit 0   ..... for debounce counter 4-->8 ms
;bit1~3  ..... debounce counter 8~56ms
;;for over Scan 16
Skblock		equ	m11
;for MIX key trigger.		;;\
;Mtr2		equ	m11	;; | --disable 2005/05/27 for V1.04
;Mtr3		equ	m12	;;/

temp1           equ     m13	;ScanKey KeyID used.
KeyID		equ	m13
;Temp RAM.
temp2           equ     m14
temp2_0		equ	m14
temp3           equ     m15
;trigger change condition
;---------------page1--------------
delay8m         equ     m0
delay01         equ     m1
delay1s         equ     m2
BGround1        equ     m3
BGround2        equ     m4
P2S_STATE       EQU     M5
P3S_STATE       EQU     M6
s_delay1        equ     m7
s_delay2        equ     m8
s_delay3        equ     m9
TrigState1      equ     m10
TrigState2      equ     m11
Delay_Flag	equ	m12
; Bit 0 --> Foreground Delay 8ms flag
; Bit 1 --> Background Delay 8ms flag
; Bit 2 --> Output     Delay 8ms flag
temp4           equ     m13
Time_Counter	equ	m13
IO_tmp1		equ	m13
temp5           equ     m14
RECEIVE_COUNT_1   EQU     M14
TRANS_COUNT_1     EQU     M14
IO_tmp2		equ	m14

; Bit 0 --> Inline Assembly Return 1 used flag
; Bit 1 --> Inline Assembly Return 2 used flag
p1state         equ     m15
;******* page2 ***********
p2_go1          equ     m0
p2_go2          equ     m1
p3_go1          equ     m2
p3_go2          equ     m3
loop            equ     m4
outloop         equ     m5
p3_fv1          equ     m7
Rand0           equ     m8
Rand1           equ     m9
;Rand2           equ     m10
enter_b         equ     m11
p_delay1        equ     m12
p_delay2        equ     m13
p_delay3        equ     m14
;m_stp           equ     #0011b
;m_pause         equ     #0001b
p1_go1          equ     m6
p1_go2          equ     m15

;---------------page3--------------


;/*
;ifdef @_key_type_@				;add at 5-26'04 for mix key
;Mtr2		equ	m10
;Mtr3		equ	m11			;In Mix key mode,memory direct key status
;endif
;*/

;---------------page4--------------
p6state         equ     m0
P6S_STATE       equ     m1
p6_go1          equ     m2
p6_go2          equ     m3
tr17_20		equ	m4
tr21_24		equ	m5
tr25_28		equ	m6
tr29_32		equ	m7
tr33_36		equ	m8
tr37_40		equ	m9
tr41_44		equ	m10
tr45_48		equ	m11
tr49_52		equ	m12
tr53_56		equ	m13
tr57_60		equ	m14
tr61_64		equ	m15

Mtr2		equ	m13
Mtr3		equ	m14
Mtr6		equ	m15

;;---------------- page5 ----------------
EZIO_flag	equ	m0

EZIO_timerH	equ	m1
EZIO_timerL	equ	m2
EZ_Mark		equ	m3
PWMIOEN1		equ	m4
PWMIOEN2		equ	m5
Next_flag	equ	m6
;;;; PAGE2   M12.0 ;;;;;;;;
IRout_ON_OFF_5_0   EQU      M15
;;;; PAGE2   M12.1 ;;;;;;;;
TRIGGER_FLAG_5_1   EQU     M15    ;

;;;; PAGE2   M12.2 ;;;;;;;;;
IRin_ON_OFF_5_2     EQU      M15  ;
; BIT2=0 ........ IR OFF
; BIT2=1 ........ IR ON

;;;; PAGE2   M12.3 ;;;;;;;;
IR_TX_P33_ON_OFF_5_3  EQU    M15 ;
; BIT3=0 ........ P3.3 38.5K Hz OFF
; BIT3=1 ........ P3.3 38.5K Hz ON

;;;; IR Tx
TRANS_L         EQU     M13
TRANS_H         EQU     M14

;;;; IR Rx
RECEIVE_L       EQU     M13
RECEIVE_H       EQU     M14

;=================================20080416 new===================================
	;======================= page5 ============================
EventFlag	equ	m7	; used for event mark enable or disable flag
mask_fra1	equ	m8	; used for fv debounce
fra1_flag	equ	m9	; used for fv debounce
EZ_MarkH	equ	m10	; used for bit5&4 of 6 bit event mark in EZIO
;m11	used for fv debounce
;----------------PAGE6---------------------
P30_duty_L	equ	m0
P30_duty_H	equ	m1
P30_step_TL	equ	m2
P30_step_TH	equ	m3

P31_duty_L	equ	m4
P31_duty_H	equ	m5
P31_step_TL	equ	m6
P31_step_TH	equ	m7

P32_duty_L	equ	m8
P32_duty_H	equ	m9
P32_step_TL	equ	m10
P32_step_TH	equ	m11

P33_duty_L	equ	m12
P33_duty_H	equ	m13
P33_step_TL	equ	m14
P33_step_TH	equ	m15
;----------------PAGE7---------------------
P30_timer_tempH	equ	m0
P30_timer_tempL	equ	m1
Temp6		equ	m2
Temp7		equ	m3

includestd		macro21K_2.h
includestd		ProductionTestMode_16.asm

;**************** MACRO **************************
;--------------------------------------------
;	CAJNE	Macro
;--------------------------------------------
CAJNE	Macro	Memory,Address
	CAJE	Memory,@F
	JMP	Address
@@:
ENDM

;--------------------------------------------
;	CallTo	Macro	Label
;--------------------------------------------
JumpTo	Macro	label
	Jmp	label
@@&label&_Bk:
ENDM


;##########################################################
; ###################  Program Start  ###################
;##########################################################
start:                                  ;power on initial routine
	
	JumpTo	Initial_Chip
	JumpTo	Update_Key
	jmp     @@_init
Main_Loop:
	;;;;;;;; For IR transmit function ;;;;;;;;;;;;;;;;;;;;;
ifdef   IR_TRANSMIT
        JMP     @IR_TRANSMIT
@IR_TRANSMIT_OK:
endif

ifdef   IR_Receive
;;;;;;;; For IR receive function ;;;;;;;;;;;;;;;;;;;;;
        JMP     @IR_RECEIVE
@IR_RECEIVE_OK:
endif
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	JumpTo	ScanKey				; Scankey Function.
	JumpTo	Update_Output			; I/O output Function.
	JumpTo	Check_Random			; Random Function.
	;JumpTo	Check_Speech			; Speech Play Function.
	JumpTo	Check_Timer			; 4ms Timer.
	JumpTo	Check_Delay
	JumpTo	Check_EZIO		
	JumpTo	Check_Event			; Event Mark Function.
	
	page1
	Jmp	@@CHKBGROUND			; Check BackGround.
@@CHKBGROUND_BACK:
	JumpTo	Check_PowerDown			; Power Down Routine
@@Scankey1:
@@Toggle_2_Back:
	JumpTo	Check_EnterB			; Check Enter B function.
	Jmp	Main_Loop
/*
;##########################################################
;########## FG ret_flag ###################################
;#############################################################
@@FG_reset:
	Page1
	Mov	delay8m	#0000b	                ;// reset FG delay
	Page0
	Mov 	a	#1100b
	And	a	ret_flag
	Mov	ret_flag	a		;//reset FG ret_flag
	Ret1
*/
/*	
;##########################################################
;########## BG  ret_flag ###################################
;#############################################################	
@@BG_reset:
	Page2
	Mov	P_delay1	#0000b		;// reset BG delay
	Page0
	Mov	a	#0011b
	And	a	ret_flag
	Mov	ret_flag	a		;//reset BG ret_flag
	Ret2
*/
;##########################################################
; ###################  Wake Up Routine ###################
;##########################################################
trigger:
        rstc
        rstcf
@@ini_lp:
        cjc     @@ready_scan
        jmp     @@ini_lp
@@ready_scan:
        rstcf
;;;; Scankey P2-->P1
        page0
        mov     a       mrx
        and     a       p2state
ifdef	@_key_type_@
	mov     p2state a
	mov	a	keyp2 
	and	a	p2state
endif	               
        mov     p2state a
        mov     p2      a
        
ifdef mrx_2
        mov     a       mrx_2
        and     a       p3state
	mov     p3state a
        mov     p3      a
endif        	

;;;;;; For IR  receive function  ;;;;;;
;;;;;; WAKEUP STATE
        PAGE5
        MOV     A,#0010B
        OR      A,TRIGGER_FLAG_5_1
        MOV     TRIGGER_FLAG_5_1,A ;; TRIGER FLAG for IR	
@@scankey:
	; Force All delay Routine Stop.
        page1
        mov     delay8m #0000b		
        mov     s_delay1 #0
        page2
        mov     p_delay1        #0000b
	Jmp	Main_Loop
	
;##########################################
;   -------- Initial Chip --------
;========================================
; This function is used to Initial those
; Memory used.
;----------------------------------------
Initial_Chip:
        page0    
        stop
	rcode
        mov     a       #1111b
        mov     p2s     a
        mov     p3s     a
        mov	p6s	a

        mov     a       #0000b
        mov     p3      a
        mov     p3state a
        mov     p2      a
        mov     p2state a
      
	page4
        mov     p6      a
        mov     p6state a       
	page0
        mov     tr1_4   #0000b          ;m0:tr1-4 status, m1:tr5-8 status
        mov     tr5_8   #0000b          ;m2:tr9-12 status, m3:tr13-16 status
        mov     tr9_12  #0000b            
        mov     tr13_16 #0000b          
        mov     m6      #0000b          ;m6.2:8ms,bit3:debounce,bit0:head
        mov     p3_fva  #0000b
        mov     v_state #0000b
        mov     m14     #0000b          ;m14:temp2
        mov     m15     #0000b          ;m15:scan of p1 bit
        mov	a,#0111b
        mov	VolValue_Page0,a	; add by Allan, set Master Vol is Max        
        page1
        mov     delay8m #0000b          ;m0:delay
        mov     s_delay1 #0000b
        MOV     M12     #0000B
        mov     bground1        #0000b
        mov     bground2        #0000b
        page2
        mov     p2_go1  #0000b                  ;x=1
        mov     p2_go2  #1111b                  ;x=0
        mov     p3_go1  #0000b                  ;x=1
        mov     p3_go2  #1111b                  ;x=0
	mov     p1_go1  #0000b                  ;x=1
        mov     p1_go2  #1111b                  ;x=0
	
        mov     p3_fv1  #0000b
        mov     p_delay1 #0000b
        mov     Rand0   #0
        mov     Rand1   #0
;        mov     Rand2   #0
		page0
        mov     ret_flag   #0
        page2
        mov     enter_b #0000b
        
        page4
        mov     p6_go1  #0000b                  ;x=1
        mov     p6_go2  #1111b                  ;x=0
        

;;;; For Drive & Sink function ;;;;;;;;;;;
        Page1
        MOV     A       #1111B
        MOV     P2S_STATE  A
        MOV     P3S_STATE  A

        page4
        MOV     P6S_STATE  A
      
;;; Set P33 modulated with 38.5 KHz square wave
;;; P32 and P33 work as normal output pin
	page0
        MOV     A       IR_MODE
        or	a	VolValue_Page0
        MOV     MODE     A
        mov	VolValue_Page0 a
        MOV     A       IR_MODE
        CAJE    #0000B   @F
        MOV     A        #1000B
@@:
        PAGE5
        OR      A,IR_TX_P33_ON_OFF_5_3
        MOV     IR_TX_P33_ON_OFF_5_3,A
        mov	EventFlag	#0001b		; 20080417 clayton , default of event is enable
        
ifdef	@_key_type_@ 				;add at 05-26'04 for mix key
	page4       
	mov	Mtr2	#0000b
	mov	Mtr3	#0000b
endif
	Jmp	@@Initial_Chip_Bk
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;##########################################
;   -------- Update --------
;========================================
; This function is used Update Key 
; Information.
;----------------------------------------
Update_Key:
        page0
        mov     a       mrx
        caje    #1111b  @@update_key
        mov     a       #0001b
        mov     p2      a
        mov     a       mrx
        mov     p2s     a
        mov     a       #1111b
        mov     p2s     a
        mov     a       p1
        mov     tr1_4   a
        mov     a       #0010b
        mov     p2      a
        mov     a       mrx
        mov     p2s     a
        mov     a       #1111b
        mov     p2s     a
        mov     a       p1
        mov     tr5_8   a
        mov     a       mrx
        caje    #1100b  @@update_over
        mov     a       #0100b
        mov     p2      a
        mov     a       mrx
        mov     p2s     a
        mov     a       #1111b
        mov     p2s     a
        mov     a       p1
        mov     tr9_12  a
        mov     a       mrx
        caje    #1000b  @@update_over
        mov     a       #1000b
        mov     p2      a
        mov     a       mrx
        mov     p2s     a
        mov     a       #1111b
        mov     p2s     a
        mov     a       p1
        mov     tr13_16 a
;;**********************************************************
ifdef   mrx_2
        page4
        mov     a       #0001b
        mov     p3      a
        mov     a       mrx_2
        mov     p3s     a
        mov     a       #1111b
        mov     p3s     a
        mov     a       p1
        mov     tr17_20 a
        mov     a       mrx_2
        caje    #1110b  @@update_over
        mov     a       #0010b
        mov     p3      a
        mov     a       mrx_2
        mov     p3s     a
        mov     a       #1111b
        mov     p3s     a
        mov     a       p1
        mov     tr21_24 a
        mov     a       mrx_2
        caje    #1100b  @@update_over
        mov     a       #0100b
        mov     p3      a
        mov     a       mrx_2
        mov     p3s     a
        mov     a       #1111b
        mov     p3s     a
        mov     a       p1
        mov     tr25_28 a
        mov     a       mrx_2
        caje    #1000b  @@update_over
        mov     a       #1000b
        mov     p3      a
        mov     a       mrx_2
        mov     p3s     a
        mov     a       #1111b
        mov     p3s     a
        mov     a       p1
        mov     tr29_32 a
endif
ifdef	mrx_3
        mov     a       #0001b
        mov     p2      a
        mov     a       mrx_3
        mov     p2s     a
        mov     a       #1111b
        mov     p2s     a
        mov     a       p6
        mov     tr33_36 a
        
        mov     a       mrx_3
        caje    #1110b  @@update_over
        mov     a       #0010b
        mov     p2      a
        mov     a       mrx_3
        mov     p2s     a
        mov     a       #1111b
        mov     p2s     a
        mov     a       p6
        mov     tr37_40 a
        mov     a       mrx_3
        caje    #1100b  @@update_over
        mov     a       #0100b
        mov     p2      a
        mov     a       mrx_3
        mov     p2s     a
        mov     a       #1111b
        mov     p2s     a
        mov     a       p6
        mov     tr41_44 a
        mov     a       mrx_3
        caje    #1000b  @@update_over
        mov     a       #1000b
        mov     p2      a
        mov     a       mrx_3
        mov     p2s     a
        mov     a       #1111b
        mov     p2s     a
	
        mov     a       p6
        mov     tr45_48 a
endif
ifdef   mrx_4
        mov     a       #0001b
        mov     p3      a
        mov     a       mrx_4
        mov     p3s     a
        mov     a       #1111b
        mov     p3s     a
        mov     a       p6
        mov     tr49_52 a
        mov     a       mrx_4
        caje    #1110b  @@update_over
        mov     a       #0010b
        mov     p3      a
        mov     a       mrx_4
        mov     p3s     a
        mov     a       #1111b
        mov     p3s     a
        mov     a       p6
        mov     tr53_56 a
        mov     a       mrx_2
        caje    #1100b  @@update_over
        mov     a       #0100b
        mov     p3      a
        mov     a       mrx_4
        mov     p3s     a
        mov     a       #1111b
        mov     p3s     a
        mov     a       p6
        mov     tr57_60 a
        mov     a       mrx_4
        caje    #1000b  @@update_over
        mov     a       #1000b
        mov     p3      a
        mov     a       mrx_4
        mov     p3s     a
        mov     a       #1111b
        mov     p3s     a
        mov     a       p6
        mov     tr61_64 a
endif

        
        
@@update_over:
        mov     a       #0000b
        mov     p2      a
        
ifdef 	mrx_2        
	mov	a	#0000b
	mov	p3	a
endif	
	
ifdef 	@_key_type_@				;add at 05-26'04 for mix key
	page0
        mov     a       p2
        mov     KeyID     a
        mov     a       keyp2
        and     a       KeyID
	page4
        mov     Mtr2   a
	page0
        mov     a       p3
        mov     KeyID     a
        mov     a       keyp3
        and     a       KeyID
	page4
        mov     Mtr3  a
        page0
        mov     a       p6
        mov     KeyID     a
        mov     a       keyp6
        and     a       KeyID
	page4
        mov     Mtr6   a
        
endif 
;******************************************************
        Jmp	@@Update_Key_Bk
;******************************************************
@@update_key:
        mov     a       p1
        mov     KeyID   a
        mov     a       keyp1
        and     a       KeyID
        mov     tr1_4   a

        mov     a       p2
        mov     KeyID   a
        mov     a       keyp2
        and     a       KeyID
        mov     tr5_8   a

        mov     a       p3
        mov     KeyID   a
;;;; If IR occur ....disable p33 , p32
        
        MOV     temp2_0,#1111B
ifdef   IR_Transmit
ifdef   IR_Receive
;;;   IR_Bidirection
        
        MOV     temp2_0,#0011B
else
;;;; IR_TRANSMIT
        
        MOV     temp2_0,#0111B
endif
elseifdef       IR_Receive
;;;;;   IR_RECEIVE
        
        MOV     temp2_0,#0111B
endif
        mov     a       keyp3
        and	a	temp2_0
        and     a       KeyID
        mov     tr9_12  a
        
        mov     a       p6
        mov     KeyID   a
        mov     a       keyp6
        and     a       KeyID
        mov     tr13_16  a
        jmp     @@Update_Key_Bk

;##########################################
;   -------- Check Enter B --------
;========================================
;
;----------------------------------------
Check_EnterB:
        page2
        mov     a       #0001b
        and     a       enter_b
        caje    #0000b  @@Check_EnterB_Bk
        mov     a       #1110b
        and     a       enter_b
        mov     enter_b a
        page3
        ret1

;##########################################
;   -------- Check Speech Play --------
;========================================
; check speech playing
; It seems like Flash with volume only.
; Need further check.
;----------------------------------------
Check_Speech:
	page5
	mov	a	Next_flag
	caje	#0	@f
	mov	a	nxtply
	caje	#14	@f
	mov	a	Next_flag
	caje	#1	@@fv1_ok_ret11
	caje	#2	@@fv1_ok_ret2
@@:	
        page0
        mov     a       #0001b
        and     a       v_state

        caje    #0000b  @@no_v1_1
        jmp     @@with_v1
@@no_v1_1:
        mov     a       #1111b
        xor     a       p3_fva
        and     a       p3state
        mov     p3state a
        mov     p3      a
        jmp     @@no_v1
@@with_v1:
;=============== new fv ====================
	mov	a	#1111b
	page5
	xor	a	fra1_flag
	page0
	mov	m15	#0100b
	and	a	m15
        caje    #0100b  @@v1_fsh		
        jmp     @@no_v1_fsh
;===================================
@@no_v1_fsh:
        mov     a       #1111b
        xor     a       p3_fva
        and     a       p3state
        mov     p3state a
        mov     p3      a
        jmp     @@fv1_ok
@@v1_fsh:
        page0
        mov     a       p3_fva
        or      a       p3state
        mov     p3state a
        mov     p3      a
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@fv1_ok:
;ifdef  @@_EZ_IO_@@
;        page5
;        mov	a	#0100b
;        and	a	EZIO_flag
;        page0
;        caje	#0000b	@wave_end_check	;EZIO_flag.2=0 : EZIO ending by wave / EZIO_flag.2=1 : EZIO ending by eio end mark
; @eio_end_check:
;        page5
;        mov	a	#0001b
;        and	a	EZIO_flag
;        page0
;        caje	#0001b	@@no_v1		;EZIO_flag.0=0 : eio end mark detected or force to stop / EZIO_flag.0=1 : EZIO keep going
;        jmp	@END_EZIO    
;          	
;@extend_fake_check:
;	mov	a	fra2
;	caje	#0100b	@@no_v1
;	jmp	@wave_end_check2
;	
; @wave_end_check:
;	page0
;        mov	a	temp2
;        caje	#0011b	@extend_fake_check	
;endif
; @wave_end_check2:
 	page0
        CJP    @@no_v1                     ;voice is playing
; @END_EZIO:
;        Play   sil#xo.wav
        mov     a       #1110b
        and     a       v_state
        mov     v_state a

        PAGE0
        mov     a       #0100b
        and     a       v_state
        caje    #0000b  @@fv1_ok_ret1

        mov     a       #1011b
        and     a       v_state
        mov     v_state a


        PAGE2
        mov     a       #0100b
        and     a       enter_b
        caje    #0000b  @@fv1_ok_ret2
        mov     a       #1011b
        and     a       enter_b
        mov     enter_b a
        jmp     @@scankey1
@@fv1_ok_ret2:
	page0
;	mov	a	#1000b
 	mov	a	#1100b
	and	a	ret_flag
	caje	#1100b	@@fv1_ok_ret2_ok
	jmp	@@no_v1
@@fv1_ok_ret2_ok:
	page0
	mov	a	#0011b	
	and	a	ret_flag
	mov	ret_flag	a
		
;	caje	#0	@@no_v1
;;	 @@chk_p_delay1_ret2	@@no_v1		;add in 04/10/2003 for ret2 problem
        page3					;mark in 04/10/2003
        ret2					;mark in 04/10/2003

@@fv1_ok_ret1:
        PAGE2
        mov     a       #0100b
        and     a       enter_b
        caje    #0000b  @@fv1_ok_ret11
        mov     a       #1011b
        and     a       enter_b
        mov     enter_b a
        jmp     @@scankey1
@@fv1_ok_ret11:
	page0
;	mov	a	#0010b
	mov	a	#0011b
	and	a	ret_flag
	caje	#0011b	@@fv1_ok_ret11_ok
	jmp	@@no_v1
@@fv1_ok_ret11_ok:
	page0
	mov	a	#1100b		
	and	a	ret_flag
	mov	ret_flag	a
;	caje	#0	@@no_v1
;;	@@chk_delay8m_ret1	@@no_v1		;add in 04/10/2003 for ret1 problem
        page3					;mark in 04/10/2003
        ret1					;mark in 04/10/2003
@@no_v1:
@@no_s_play:
        jmp     @@Check_Speech_Bk

;##########################################
;   -------- Check Delay --------
;========================================
; When EZ paste delay command into program,
; Please remember to clear corresponding
; Delay Flag only. 
; (Do not clear other delay flag)
;----------------------------------------
Check_Delay:
	page1
	;Check if 8ms Delay occur.
	mov	a	#0111B
	and	a	Delay_Flag
	Caje	#0	@@Check_Delay_Bk

;===============================
;====== Foreground Delay =======
;===============================
@@Chk_FG_Delay:
	;Check if foreground Delay enable
        page1
        mov	a	#0001B			;2005/6/20 04:36U
	and	a	Delay_Flag		;2005/6/20 04:36U
	Caje	#0	@@Chk_BG_Delay		;2005/6/20 04:36U
	;Clear foreground 8ms Flag.
	mov	a	#1110b
	and	a	Delay_Flag
	mov	Delay_Flag	a

        mov	a	delay8m
	Caje	#0	@@delay_end
@@delay:
        mov     a       delay8m
        inca
        mov     delay8m a
        caje    #0000b  @@01_sec
        jmp	@@delay_end
@@01_sec:
        mov     delay8m #0100b
        mov     a       delay01
        inca
        mov     delay01 a
        caje    #0000b  @@1sec
        jmp	@@delay_end
@@1sec:
        mov     delay01 #0110b
        mov     a       delay1s
        inca
        mov     delay1s a
        caje    #0000b  @@delay_ok
        jmp	@@delay_end
        ; Delay counted, turn off delay and
        ; issue a return1 back to user foreground path.
@@delay_ok:
        mov     delay8m #0000b
        
	page0
;	mov	a	#0010b
	mov	a	#0011b	
	and	a	ret_flag
	caje	#0010b	@@delay_ok_ret1
    jmp		@@delay_end
@@delay_ok_ret1:
	page0
	mov	a	#1100b	
	and	a	ret_flag
	mov	ret_flag	a	
;	caje	#0010b	@@delay_end

        page3
        ret1
@@delay_end:
;===============================
;====== Background Delay =======
;===============================
@@Chk_BG_Delay:	
	;Check if background Delay enable
        page1
        mov	a	#0010B			;2005/6/20 04:36U
	and	a	Delay_Flag		;2005/6/20 04:36U
	Caje	#0	@@Chk_O_Delay		;2005/6/20 04:36U
	mov	a	#1101b
	and	a	Delay_Flag
	mov	Delay_Flag	a
	
        mov	a	s_delay1
	Caje	#0	@@delay1_end
@@delay1:
        mov     a       s_delay1
        inca
        mov     s_delay1 a
        caje    #0000b  @@s01_sec
	jmp	@@delay1_end
@@s01_sec:
        mov     s_delay1 #0100b
        mov     a       s_delay2
        inca
        mov     s_delay2 a
        caje    #0000b  @@s1sec
	jmp	@@delay1_end
@@s1sec:
        mov     s_delay2 #0110b
        mov     a       s_delay3
        inca
        mov     s_delay3 a
        caje    #0000b  @@s_delay_ok
	jmp	@@delay1_end
@@s_delay_ok:
 	; Delay counted, turn off delay
 	; and issue ret2 for return to
 	; user background path.
        mov     s_delay1 #0000b
        page3
        ret3
@@delay1_end:
;===============================
;======   Output Delay   =======
;===============================
@@Chk_O_Delay:	
	page1
	mov	a	#0100B			;2005/6/20 04:35U
	and	a	Delay_Flag		;2005/6/20 04:35U
	Caje	#0	@@delayp_end		;2005/6/20 04:36U
	mov	a	#1011b
	and	a	Delay_Flag
	mov	Delay_Flag	a
	
	;Check if Output Delay enable
        page2
	mov	a	p_delay1
	Caje	#0	@@delayp_end
@@delayp:
        mov     a       p_delay1
        inca
        mov     p_delay1 a
        caje    #0000b  @@p01_sec
	jmp	@@delayp_end
@@p01_sec:
        mov     p_delay1 #0100b
        mov     a       p_delay2
        inca
        mov     p_delay2 a
        caje    #0000b  @@p1sec
	jmp	@@delayp_end
@@p1sec:
        mov     p_delay2 #0110b
        mov     a       p_delay3
        inca
        mov     p_delay3 a
        caje    #0000b  @@p_delay_ok
	jmp	@@delayp_end
@@p_delay_ok:
        mov     p_delay1 #0000b
        
	page0
;	mov	a	#1000b
	mov	a	#1100b
	and	a	ret_flag
	caje	#1000b	@@delayp_ok_ret2
	jmp	@@delayp_end
@@delayp_ok_ret2:
	mov	a	#0011b	
	and	a	ret_flag
	mov	ret_flag	a	
;	caje	#1000b	@@delayp_end

        page3
        ret2
@@delayp_end:
	Jmp	@@Check_Delay_Bk

;##########################################
;   -------- Check EZIO --------
;========================================
; check EZIO running
; if EZIO end, check FG or BG ret
; For FG & BG ret, check if EZIO ret or not
;----------------------------------------
Check_EZIO:
ifdef	@@_EZ_IO_@@
        page5
        mov	a	#0001b
        and	a	EZIO_flag
        caje	#0001b	@Check_EZIO_ok		;EZIO_flag.0=0 : eio end mark detected or force to stop / EZIO_flag.0=1 : EZIO keep going

	mov	a	#0010b			; EZIO is FG or not
	page0
	and	a	EZIO_FG
	
	caje	#0000b	@EZIO_ret2_check
	jmp	@EZIO_ret1_check

@EZIO_ret1_check:
	page0
	mov	a	#0011b
	and	a	Ret_flag
	caje	#0001b	@EZIO_ok_ret1
	jmp	@Check_EZIO_ok
@EZIO_ret2_check:
	page0
	mov	a	#1100b
	and	a	Ret_flag
	caje	#0100b	@EZIO_ok_ret2
	jmp	@Check_EZIO_ok
@EZIO_ok_ret1:
	page0
	mov	a	#1100b
	and	a	ret_flag
	mov	ret_flag	a
	page3
	ret1
@EZIO_ok_ret2:
	page0
	mov	a	#0011b
	and	a	ret_flag
	mov	ret_flag	a
  page3
	ret2
endif

@Check_EZIO_ok:
	Jmp	@@Check_EZIO_Bk
	
;##########################################
;   -------- Update_Output --------
;========================================
;
;----------------------------------------
Update_output:
; ##########################################################
;       For IR function
;  IR_TRANSMIT.... Disable P3.3
;  IR_RECEIVE .... Disable P3.3
;  IR_Bidirection .... Disable P3.2 and P3.3
; ##########################################################
ifdef   IR_Transmit

ifdef   IR_Receive
        PAGE2
        MOV     A,#0011B
        AND     A,P3_GO1
        MOV     P3_GO1,A

        MOV     A,#1100B
        OR      A,P3_GO2
        MOV     P3_GO2,A
else
        PAGE2
        MOV     A,#0111B
        AND     A,P3_GO1
        MOV     P3_GO1,A

        MOV     A,#1000B
        OR      A,P3_GO2
        MOV     P3_GO2,A
endif

elseifdef       IR_Receive
        PAGE2
        MOV     A,#0111B
        AND     A,P3_GO1
        MOV     P3_GO1,A

        MOV     A,#1000B
        OR      A,P3_GO2
        MOV     P3_GO2,A
endif
        
        page0
        mov     a       p3_fva
        page2
        or      a       p3_fv1
        mov     p3_fv1  #0000b
        and     a       p3_go2
        page0
        mov     p3_fva  a
@@toggle_1_back:
	page2
        mov     a       #1111b
        xor     a       p1_go2
        caje    #0      @@updateP2
        page1
        mov     a       p1state
        page2
        and     a       p1_go2
        or      a       p1_go1
        page1
        mov     p1state a
        mov     p1      a
	
	
@@updateP2:	
        page2
        mov     a       p2_go2
        caje    #1111b  @@updateP3

;;;; For Drive & Sink function ;;;;;;;;;;;
        MOV     A,#1111B
        XOR     A,P2_GO2
        Page1
        OR      A ,P2S_STATE
;DIRECT KEY MASK 2002/6/12
        MOV	P2S_STATE ,A
        MOV	A ,KEYP2
        OR      A ,P2S_STATE
        
        MOV     P2S,A
        MOV     P2S_STATE,A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        page0
        mov     a       p2state
        page2
        and     a       p2_go2
        or      a       p2_go1
        page0
        mov     p2state a
        mov     p2      a
;;;; For Drive & Sink function ;;;;;;;;;;;
        PAGE2
        MOV     A,P2_GO2
        Page1
        AND     A,P2S_STATE
;DIRECT KEY MASK 2002/6/12
        MOV	P2S_STATE ,A
        MOV	A ,KEYP2
        OR      A ,P2S_STATE
        
        MOV     P2S,A
        MOV     P2S_STATE,A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@updateP3:
      
        page2
        mov     a       p3_go2
        caje    #1111b  @@updateP6
	
;;;; For Drive & Sink function ;;;;;;;;;;;
        MOV     A,#1111B
        XOR     A,P3_GO2
        Page1
        OR      A ,P3S_STATE
;DIRECT KEY MASK 2002/6/12
        MOV	P3S_STATE ,A
        MOV	A ,KEYP3
        OR      A ,P3S_STATE
        
        MOV     P3S,A
        MOV     P3S_STATE,A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        page0
        mov     a       p3state
        page2
        and     a       p3_go2
        or      a       p3_go1
        page0
        mov     p3state a
        mov     p3      a

;;;; For Drive & Sink function ;;;;;;;;;;;
        PAGE2
        MOV     A,P3_GO2
        Page1
        AND     A,P3S_STATE
;DIRECT KEY MASK 2002/6/12
        MOV	P3S_STATE ,A
        MOV	A ,KEYP3
        OR      A ,P3S_STATE
        
        MOV     P3S,A
        MOV     P3S_STATE,A



@@updateP6:
        page4
        mov     a       p6_go2
        caje    #1111b  @@updateDone

;;;; For Drive & Sink function ;;;;;;;;;;;
        MOV     A,#1111B
        XOR     A,P6_GO2
        ;Page1				;disable by yc 2005/06/09
        OR      A ,P6S_STATE
;DIRECT KEY MASK 2002/6/12
        MOV	P6S_STATE ,A
        MOV	A ,KEYP6
        OR      A ,P6S_STATE
        
        MOV     P6S,A
        MOV     P6S_STATE,A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        mov     a       p6state
        and     a       p6_go2
        or      a       p6_go1
        mov     p6state a
        mov     p6      a

;;;; For Drive & Sink function ;;;;;;;;;;;
        MOV     A,P6_GO2
        AND     A,P6S_STATE
;DIRECT KEY MASK 2002/6/12
        MOV	P6S_STATE ,A
        MOV	A ,KEYP6
        OR      A ,P6S_STATE
        
        MOV     P6S,A
        MOV     P6S_STATE,A

@@updateDone:
	
	page4			;;
	mov     p6_go2  #1111b	;; add by yc 2005/06/09
        page2
        mov     p2_go2  #1111b
        mov     p3_go2  #1111b
	Jmp	@@Update_output_Bk

Check_Event:
;============================================= new event mark & fv debounce ===============================
@@_normal_Mark:
	mov	a	FRA1			; bit2 of Fra1 is for fv flag
	page5
	mov	mask_fra1	a
	mov	a	#0100b		; 
	and	a	mask_fra1
	caje	#0000b	@update_fv
	jmp	@debounce_fv
@update_fv:
	mov	a	mask_fra1
	mov	fra1_flag	a
	mov	m11	#0000b
	jmp	@@event_check

@debounce_fv:
	mov	a	m11
	caje	#1111b	@update_fv
	jmp	@upcount

@upcount:
	mov	a	m11
	inca
	mov	m11	a
	jmp	@@event_check

@@event_check:

ifdef	@@_EZ_IO_@@
	page5
	mov	a	#0001b
	and	a	EventFlag
	caje	#0000b	@@chk_event_over
	mov	a	EZIO_flag
	caje	#0000b	@event_load
	mov	a	#1000b
	and	a	EZIO_flag
	caje	#0000b	@@chk_event_over	;	EZIO_flag.3=0 ==> no event mark
	mov	a	#0111b			;============ clayton 20080218 =====================
	and	a	EZIO_flag		;	clear Event mak flag (EZIO_flag.3) when event is read
	mov	EZIO_flag	a		;
	mov	a	EZ_MarkH
	mov	EZ_MarkH	#0000b
	caje	#0000b	@jmp_e0_e15
;	caje	#0001b	@jmp_e16_e31
;	caje	#0010b	@jmp_e32_e47
;	jmp	@jmp_e48_e63

@jmp_e0_e15:
	mov	a	EZ_Mark
	mov	EZ_Mark #0000b
	caje	#0000b	@@chk_event_over	;@@e0
	caje	#0001b	@@e1		
	caje	#0010b	@@e2		
	caje	#0011b	@@e3		
	caje	#0100b	@@e4		
	caje	#0101b	@@e5		
	caje	#0110b	@@e6		
	caje	#0111b	@@e7		
	caje	#1000b	@@e8		
	caje	#1001b	@@e9		
	caje	#1010b	@@e10		
	caje	#1011b	@@e11		
	caje	#1100b	@@e12		
	caje	#1101b	@@e13		
	caje	#1110b	@@e14		
	jmp	@@e15	
;@jmp_e16_e31:
;	mov	a	EZ_Mark
;	mov	EZ_Mark #0000b
;	caje	#0000b	@@e16
;	caje	#0001b	@@e17		
;	caje	#0010b	@@e18		
;	caje	#0011b	@@e19		
;	caje	#0100b	@@e20		
;	caje	#0101b	@@e21		
;	caje	#0110b	@@e22		
;	caje	#0111b	@@e23		
;	caje	#1000b	@@e24		
;	caje	#1001b	@@e25		
;	caje	#1010b	@@e26		
;	caje	#1011b	@@e27		
;	caje	#1100b	@@e28		
;	caje	#1101b	@@e29		
;	caje	#1110b	@@e30		
;	jmp	@@e31		
;@jmp_e32_e47:
;	mov	a	EZ_Mark
;	mov	EZ_Mark #0000b
;	caje	#0000b	@@e32
;	caje	#0001b	@@e33		
;	caje	#0010b	@@e34		
;	caje	#0011b	@@e35		
;	caje	#0100b	@@e36		
;	caje	#0101b	@@e37		
;	caje	#0110b	@@e38		
;	caje	#0111b	@@e39		
;	caje	#1000b	@@e40		
;	caje	#1001b	@@e41		
;	caje	#1010b	@@e42		
;	caje	#1011b	@@e43		
;	caje	#1100b	@@e44		
;	caje	#1101b	@@e45		
;	caje	#1110b	@@e46		
;	jmp	@@e47		
;@jmp_e48_e63:
;	mov	a	EZ_Mark
;	mov	EZ_Mark #0000b
;	caje	#0000b	@@e48
;	caje	#0001b	@@e49		
;	caje	#0010b	@@e50		
;	caje	#0011b	@@e51		
;	caje	#0100b	@@e52		
;	caje	#0101b	@@e53		
;	caje	#0110b	@@e54		
;	caje	#0111b	@@e55		
;	caje	#1000b	@@e56		
;	caje	#1001b	@@e57		
;	caje	#1010b	@@e58		
;	caje	#1011b	@@e59		
;	caje	#1100b	@@e60		
;	caje	#1101b	@@e61		
;	caje	#1110b	@@e62		
;	jmp	@@e63		

endif	

@event_load:
	page5
	mov	a	#0001b
	and	a	EventFlag
	caje	#0000b	@@chk_event_over
	mov	a	#0010b
	and	a	EventFlag
	caje	#0010b	@@chk_event_over          		;bit1=1 of EventFlag no read event mark
	mov	a	Mark

@@_EZIO_Mark:
	caje	#0000b	@@chk_event_over
	caje	#0001b	@@e1		
	caje	#0010b	@@e2		
	caje	#0011b	@@e3		
	caje	#0100b	@@e4		
	caje	#0101b	@@e5		
	caje	#0110b	@@e6		
	caje	#0111b	@@e7		
	caje	#1000b	@@e8		
	caje	#1001b	@@e9		
	caje	#1010b	@@e10		
	caje	#1011b	@@e11		
	caje	#1100b	@@e12		
	caje	#1101b	@@e13		
	caje	#1110b	@@e14		
	jmp	@@e15		
@@chk_event_over:

	jmp	@@check_event_Bk

;##########################################
;   -------- Check Timer Routine --------
;========================================
;
;----------------------------------------
Check_Timer:
        cjc     @@4ms
        jmp     @@Check_Delay_OK
@@4ms:
	rstcf
ifdef	@@_EZ_Io_@@        
        JumpTo  Check_EZIO_Delay
endif        
ifdef	PWMEN12
	JumpTo	ChecK_PWMIO_P3
endif	
        
        page0
        mov	a	deboc_count	; key debonce counter
        inca				; 4ms increase one time.
        mov	deboc_count	a	; It will be cleared when key changed.
        
        mov     a       #0100b
        xor     a       4mto8m
        mov     4mto8m  a
        mov     a       #0100b
        and     a       4mto8m
        caje    #0100b  @@Check_Delay_OK
@@8ms:  
	PAGE1
	mov	a	#0111B
	or	a	Delay_Flag
	mov	Delay_Flag	a
	
@@Check_Delay_OK:
	Jmp	@@Check_Timer_Bk
;##########################################
;   -------- Power Down Routine --------
;========================================
;
;----------------------------------------
;********** power down routine ok ********
Check_PowerDown:


	
ifdef   IR_Transmit
        PAGE5
        MOV     A,#0001B
        AND     A,IRout_ON_OFF_5_0
        CAJE    #0001B,@@scankey1
endif

ifdef	@@_EZ_IO_@@
	page5
	mov	a	#0001b
	and	a	EZIO_flag
	caje	#0001b	@@scankey1		; 20090115 clayton : EZIO function is running, so back to @@scankey1
endif

	page5
	mov	a	PWMIOEN1
	caje	#0	@@check_PWMIOEN2
	jmp	@@scankey1
@@check_PWMIOEN2:
	mov	a	PWMIOEN2
	caje	#0	@@Power_down_chk
	jmp	@@scankey1
@@Power_down_chk:


	page0
	mov	a	skblock 
	caje	#0000b	@@scankey_ok
	jmp	@@scankey1
@@scankey_ok:	
        page1
        mov     a       delay8m
        caje    #0000b  @@no_delay
        jmp     @@scankey1
@@no_delay:
        mov     a       s_delay1
        caje    #0000b  @@no_s_delay
        jmp     @@scankey1
@@no_s_delay:
        page2
        mov     a       p_delay1
        caje    #0000b  @@no_p_delay
        jmp     @@scankey1
@@no_p_delay:
        page0
        mov     a       #0001b
        and     a       v_state
        caje    #0000b  @@pd_ready
        jmp     @@scankey1
@@no_bk:
	PAGE1
	MOV	A	BGROUND2
        page0
        caje    #0000b  @@pd_ready
        jmp     @@scankey1        
@@pd_ready:
        CJP    @@scankey1
        mov     a       #1000b
        and     a       4mto8m
        caje    #1000b  @@scankey1

        mov     a       #0001b
        and     a       4mto8m    ;check have play head code, 
        			  ;	if play,before power down must do voice down
        caje    #0000b  @@power_down

        VolDown				; Add by Allan (1/3/05), downcount Volume to prevent "Bo".

 ; Turn OFF Push_Pull OP2
        mov	A,#0100B
        mov	mode1,a

        Play   sn1#xo.wav
        ;mov	m14	#0000b	;  \
        mov	a	#1110b	;   | modify 2005/5/30 03:46U 4mto8m share other flag
        and	a	4mto8m	;   |
        mov     4mto8m     a	;  /
@@wait_t:
        CJP    @@wait_t

        ; Turn OFF Push_Pull OP1 & OP2
        mov	A,#0000B
        mov	mode1,a
        
        page0
        ;mov	a,#0111b		;\
        mov	a,VolValue_Page0	 ;| Add by Allan (1/3/05), Restore Master Volume to MODE
        mov	mode,a			;/        
        
        jmp     @@scankey1
@@power_down:
        page0
        mov     a       mrx
        caje    #1111b  @@pd_key0_
@@pd_scan0:
        mov     KeyID     #0001b                  ;KeyID: scan loop
        jmp     @@pd_trig_scan
@@pd_scan0_back:
        mov     a       p1
        xor     a       tr1_4
	caje	#0000b	@@pd_scan1
        jmp     @@trig_chk
@@pd_scan1:
        mov     KeyID     #0010b                  ;KeyID: scan loop
        jmp     @@pd_trig_scan
@@pd_scan1_back:
        mov     a       p1
        xor     a       tr5_8
	caje	#0000b	@@pd_scan2
        jmp     @@trig_chk
@@pd_scan2:
        mov     KeyID     #1000b
        mov     a       mrx
        caje    #1100b  @@pd_scan_ok
        mov     KeyID     #0100b                  ;KeyID: scan loop
        jmp     @@pd_trig_scan
@@pd_scan2_back:
        mov     a       p1
        xor     a       tr9_12
	caje	#0000b	@@pd_scan3
        jmp     @@trig_chk
@@pd_scan3:
        mov     KeyID     #1000b
        mov     a       mrx
        caje    #1000b  @@pd_scan_ok
        jmp     @@pd_trig_scan
@@pd_scan3_back:
        mov     a       p1
        xor     a       tr13_16
	caje	#0000b	@@pd_scan_ok
        jmp     @@trig_chk

@@pd_scan_ok:
ifdef	@_key_type_@				;add at 05-26'04 for mix key
@@pd_Mkeyp2:
	page0	
        mov     a       p2
        mov     KeyID     a
        mov     a       keyp2
        and     a       KeyID
	mov	KeyID	#0011b
	page4
        xor     a       Mtr2
        caje	#0000b	@@pd_Mkeyp3	         
        jmp     @@trig_chk

@@pd_Mkeyp3:
	page0	
        mov     a       p3
        mov     KeyID     a
        mov     a       keyp3
        and     a       KeyID
        mov     KeyID     #0111b
	page4
        xor     a       Mtr3
	caje	#0000b	@@pd_scankey_ok
        jmp     @@trig_chk
endif
	jmp	@@pd_scankey_ok

@@pd_key0_:
	page0
        mov     a       p1
        mov     KeyID     a
        mov     a       keyp1
        and     a       KeyID
        mov     KeyID     #0001b
        xor     a       tr1_4
	caje	#0000b	@@pd_key1_
        jmp     @@trig_chk
@@pd_key1_:
        mov     a       p2
        mov     KeyID     a
        mov     a       keyp2
        and     a       KeyID
        mov     KeyID     #0010b
        xor     a       tr5_8
	caje	#0000b	@@pd_key2_
        jmp     @@trig_chk
@@pd_key2_:
        mov     a       p3
        mov     KeyID     a
        ;;;; If IR occur ....disable p33 , p32
        PAGE0
        MOV     temp2_0,#1111B
ifdef   IR_Transmit
ifdef   IR_Receive
;;;   IR_Bidirection
        
        MOV     temp2_0,#0011B
else
;;;; IR_TRANSMIT
        
        MOV     temp2_0,#0111B
endif
elseifdef       IR_Receive
;;;;;   IR_RECEIVE
        
        MOV     temp2_0,#0111B
endif
        mov     a       keyp3
        and     a       KeyID
        and	a	temp2_0
        mov     KeyID     #0100b
        xor     a       tr9_12
	caje	#0000b	@@pd_scankey_ok
        jmp     @@trig_chk

@@pd_scankey_ok:
;;;; For Drive & Sink function ;;;;;;;;;;;
        Page1
        MOV     A,P2S_STATE
        MOV     P2S,A
        MOV     A,P3S_STATE
        MOV     P3S,A
        PAGE0
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    ;   page0
    ;   mov     a       #1111b
    ;   mov     p2s     a
    ;   mov     p3s     a
;;;; Scankey P2-->P1  ;;;;;;;;;;
        mov     a       mrxb
        or      a       p2state
;ifdef	@_key_type_@				;add at 05-26'04 for mix key
;	mov	p2state	a
;	mov	a	keyp2
;	and	a	p2state
;endif	  
        mov     p2      a
        mov     p2state a
ifdef 	mrx_2
	mov     a       mrxb_2
        or      a       p3state
        mov     p3      a
        mov     p3state a
endif        
        
        mov     m15     #0000b
        end
;******* trigger scan routine ok*****************


;##########################################
;   -------- ScanKey  --------
;========================================
; If M14=1xxx, It will stop scan new line.
; Just repeat doing Debonce only.
; If (mrx=#1111B), it will enter direct
; trigger mode.
;----------------------------------------
ScanKey:
        page0
        mov     a       #1000b
        and     a       4mto8m ;m14 2005/5/30 03:47U change m6
        caje    #1000b  Check_Debounce

        page0
        mov     a       mrx
        caje    #1111b  @@key0_

ifdef 	mrx_2
	;page0
	mov	a	skblock
	;page0
	caje	#0001b	@@scan4
ifdef	mrx_3
	caje	#0010b	@@scan8
ifdef	mrx_4
	caje	#0011b	@@scan12
endif	;;mrx_4
endif	;;mrx_3
endif	;;mrx_2	

;==================================
;=  ------ Scan P2.0-->P1 ------  =
;==================================
@@scan0:
	mov     KeyID     #0001b                  ;KeyID: scan loop
        jmp     @@trig_scan
@@scan0_back:
        mov     a       p1
        xor     a       tr1_4
        jmp     @@trig_chk
;==================================
;=  ------ Scan P2.1-->P1 ------  =
;==================================
@@scan1:
        mov     KeyID     #0010b                  ;KeyID: scan loop
        jmp     @@trig_scan
@@scan1_back:
        mov     a       p1
        xor     a       tr5_8
        jmp     @@trig_chk
;==================================
;=  ------ Scan P2.2-->P1 ------  =
;==================================
@@scan2:
	mov     KeyID     #1000b
	mov     a       mrx
	caje    #1100b  @@mrx
	mov     KeyID     #0100b                  ;KeyID: scan loop
        jmp     @@trig_scan
@@scan2_back:
        mov     a       p1
        xor     a       tr9_12
        jmp     @@trig_chk
;==================================
;=  ------ Scan P2.3-->P1 ------  =
;==================================
@@scan3:
        mov     KeyID     #1000b
        mov     a       mrx
        caje    #1000b  @@mrx
        jmp     @@trig_scan
@@scan3_back:
        mov     a       p1
        xor     a       tr13_16
        jmp     @@trig_chk
        
ifdef mrx_2        
;==================================
;=  ------ Scan P3.0-->P1 ------  =
;==================================
@@scan4:
        mov     KeyID     #0001b                  ;KeyID: scan loop
        jmp     @@trig_scan_2
@@scan4_back:
	page4
        mov     a       p1
        xor     a       tr17_20
        jmp     @@trig_chk
;==================================
;=  ------ Scan P3.1-->P1 ------  =
;==================================
@@scan5:
        mov     KeyID     #1000b
        mov     a       mrx_2
        caje    #1110b  @@mrx
        mov     KeyID     #0010b                  ;KeyID: scan loop
        jmp     @@trig_scan_2
@@scan5_back:
	page4
        mov     a       p1
        xor     a       tr21_24
        jmp     @@trig_chk
;==================================
;=  ------ Scan P3.2-->P1 ------  =
;==================================
@@scan6:
        mov     KeyID     #1000b
        mov     a       mrx_2
        caje    #1100b  @@mrx
        mov     KeyID     #0100b                  ;KeyID: scan loop
        jmp     @@trig_scan_2
@@scan6_back:
	page4
        mov     a       p1
        xor     a       tr25_28
        jmp     @@trig_chk
;==================================
;=  ------ Scan P3.3-->P1 ------  =
;==================================
@@scan7:
        mov     KeyID     #1000b
        mov     a       mrx_2
        caje    #1000b  @@mrx
        jmp     @@trig_scan_2
@@scan7_back:
	page4
        mov     a       p1
        xor     a       tr29_32
        jmp     @@trig_chk
endif        
ifdef 	mrx_3
;==================================
;=  ------ Scan P2.0-->P6 ------  =
;==================================
@@scan8:
        mov     KeyID     #0001b                  ;KeyID: scan loop
        jmp     @@trig_scan_3
@@scan8_back:
	page4
        mov     a       p6
        xor     a       tr33_36
        jmp     @@trig_chk
;==================================
;=  ------ Scan P2.1-->P6 ------  =
;==================================
@@scan9:
         mov     KeyID     #1000b
        mov     a       mrx_3
        caje    #1110b  @@mrx
        mov     KeyID     #0010b                  ;KeyID: scan loop
        jmp     @@trig_scan_3
@@scan9_back:
	page4
        mov     a       p6
        xor     a       tr37_40
        jmp     @@trig_chk
;==================================
;=  ------ Scan P2.2-->P6 ------  =
;==================================
@@scan10:
        mov     KeyID     #1000b
        mov     a       mrx_3
        caje    #1100b  @@mrx
        mov     KeyID     #0100b                  ;KeyID: scan loop
        jmp     @@trig_scan_3
@@scan10_back:
	page4
        mov     a       p6
        xor     a       tr41_44
        jmp     @@trig_chk
;==================================
;=  ------ Scan P2.3-->P6 ------  =
;==================================
@@scan11:
        mov     KeyID     #1000b
        mov     a       mrx_3
        caje    #1000b  @@mrx
        jmp     @@trig_scan_3
@@scan11_back:
	page4
        mov     a       p6
        xor     a       tr45_48
        jmp     @@trig_chk
endif                
ifdef 	mrx_4
;==================================
;=  ------ Scan P3.0-->P6 ------  =
;==================================
@@scan12:
        mov     KeyID     #0001b                  ;KeyID: scan loop
        jmp     @@trig_scan_4
@@scan12_back:
	page4
        mov     a       p6
        xor     a       tr49_52
        jmp     @@trig_chk
;==================================
;=  ------ Scan P3.1-->P6 ------  =
;==================================
@@scan13:
        mov     KeyID     #1000b
        mov     a       mrx_4
        caje    #1110b  @@mrx
        mov     KeyID     #0010b                  ;KeyID: scan loop
        jmp     @@trig_scan_4
@@scan13_back:
	page4
        mov     a       p6
        xor     a       tr53_56
        jmp     @@trig_chk
;==================================
;=  ------ Scan P3.2-->P6 ------  =
;==================================
@@scan14:
        mov     KeyID     #1000b
        mov     a       mrx_4
        caje    #1100b  @@mrx
        mov     KeyID     #0100b                  ;KeyID: scan loop
        jmp     @@trig_scan_4
@@scan14_back:
	page4
        mov     a       p6
        xor     a       tr57_60
        jmp     @@trig_chk
;==================================
;=  ------ Scan P3.3-->P6 ------  =
;==================================
@@scan15:
        mov     KeyID     #1000b
        mov     a       mrx_4
        caje    #1000b  @@mrx
        jmp     @@trig_scan_4
@@scan15_back:
	page4
        mov     a       p6
        xor     a       tr61_64
        jmp     @@trig_chk
endif        
;##########################################
; -------- ScanKey output Routine --------
;========================================
; Input: Pg0 KeyID. (Data will output to P2)
;----------------------------------------
@@trig_scan:
ifdef	mrx_2
	page0
	mov     a       p3state
	mov	p3	a
endif	
;;;; Scankey P2-->P1 ;;;;;;;;;
        page0
        mov     a       p2state
        or      a       KeyID
        mov     p2      a
        mov     a       mrx
        mov     p2s     a
        mov     a       #1111b
        mov     p2s     a
        mov     a       KeyID
        
        caje    #0001b  @@scan0_back
        caje    #0010b  @@scan1_back
        caje    #0100b  @@scan2_back
        caje	#1000b  @@scan3_back
	jmp	@@scankey1		; This line will not happened.
	
ifdef 	mrx_2       
@@trig_scan_2:
	;;;; Scankey P3-->P1 ;;;;;;;;;
        page0
	mov     a       p2state
	mov	p2	a
        mov     a       p3state
        or      a       KeyID
        mov     p3      a
        mov     a       mrx_2
        mov     p3s     a
        mov     a       #1111b
        mov     p3s     a
        
        mov     a       KeyID
        caje    #0001b  @@scan4_back
        caje    #0010b  @@scan5_back
        caje    #0100b  @@scan6_back
        jmp     @@scan7_back
endif
ifdef 	mrx_3        
@@trig_scan_3:
	
        ;;;; Scankey P2-->P6 ;;;;;;;;;
        page0
	mov     a       p3state
	mov	p3	a
        
        
        mov     a       p2state
        or      a       KeyID
        mov     p2      a
        mov     a       mrx_3
        mov     p2s     a
        mov     a       #1111b
        mov     p2s     a
        mov     a       KeyID
        caje    #0001b  @@scan8_back
        caje    #0010b  @@scan9_back
        caje    #0100b  @@scan10_back
        jmp     @@scan11_back        
endif        
ifdef	mrx_4        
@@trig_scan_4:
	;;;; Scankey P3-->P6 ;;;;;;;;;
        page0
	mov     a       p2state
	mov	p2	a
       
       
        mov     a       p3state
        
        or      a       KeyID
        mov     p3      a
        mov     a       mrx_4
        mov     p3s     a
        mov     a       #1111b
        mov     p3s     a
        
        mov     a       KeyID
        caje    #0001b  @@scan12_back
        caje    #0010b  @@scan13_back
        caje    #0100b  @@scan14_back
        jmp     @@scan15_back        
endif        	

;==================================
;=  _---- Power Down Check _----  =
;==================================
@@pd_trig_scan:					;add at 03/23/04
;;;; Scankey P2-->P1 ;;;;;;;;;
        page0
        mov     a       p2state
        or      a       KeyID
        mov     p2      a
        mov     a       mrx
        mov     p2s     a
        mov     a       #1111b
        mov     p2s     a
        mov     a       KeyID
        caje    #0001b  @@pd_scan0_back
        caje    #0010b  @@pd_scan1_back
        caje    #0100b  @@pd_scan2_back
        caje	#1000b  @@pd_scan3_back
	jmp	@@scankey1		; This line will not happened.

;##########################################
; -------- Direct Trigger Routine --------
;========================================
;----------------------------------------
@@key0_:
        mov     a       p1
        mov     KeyID     a
        mov     a       keyp1
        and     a       KeyID
        mov     KeyID     #0001b
        xor     a       tr1_4
        jmp     @@trig_chk
@@key1_:
        mov     a       p2
        mov     KeyID     a
        mov     a       keyp2
        and     a       KeyID
        mov     KeyID     #0010b
        xor     a       tr5_8
        jmp     @@trig_chk
@@key2_:
        mov     a       p3
        mov     KeyID     a
        mov     a       keyp3
        and     a       KeyID
        mov     KeyID     #0100b
        xor     a       tr9_12
        jmp     @@trig_chk
@@key3_:
        mov     a       p6
        mov     KeyID     a
        mov     a       keyp6
        and     a       KeyID
        mov     KeyID     #1000b
        xor     a       tr13_16
        jmp     @@trig_chk


ifdef	@_key_type_@				;add at 05-26'04 for mix key
@@Mkeyp2_:
	page0	
        mov     a       p2
        mov     KeyID     a
        mov     a       keyp2
        and     a       KeyID
	mov	KeyID	#0011b
	page4
        xor     a       Mtr2
	jmp	@@trig_chk
@@Mkeyp3_:
	page0	
        mov     a       p3
        mov     KeyID     a
        mov     a       keyp3
        and     a       KeyID
        mov     KeyID     #0111b
	page4
        xor     a       Mtr3
	jmp	@@trig_chk
	
@@Mkeyp6_:
	page0	
        mov     a       p6
        mov     KeyID     a
        mov     a       keyp6
        and     a       KeyID
        mov     KeyID     #1111b
	page4
        xor     a       Mtr6
	jmp	@@trig_chk	
endif


;##########################################
;   -------- Trigger Check --------
;========================================
; Input A: If A doesn't equal to zero,
; it will set M6.3 for enable debouce
; routine.
;----------------------------------------
@@trig_chk:

        page0
       
        caje    #0000b  @@mrx
        
        mov     m15     a                       ;m15:trigger change condition
        mov     a       #1000b                  ;m6.3=1,debounce
        and     a       4mto8m	;m14 2005/5/30 03:48U
        caje	#1000b	@@ScanKey_BK
        
        mov     a       #1000b                  ;m6.3=1,debounce
        or      a       4mto8m ;m14 2005/5/30 03:48U
        mov     4mto8m     a    ;2005/5/30 03:48U
        
        mov	deboc_count	#0		;clear debonce counter.
	Jmp	@@ScanKey_BK

@@mrx:
	JumpTo	Check_Speech
	page0
        mov     a       #0111b			;modify 2005/05/26 only clr bounce flag
        and     a       4mto8m	;m14 2005/5/30 03:48U
        mov     4mto8m     a	;2005/5/30 03:48U

        mov     deboc_count	#0

        mov     a       mrx
        caje    #1111b  @@chk_direct_key
        
ifdef	mrx_2
	page0
	mov     a       skblock
        caje    #1      @@mrx_01   
ifdef 	mrx_3             
        caje	#2	@@mrx_02
endif
ifdef    mrx_4    
        caje	#3	@@mrx_03
endif        
endif                
@@_mrx_00:        
        page0
        mov     a       Keyid
        caje    #0001b  @@scan1
        caje    #0010b  @@scan2
        caje	#0100b	@@scan3
ifdef mrx_2
	;page?
	mov	skblock	#1
	jmp	@@ScanKey_BK
endif	

ifdef	@_key_type_@				;add at 05-26'04 for mix key			  	
	caje	#1000b	@@Mkeyp2_
	caje	#0011b	@@Mkeyp3_
	caje	#0111b	@@Mkeyp6_
endif
	jmp	@@ScanKey_BK
	;;--------------------------------
ifdef	mrx_2
@@mrx_01:
	page0
        mov     a       Keyid
        caje    #0001b  @@scan5
        caje    #0010b  @@scan6
        caje	#0100b	@@scan7
        
ifdef mrx_3
	;page?
	mov	skblock	#2
	jmp	@@ScanKey_BK
endif	
	
ifdef	@_key_type_@				;add at 05-26'04 for mix key			  	
	caje	#1000b	@@Mkeyp2_
	
	caje	#0011b	@@Mkeyp3_
	caje	#0111b	@@Mkeyp6_
endif
	;page?
	mov	skblock	#0

	jmp	@@ScanKey_BK
endif        ;mrx_2	
	;;-------------------------------------

ifdef	mrx_3
@@mrx_02:
	page0
        mov     a       Keyid
        caje    #0001b  @@scan9
        caje    #0010b  @@scan10
        caje	#0100b	@@scan11
        
ifdef mrx_4
	;page6
	mov	skblock	#3
	jmp	@@ScanKey_BK
endif	
	
ifdef	@_key_type_@				;add at 05-26'04 for mix key			  	
	caje	#1000b	@@Mkeyp2_
	caje	#0011b	@@Mkeyp3_
	caje	#0111b	@@Mkeyp6_
endif
	;page6
	mov	skblock	#0
	jmp	@@ScanKey_BK
endif        ;mrx_3	
	;;-------------------------------------

ifdef	mrx_4
@@mrx_03:
	page0
        mov     a       Keyid
        caje    #0001b  @@scan13
        caje    #0010b  @@scan14
        caje	#0100b	@@scan15
        

	;page?
	mov	skblock	#0
	jmp	@@ScanKey_BK
endif        ;mrx_4	
        
        

;##########################################
;   -------- Debonce Routine --------
;========================================
;----------------------------------------
Check_Debounce:
	page0
        mov     a       deboc_count
        caje    deboc	@@tr_cg_ok

        mov     a       mrx
        caje    #1111b  @@trig_key_ret
ifdef	mrx_2
	;page?
	mov	a	skblock
	;page0
	caje	#01	@@scan_kb1
ifdef	mrx_3
	caje	#02	@@scan_kb2
endif	
ifdef	mrx_4
	caje	#03	@@scan_kb3	        
endif	
endif
@@scan_kb0:        
        mov     a       KeyID
        caje    #0001b  @@scan0
        caje    #0010b  @@scan1
        caje    #0100b  @@scan2
	caje	#1000b	@@scan3
ifdef	@_key_type_@				;add at 05-26'04 for mix key
	caje	#0011b	@@Mkeyp2_
	caje	#0111b	@@Mkeyp3_
	caje	#1111b  @@Mkeyp6_
endif 
        jmp     @@scan0
        
ifdef	mrx_2        
@@scan_kb1:        
        mov     a       Keyid
        caje    #0001b  @@scan4
        caje    #0010b  @@scan5
        caje    #0100b  @@scan6
ifdef	@_key_type_@
	caje	#0011b	@@Mkeyp2_
	caje	#0111b	@@Mkeyp3_
	caje	#1111b	@@Mkeyp6_
endif                
        jmp	@@scan7
endif

ifdef	mrx_3        
@@scan_kb2:        
        mov     a       Keyid
        caje    #0001b  @@scan8
        caje    #0010b  @@scan9
        caje    #0100b  @@scan10
ifdef	@_key_type_@
	caje	#0011b	@@Mkeyp2_
	caje	#0111b	@@Mkeyp3_
	caje	#1111b	@@Mkeyp6_
endif                
        jmp	@@scan11
endif
        
ifdef	mrx_4        
@@scan_kb3:        
        page0        
        mov     a       Keyid
        caje    #0001b  @@scan12
        caje    #0010b  @@scan13
        caje    #0100b  @@scan14
        jmp	@@scan15
endif           
        
        
        
@@trig_key_ret:
        mov     a       KeyID
        caje    #0001b  @@key0_  ; p1
        caje    #0010b  @@key1_  ; p2
        caje	#0100b	@@key2_  ; p3
        jmp     @@key3_          ; p6
;******* scankey routine ok ********************

@@tr_cg_ok:
        page0
        mov     deboc_count	#0		; Reset Debounce counter
        
        mov     a       #0111b			; Clear Debounce Flag
        and     a       4mto8m	;m14 2005/5/30 03:49U
        mov     4mto8m     a	;2005/5/30 03:49U
        
        mov     a       #0001b			; M15 = XXX1 ? 
        and     a       m15
        caje    #0001b  @@p1ok
        
        mov     a       #0010b			; M15 = XX1X ?
        and     a       m15
        caje    #0010b  @@p1ok
        
        mov     a       #0100b			; M15 = X1XX ?
        and     a       m15
        caje    #0100b  @@p1ok
        
        mov     a       #1000b			; Else, Set M15 = 1000
@@p1ok: mov     m15     a			; M15 is used to UPDATE BIT.
ifdef	mrx_2
	;page?	
	mov	a	skblock
	;page0
	caje	#0001b	@@update_mrx_2
ifdef	mrx_3
	caje	#0010b	@@update_mrx_3
ifdef	mrx_4
	caje	#0011b	@@update_mrx_4
endif	;mrx_4			        
endif	;mrx_3
endif	;mrx_2   


        mov     a       KeyID
        caje    #0001b  @@update_mrx1_0
        caje    #0010b  @@update_mrx1_1
        caje    #0100b  @@update_mrx1_2
	caje	#1000b	@@update_mrx1_3
ifdef	@_key_type_@				;add at 05-26'04 for mix key	
	caje	#0011b	@@update_MixedKeyP2
	caje	#0111b	@@update_MixedKeyP3
	caje	#1111b  @@update_MixedKeyP6
	jmp	@@scankey_bk
@@update_MixedKeyP6:
	page4
        mov     a       Mtr6
	page0
	xor	a	m15
	page4
        mov     Mtr6  a
	jmp	@@change	
@@update_MixedKeyP3:
	page4
        mov     a       Mtr3
	page0
	xor	a	m15
	page4
        mov     Mtr3  a
	jmp	@@change

@@update_MixedKeyP2:
	page4
        mov     a       Mtr2
	page0
	xor	a	m15
	page4
        mov     Mtr2	a
        jmp     @@change
endif
@@update_mrx1_3:
        mov     a       tr13_16
        xor     a       m15
        mov     tr13_16 a
        jmp     @@change
@@update_mrx1_2:
        mov     a       tr9_12
        xor     a       m15
        mov     tr9_12  a
        jmp     @@change
@@update_mrx1_1:
        mov     a       tr5_8
        xor     a       m15
        mov     tr5_8   a
        jmp     @@change
@@update_mrx1_0:
        mov     a       tr1_4
        xor     a       m15
        mov     tr1_4   a
	jmp	@@change
@@change:
	page0
        and     a       m15
        caje    #0000b  @@trh2l_run
        jmp     @@trl2h_run
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ifdef	mrx_2
@@update_mrx_2:	        
	mov     a       Keyid
        caje    #0001b  @@update_mrx_2_0
        caje    #0010b  @@update_mrx_2_1
        caje    #0100b  @@update_mrx_2_2
	caje	#1000b	@@update_mrx_2_3  
ifdef	@_key_type_@				;add at 05-26'04 for mix key	
;	caje	#0011b	@@update_MixedKeyP2
	caje	#0111b	@@update_MixedKeyP3
	caje	#1111b	@@update_MixedKeyP6
endif		
	jmp	@@Scankey_bk

@@update_mrx_2_3:
	page4
        mov     a       tr29_32
        page0
        xor     a       m15
        page4
        mov     tr29_32 a
        jmp     @@change
@@update_mrx_2_2:
	page4
        mov     a       tr25_28
        page0
        xor     a       m15
        page4
        mov     tr25_28  a
        jmp     @@change
@@update_mrx_2_1:
	page4
        mov     a       tr21_24
        page0
        xor     a       m15
        page4
        mov     tr21_24   a
        jmp     @@change
@@update_mrx_2_0:
	page4
        mov     a       tr17_20
        page0
        xor     a       m15
        page4
        mov     tr17_20   a		
	jmp	@@change
endif	
	
ifdef	mrx_3
@@update_mrx_3:	        
	mov     a       Keyid
        caje    #0001b  @@update_mrx_3_0
        caje    #0010b  @@update_mrx_3_1
        caje    #0100b  @@update_mrx_3_2
	caje	#1000b	@@update_mrx_3_3 
ifdef	@_key_type_@				;add at 05-26'04 for mix key	
	;caje	#0011b	@@update_MixedKeyP2
	;caje	#0111b	@@update_MixedKeyP3
	caje	#1111b	@@update_MixedKeyP6
endif			 
	jmp	@@scankey_bk

@@update_mrx_3_3:
	page4
        mov     a       tr45_48
        page0
        xor     a       m15
        page4
        mov     tr45_48 a
        jmp     @@change
@@update_mrx_3_2:
	page4
        mov     a       tr41_44
        page0
        xor     a       m15
        page4
        mov     tr41_44  a
        jmp     @@change
@@update_mrx_3_1:
	page4
        mov     a       tr37_40
        page0
        xor     a       m15
        page4
        mov     tr37_40   a
        jmp     @@change
@@update_mrx_3_0:
	page4
        mov     a       tr33_36
        page0
        xor     a       m15
        page4
        mov     tr33_36   a		
	jmp	@@change
endif

ifdef	mrx_4
@@update_mrx_4:	        
	mov     a       Keyid
        caje    #0001b  @@update_mrx_4_0
        caje    #0010b  @@update_mrx_4_1
        caje    #0100b  @@update_mrx_4_2
	caje	#1000b	@@update_mrx_4_3  

	jmp	@@scankey_bk

@@update_mrx_4_3:
	page4
        mov     a       tr61_64
        page0
        xor     a       m15
        page4
        mov     tr61_64 a
        jmp     @@change
@@update_mrx_4_2:
	page4
        mov     a       tr57_60
        page0
        xor     a       m15
        page4
        mov     tr57_60  a
        jmp     @@change
@@update_mrx_4_1:
	page4
        mov     a       tr53_56
        page0
        xor     a       m15
        page4
        mov     tr53_56   a
        jmp     @@change
@@update_mrx_4_0:
	page4
        mov     a       tr49_52
        page0
        xor     a       m15
        page4
        mov     tr49_52   a		
	jmp	@@change
endif        
        
        
        

;##########################################
;   -------- Check_Direct_Key --------
;========================================
;----------------------------------------
@@chk_direct_key:
        mov     a       KeyID
        ;caje    #0100b  @@timer_ok
        caje    #1000b	@@ScanKey_BK
        caje    #0001b  @@key1_
        caje    #0010b  @@key2_
        jmp     @@key3_
@@trl2h_run:
ifdef	mrx_2
	;page?
	mov	a	skblock
	;page0
	caje	#0001b	@@tr17_32r
ifdef	mrx_3
	caje	#0010b	@@tr33_48r
	
ifdef	mrx_4
	caje	#0011b	@@tr49_64r
endif
endif 	;mrx_3
endif 	;mrx_2
        
        mov     a       KeyID
        caje    #0001b  @@tr1_4r
        caje    #0010b  @@tr5_8r
        caje    #0100b  @@tr9_12r
        caje	#1000b  @@tr13_16r
ifdef	@_key_type_@				;add at 05-26'04 for mix key
	caje	#0011b	@@Mtr2r
	caje	#0111b	@@Mtr3r
	caje	#1111b	@@Mtr6r
endif
	jmp	@@scankey1
@@tr1_4r:
        mov     a       m15
        page3
        caje    #0001b  @@tr1r
        caje    #0010b  @@tr2r
        caje    #0100b  @@tr3r
        jmp     @@tr4r
@@tr5_8r:
        mov     a       m15
        page3
        caje    #0001b  @@tr5r
        caje    #0010b  @@tr6r
        caje    #0100b  @@tr7r
        jmp     @@tr8r
@@tr9_12r:
        mov     a       m15
        page3
        caje    #0001b  @@tr9r
        caje    #0010b  @@tr10r
        caje    #0100b  @@tr11r
        jmp     @@tr12r
@@tr13_16r:
        mov     a       m15
        page3
        caje    #0001b  @@tr13r
        caje    #0010b  @@tr14r
        caje    #0100b  @@tr15r
        jmp     @@tr16r
        
ifdef	mrx_2	
@@tr17_32r:	
	page0			
        mov     a       Keyid
        caje    #0001b  @@tr17_20r
        caje    #0010b  @@tr21_24r
        caje    #0100b  @@tr25_28r
	caje	#1000b  @@tr29_32r
ifdef	@_key_type_@				;add at 05-26'04 for mix key
	;caje	#0011b	@@Mtr2r
	caje	#0111b	@@Mtr3r
	caje	#1111b	@@Mtr6r
endif	
	jmp	@@scankey1
endif

ifdef	mrx_3	
@@tr33_48r:	
	page0			
        mov     a       Keyid
        caje    #0001b  @@tr33_36r
        caje    #0010b  @@tr37_40r
        caje    #0100b  @@tr41_44r
	caje	#1000b  @@tr45_48r
ifdef	@_key_type_@				;add at 05-26'04 for mix key
	;caje	#0011b	@@Mtr2r
	;caje	#0111b	@@Mtr3r
	caje	#1111b	@@Mtr6r
endif	
	jmp	@@scankey1
endif

ifdef	mrx_4	
@@tr49_64r:	
	page0			
        mov     a       Keyid
        caje    #0001b  @@tr49_52r
        caje    #0010b  @@tr53_56r
        caje    #0100b  @@tr57_60r
	caje	#1000b  @@tr61_64r
	jmp	@@scankey1
endif

        
        
ifdef	mrx_2
@@tr17_20r:
        mov     a       m15
        page3
        caje    #0001b  @@tr17r
        caje    #0010b  @@tr18r
        caje    #0100b  @@tr19r
        jmp     @@tr20r
@@tr21_24r:
        mov     a       m15
        page3
        caje    #0001b  @@tr21r
        caje    #0010b  @@tr22r
        caje    #0100b  @@tr23r
        jmp     @@tr24r
@@tr25_28r:
        mov     a       m15
        page3
        caje    #0001b  @@tr25r
        caje    #0010b  @@tr26r
        caje    #0100b  @@tr27r
        jmp     @@tr28r
@@tr29_32r:
        mov     a       m15
        page3
        caje    #0001b  @@tr29r
        caje    #0010b  @@tr30r
        caje    #0100b  @@tr31r
        jmp     @@tr32r
endif                
        
ifdef	mrx_3
@@tr33_36r:
        mov     a       m15
        page3
        caje    #0001b  @@tr33r
        caje    #0010b  @@tr34r
        caje    #0100b  @@tr35r
        jmp     @@tr36r
@@tr37_40r:
        mov     a       m15
        page3
        caje    #0001b  @@tr37r
        caje    #0010b  @@tr38r
        caje    #0100b  @@tr39r
        jmp     @@tr40r
@@tr41_44r:
        mov     a       m15
        page3
        caje    #0001b  @@tr41r
        caje    #0010b  @@tr42r
        caje    #0100b  @@tr43r
        jmp     @@tr44r
@@tr45_48r:
        mov     a       m15
        page3
        caje    #0001b  @@tr45r
        caje    #0010b  @@tr46r
        caje    #0100b  @@tr47r
        jmp     @@tr48r
endif  

ifdef	mrx_4
@@tr49_52r:
        mov     a       m15
        page3
        caje    #0001b  @@tr49r
        caje    #0010b  @@tr50r
        caje    #0100b  @@tr51r
        jmp     @@tr52r
@@tr53_56r:
        mov     a       m15
        page3
        caje    #0001b  @@tr53r
        caje    #0010b  @@tr54r
        caje    #0100b  @@tr55r
        jmp     @@tr56r
@@tr57_60r:
        mov     a       m15
        page3
        caje    #0001b  @@tr57r
        caje    #0010b  @@tr58r
        caje    #0100b  @@tr59r
        jmp     @@tr60r
@@tr61_64r:
        mov     a       m15
        page3
        caje    #0001b  @@tr61r
        caje    #0010b  @@tr62r
        caje    #0100b  @@tr63r
        jmp     @@tr64r
endif          
        
        

ifdef	@_key_type_@				;add at 05-26'04 for mix key
@@Mtr2r:
        mov     a       m15
        caje    #0001b  @@Mtr2_0r
        caje    #0010b  @@Mtr2_1r
        caje    #0100b  @@Mtr2_2r
        caje	#1000b  @@Mtr2_3r
	jmp	@@scankey1
@@Mtr3r:
        mov     a       m15
        caje    #0001b  @@Mtr3_0r
        caje    #0010b  @@Mtr3_1r
        caje    #0100b  @@Mtr3_2r
        caje	#1000b  @@Mtr3_3r
	jmp	@@scankey1
@@Mtr6r:
        mov     a       m15
        caje    #0001b  @@Mtr6_0r
        caje    #0010b  @@Mtr6_1r
        caje    #0100b  @@Mtr6_2r
        caje	#1000b  @@Mtr6_3r
	jmp	@@scankey1	
	
endif

@@trh2l_run:
ifdef	mrx_2
	page0
	mov	a	skblock
	caje	#0001b	@@tr17_32f
ifdef	mrx_3
	caje	#0010b	@@tr33_48f
ifdef	mrx_4
	caje	#0011b	@@tr49_64f
endif
endif 	;mrx_3
endif 	;mrx_2

        mov     a       KeyID
        caje    #0001b  @@tr1_4f
        caje    #0010b  @@tr5_8f
        caje    #0100b  @@tr9_12f
	caje	#1000b  @@tr13_16f
ifdef	@_key_type_@				;add at 05-26'04 for mix key
	caje	#0011b	@@Mtr2f
	caje	#0111b	@@Mtr3f
	caje	#1111b	@@Mtr6f
endif
	jmp	@@scankey1
	
ifdef	mrx_2	
@@tr17_32f:	
	page0			
        mov     a       Keyid
        caje    #0001b  @@tr17_20f
        caje    #0010b  @@tr21_24f
        caje    #0100b  @@tr25_28f
	caje	#1000b  @@tr29_32f
ifdef	@_key_type_@				;add at 05-26'04 for mix key
	caje	#0011b	@@Mtr2f
	caje	#0111b	@@Mtr3f
	caje	#1111b	@@Mtr6f
endif	
	jmp	@@scankey1
endif

ifdef	mrx_3	
@@tr33_48f:	
	page0			
        mov     a       Keyid
        caje    #0001b  @@tr33_36f
        caje    #0010b  @@tr37_40f
        caje    #0100b  @@tr41_44f
	caje	#1000b  @@tr45_48f
ifdef	@_key_type_@				;add at 05-26'04 for mix key
	caje	#0011b	@@Mtr2f
	caje	#0111b	@@Mtr3f
	caje	#1111b	@@Mtr6f
endif	
	jmp	@@scankey1
endif

ifdef	mrx_4	
@@tr49_64f:	
	page0			
        mov     a       Keyid
        caje    #0001b  @@tr49_52f
        caje    #0010b  @@tr53_56f
        caje    #0100b  @@tr57_60f
	caje	#1000b  @@tr61_64f
ifdef	@_key_type_@				;add at 05-26'04 for mix key
	caje	#0011b	@@Mtr2f
	caje	#0111b	@@Mtr3f
	caje	#1111b	@@Mtr6f
endif	
	jmp	@@scankey1
endif

@@tr1_4f:
        mov     a       m15
        page3
        caje    #0001b  @@tr1f
        caje    #0010b  @@tr2f
        caje    #0100b  @@tr3f
        jmp     @@tr4f
@@tr5_8f:
        mov     a       m15
        page3
        caje    #0001b  @@tr5f
        caje    #0010b  @@tr6f
        caje    #0100b  @@tr7f
        jmp     @@tr8f
@@tr9_12f:
        mov     a       m15
        page3
        caje    #0001b  @@tr9f
        caje    #0010b  @@tr10f
        caje    #0100b  @@tr11f
        jmp     @@tr12f
@@tr13_16f:
        mov     a       m15
        page3
        caje    #0001b  @@tr13f
        caje    #0010b  @@tr14f
        caje    #0100b  @@tr15f
        jmp     @@tr16f
        
ifdef	mrx_2
@@tr17_20f:
        mov     a       m15
        page3
        caje    #0001b  @@tr17f
        caje    #0010b  @@tr18f
        caje    #0100b  @@tr19f
        jmp     @@tr20f
@@tr21_24f:
        mov     a       m15
        page3
        caje    #0001b  @@tr21f
        caje    #0010b  @@tr22f
        caje    #0100b  @@tr23f
        jmp     @@tr24f
@@tr25_28f:
        mov     a       m15
        page3
        caje    #0001b  @@tr25f
        caje    #0010b  @@tr26f
        caje    #0100b  @@tr27f
        jmp     @@tr28f
@@tr29_32f:
        mov     a       m15
        page3
        caje    #0001b  @@tr29f
        caje    #0010b  @@tr30f
        caje    #0100b  @@tr31f
        jmp     @@tr32f
endif                
        
ifdef	mrx_3
@@tr33_36f:
        mov     a       m15
        page3
        caje    #0001b  @@tr33f
        caje    #0010b  @@tr34f
        caje    #0100b  @@tr35f
        jmp     @@tr36f
@@tr37_40f:
        mov     a       m15
        page3
        caje    #0001b  @@tr37f
        caje    #0010b  @@tr38f
        caje    #0100b  @@tr39f
        jmp     @@tr40f
@@tr41_44f:
        mov     a       m15
        page3
        caje    #0001b  @@tr41f
        caje    #0010b  @@tr42f
        caje    #0100b  @@tr43f
        jmp     @@tr44f
@@tr45_48f:
        mov     a       m15
        page3
        caje    #0001b  @@tr45f
        caje    #0010b  @@tr46f
        caje    #0100b  @@tr47f
        jmp     @@tr48f
endif  

ifdef	mrx_4
@@tr49_52f:
        mov     a       m15
        page3
        caje    #0001b  @@tr49f
        caje    #0010b  @@tr50f
        caje    #0100b  @@tr51f
        jmp     @@tr52f
@@tr53_56f:
        mov     a       m15
        page3
        caje    #0001b  @@tr53f
        caje    #0010b  @@tr54f
        caje    #0100b  @@tr55f
        jmp     @@tr56f
@@tr57_60f:
        mov     a       m15
        page3
        caje    #0001b  @@tr57f
        caje    #0010b  @@tr58f
        caje    #0100b  @@tr59f
        jmp     @@tr60f
@@tr61_64f:
        mov     a       m15
        page3
        caje    #0001b  @@tr61f
        caje    #0010b  @@tr62f
        caje    #0100b  @@tr63f
        jmp     @@tr64f
endif         
        

ifdef	@_key_type_@				;add at 05-26'04 for mix key
@@Mtr2f:
        mov     a       m15
        caje    #0001b  @@Mtr2_0f
        caje    #0010b  @@Mtr2_1f
        caje    #0100b  @@Mtr2_2f
        caje	#1000b  @@Mtr2_3f
	jmp	@@scankey1
@@Mtr3f:
        mov     a       m15
        caje    #0001b  @@Mtr3_0f
        caje    #0010b  @@Mtr3_1f
        caje    #0100b  @@Mtr3_2f
        caje	#1000b  @@Mtr3_3f
	jmp	@@scankey1
@@Mtr6f:
        mov     a       m15
        caje    #0001b  @@Mtr6_0f
        caje    #0010b  @@Mtr6_1f
        caje    #0100b  @@Mtr6_2f
        caje	#1000b  @@Mtr6_3f
	jmp	@@scankey1	
endif


;**********************************************
;##########################################
;   -------- Random Routine --------
;========================================
;----------------------------------------
Check_Random:
        page2
        mov     a       Rand0Max
        caje    #0      @@ChkRand1
        mov     a       Rand0
        caje    Rand0Max @@RstRand0
        inca
        mov     Rand0   a
        jmp     @@Check_Random_Bk
@@RstRand0:
        mov     Rand0   #0
@@ChkRand1:
        mov     a       Rand1Max
;        caje    #0      @@ChkRand2
        caje    #0      @@Check_Random_Bk
        mov     a       Rand1
        caje    Rand1Max @@RstRand1
        inca
        mov     Rand1   a
        jmp     @@Check_Random_Bk
@@RstRand1:
        mov     Rand1   #0
;@@ChkRand2:
;        mov     a       Rand2Max
;        caje    #0      @@Check_Random_Bk
;        mov     a       Rand2
;        caje    Rand2Max @@RstRand2
;        inca
;        mov     Rand2   a
;        jmp     @@Check_Random_Bk
;@@RstRand2:
;        mov     Rand2   #0
        jmp     @@Check_Random_Bk


;#################################################################
;###############  Function Call for EZ program.   ################
;#################################################################

;##########################################
;   -------- Check Voice Play --------
;========================================
;
;----------------------------------------
@@chk_voc1:                       ;ch1,Play
	page5
ifdef  @@_EZ_IO_@@	
        mov	a	#0100b
        and	a	EZIO_flag
        caje	#0100b	@f
	DisableEZIO_@@
@@:	
endif
	mov	Next_flag #0
	mov	a	#0
	mov	next	a
	mov	nxtply	a
	
        page0
        mov     a       #0001b
        and     a       4mto8m	;m14 2005/5/30 03:49U check head code played
        caje    #0001b  @@s_h_ok1

         ; Turn ON Push_Pull OP1
        mov	A,#0100B
        mov	mode1,a

        Play   sn0#xo.wav
@@wait_s_h1:
        CJP    @@wait_s_h1
        
        ; Turn ON Push_Pull OP1 & OP2
        mov	A,#1100B
        mov	mode1,a
        
        mov     a       #0001b
        or      a       4mto8m	;m14 2005/5/30 03:50U set head play
        mov     4mto8m     a	;2005/5/30 03:50U
@@s_h_ok1:
        VolDown				;\ 
;        Play   sil#xo.wav		 ;| Add by Allan (1/3/05), downcount Volume to
;@@Silence_NotOK1:			 ;| prevent "Bo".
;	cjp	@@Silence_NotOK1	;/
	
        page0
        ;mov	a,#0111b		;\
        mov	a,VolValue_Page0	 ;| Add by Allan (1/3/05), Restore Master Volume to MODE
        mov	mode,a			;/
	
	
	
        mov     a       #0001b
        or      a       v_state
        mov     v_state a
        page1
        mov     delay8m #0000b

        page3
        ret1

;##########################################
;   -------- Clear Enter B routine --------
;========================================
;
;----------------------------------------
;*********************************
@@clear_enter_b1:
        page2
        mov     a       #1011b
        and     a       enter_b
        mov     enter_b a
        ret1
;*********************************
@@clear_enter_b2:
        page2
        mov     a       #0111b
        and     a       enter_b
        mov     enter_b a
        ret1
;*********************************
@@clear_enter_p1:
        page2
        mov     a       #1011b
        and     a       enter_b
        mov     enter_b a
        ret2
;*********************************
@@clear_enter_p2:
        page2
        mov     a       #0111b
        and     a       enter_b
        mov     enter_b a
        ret2
;**********************************************

;##########################################
;   -------- Check Voice P1  --------
;========================================
;
;----------------------------------------
@@chk_voc_P1:                       ;ch1,background Play
	DisableEZIO_@@
	page5
	mov	Next_flag #0
	mov	a	#0
	mov	next	a
	mov	nxtply	a
        page0
        mov     a       #0001b
        and     a       4mto8m	;m14 2005/5/30 03:50U check head code have play
        caje    #0001b  @@s_h_ok_p1

        ; Turn ON Push_Pull OP1
        mov	A,#0100B
        mov	mode1,a

        Play   sn0#xo.wav
@@wait_s_h_p1:
        CJP    @@wait_s_h_p1
        
        ; Turn ON Push_Pull OP1 & OP2
        mov	A,#1100B
        mov	mode1,a
        
        mov     a       #0001b
        or      a       4mto8m	;m14 2005/5/30 03:51U set head code play
        mov     4mto8m     a 	;2005/5/30 03:51U

@@s_h_ok_p1:
        mov     a       #0001b
        or      a       v_state
        mov     v_state a
        page2
        mov     p_delay1 #0000b
        page3
        ret2

;##########################################
;   -------- Stop Pb  --------
;========================================
;
;----------------------------------------
@@stop_pb:
        page0
        mov     a       #0101b
        and	a	v_state
        caje    #0000b  @@no_s
        mov     a       #0100b
        and     a       v_state
        caje    #0100b  @@js_stv1
        jmp     @@no_ss
@@js_stv1:
        ;mov     a       #0101b
        ;and     a       v_state
        ;mov     v_state a
        stop
        Play   sil#xo.wav
        jmp     @@no_s1
@@no_s1:

        mov     a       #1011b
        and     a       v_state
        mov     v_state a
        jmp     @@no_ss
@@no_s:
        mov     a       #1110b
        and     a       v_state
        mov     v_state a
@@no_ss:
        page2
        mov     p_delay1 #0000b
        page3
        ret2

;##########################################
;   -------- Stop  --------
;========================================
; force all stop
;----------------------------------------
@@stop:
	DisableEZIO_@@
        page0
        mov	a	#0000b
        mov	ret_flag	a	; clear Play & delay & ezio ret_flag
	page5
	mov	Next_flag #0
	mov	a	PWMIOEN1
	mov	PWMIOEN1 #0
	page0
	xor	a	p3state
	mov	p3state	a
	
	mov	a	#0
	mov	PIO_en	a
        page0
        mov     a       #0101b
        and	a	v_state
        caje    #0000b  @@nov
        ;2006/8/31 06:14U
        mov	a	#0
        mov	next	a
        mov	nxtply	a
        VolDown				;\ 	
        stop
        Play   sil#xo.wav		 ;| Add by Allan (1/3/05), downcount Volume to
@@Silence_NotOK:			 ;| prevent "Bo".
	cjp	@@Silence_NotOK		;/
@@nov:
        mov	a	#1010b
        and	a	v_state
        mov     v_state	a
        page1
        mov     delay8m #0000b
        mov     s_delay1 #0000b
	mov	BGround1	#0000b		;add at 03/17'04 for clear background output		
	mov	BGround2        #0000b		;add at 03/17'04 for clear background output
        page2
        mov     p_delay1 #0000b
        mov     enter_b #0000b
        page0
        ;mov	a,#0111b		;\
        mov	a,VolValue_Page0	 ;| Add by Allan (1/3/05), Restore Master Volume to MODE
        mov	mode,a			;/

        page3
        ret1

;##########################################
;   -------- Stop V --------
;========================================
; force all voice stop
;----------------------------------------
@@stop_v:
	DisableEZIO_@@
        page0
;// clr ezio ret_flag if ezio ret is active
        mov	a	#1100b
        and	a	ret_flag
        caje	#0100b	@clr_bg_ezio
        jmp	@check_fg_ezio
@clr_bg_ezio:
	mov	a	#0011b
	and	a	ret_flag
	mov	ret_flag	a
@check_fg_ezio:
        mov	a	#0011b
        and	a	ret_flag
        caje	#0001b	@clr_fg_ezio
        jmp	@stop_v_2
@clr_fg_ezio:
	mov	a	#1100b
	and	a	ret_flag
	mov	ret_flag	a
;//////////////////////////////////////////////////
@stop_v_2:
        mov	a	#0101b
        and	a	v_state
        caje    #0000b  @@no_allvoice
        stop
        Play   sil#xo.wav
@@no_allvoice:
	mov	a	#1010b
	and	a	v_state
        mov     v_state	a
        page2
        mov     p_delay1 #0000b
        mov     enter_b #0000b
        page3
        ret1
;##########################################
;   -------- Stop  O --------
;========================================
; force background output stop
;----------------------------------------
@@stop_o1:
        page1
        mov     s_delay1        #0000b
	mov	BGround1	#0000b		;add at 03/17'04 for clear background output		
	mov	BGround2        #0000b		;add at 03/17'04 for clear background output
        page3
        ret3
@@stop_o2:
        page1
        mov     s_delay1        #0000b
	mov	BGround1	#0000b		;add at 03/17'04 for clear background output		
	mov	BGround2        #0000b		;add at 03/17'04 for clear background output
        page3
        ret3
;*************************************************************

;##########################################
;   -------- TailXO  --------
;========================================
;
;----------------------------------------

@@tailXO:                       ;only in ch1(not in path background)

        page0
        mov     a       #0001b
        and     a       4mto8m	;m14 2005/5/30 03:51U check head played
        caje    #0000b,@@no_tail

 ; Turn OFF Push_Pull OP2
        mov	A,#0100B
        mov	mode1,a

        Play   sn1#xo.wav

        mov     a       #1110b
        and     a       4mto8m	;m14 2005/5/30 03:52U clr head code play flag
        mov     4mto8m     a	; 2005/5/30 03:52U
@@wait_t2:
        CJP    @@wait_t2
        
        ; Turn OFF Push_Pull OP1 & OP2
        mov	A,#0000B
        mov	mode1,a
@@no_tail:
        page3
        ret1
        
;#######################################################################
;       IR Function
;#######################################################################

;##################################################################
;       MACRO
;##################################################################
;--------------------------------------------------------------
;--------------------------------------------------------------
;;;; 1ms
@@@RECEIVE_1ms  MACRO
        @@@DELAY_500us
        @@@DELAY_500us
        MOV    A,P3
        ENDM

;--------------------------------------------------------------
;--------------------------------------------------------------
;;; 700 / 4 === 175
; 1+13*12+12+6 =175
@@@RECEIVE_700us          MACRO
	page1
        MOV     Time_Counter , #0011b	;_INV_700us   ; 3
@@:
        NOP                        ; 1
        NOP                        ; 1
        NOP                        ; 1
        NOP                        ; 1
        NOP                        ; 1
        NOP                        ; 1
        MOV     A,Time_Counter   ; 1
        INCA                       ; 1
        MOV     Time_Counter,A   ; 1
        CAJE    #0,@F              ; 3
        JMP     @B                 ; 2
@@:
        NOP                        ; 1
        NOP                        ; 1
        NOP                        ; 1
        NOP                        ; 1
        ;NOP                        ; 1
        MOV    A,P3                ; 1
        ENDM


;--------------------------------------------------------------
;--------------------------------------------------------------
;; 500 us / 4 =125
@@@DELAY_500us  MACRO
	page1 			; 20080409 clayton
        MOV     Time_Counter ,#0001b	;_INV_500us    ; 1
@@:
        MOV     A,Time_Counter   ; 1
        INCA                       ; 1
        MOV     Time_Counter,A   ; 1
        CAJE    #0,@F              ; 3
        JMP     @B                 ; 2
@@:
        NOP
        NOP
        NOP
        NOP
        NOP
        NOP
        ENDM



;--------------------------------------------------------------
;--------------------------------------------------------------
@@@IR_RX_DATA     MACRO   VALUE,MEM
        @@@RECEIVE_1ms
        page0
        AND     A,temp2_0
        page5
        CAJE    #0,@F
        MOV     A,VALUE
        OR      A,MEM
        MOV     MEM,A
@@:
        JMP     @Ready_RECEIVE_IR_AGAIN
        ENDM


;--------------------------------------------------------------
;--------------------------------------------------------------
@@@Send_Carrier       MACRO
        MOV     A,#0111B
        MOV     P3S,A
        PAGE0
        MOV     A,#1000B
        OR      A,p3state
        MOV     P3,A
        PAGE1
        ENDM


;--------------------------------------------------------------
;--------------------------------------------------------------
@@@Send_Low           MACRO
        PAGE0
        MOV     A,#0111B
        AND     A,p3state
        MOV     P3,A
        PAGE1
        ENDM


@@@DETERMINE_IR_RX_DATA   MACRO  NAME
;-------------------------------------------------
;       Receive Data = 0E? H
;-------------------------------------------------
@@RECEIVE_H&NAME:
        MOV     A,RECEIVE_L
        CAJE    #00H , @@RECEIVE_H&NAME&L0
        CAJE    #01H , @@RECEIVE_H&NAME&L1
        CAJE    #02H , @@RECEIVE_H&NAME&L2
        CAJE    #03H , @@RECEIVE_H&NAME&L3
        CAJE    #04H , @@RECEIVE_H&NAME&L4
        CAJE    #05H , @@RECEIVE_H&NAME&L5
        CAJE    #06H , @@RECEIVE_H&NAME&L6
        CAJE    #07H , @@RECEIVE_H&NAME&L7
        CAJE    #08H , @@RECEIVE_H&NAME&L8
        CAJE    #09H , @@RECEIVE_H&NAME&L9
        CAJE    #0AH , @@RECEIVE_H&NAME&LA
        CAJE    #0BH , @@RECEIVE_H&NAME&LB
        CAJE    #0CH , @@RECEIVE_H&NAME&LC
        CAJE    #0DH , @@RECEIVE_H&NAME&LD
        CAJE    #0EH , @@RECEIVE_H&NAME&LE
        JMP            @@RECEIVE_H&NAME&LF
        ENDM







;#####################################################################
;#####################################################################
;#####################################################################
;#####################################################################
ifdef   IR_Transmit

;;; 6ms  ...... Start bit
;;;
;;; ###### SEND IR !!! ######
;;; ###### SEND IR !!! ######
;;; ###### SEND IR !!! ######
;; INPUT :   TRANS_H,TRANS_L


@IR_TRANSMIT:
        PAGE5
        MOV     A,#0001B
        AND     A,IRout_ON_OFF_5_0
        CAJE    #0,@IR_TRANSMIT_OK
;;;;;;;; 6 ms carrier ..... receive "L"
@SEND_IR_START:
;;;;;;;; start bit
;;;;;;; 500 us * 12 =  6 ms
        @@@Send_Carrier
        @@@DELAY_500us
        @@@DELAY_500us
        @@@DELAY_500us
        @@@DELAY_500us
        @@@DELAY_500us
        @@@DELAY_500us
        @@@DELAY_500us
        @@@DELAY_500us
        @@@DELAY_500us
        @@@DELAY_500us
        @@@DELAY_500us
        @@@DELAY_500us

        MOV     TRANS_COUNT_1,#0
@IR_TRANSMIT_AGAIN:
        MOV     A,TRANS_COUNT_1
        INCA
        MOV     TRANS_COUNT_1,A
        page5
        CAJE    #1  , @IS_IR_TRANS_H1
        CAJE    #2  , @IS_IR_TRANS_H2
        CAJE    #3  , @IS_IR_TRANS_H3
        CAJE    #4  , @IS_IR_TRANS_H4
        CAJE    #5  , @IS_IR_TRANS_L1
        CAJE    #6  , @IS_IR_TRANS_L2
        CAJE    #7  , @IS_IR_TRANS_L3
        CAJE    #8  , @IS_IR_TRANS_L4

        PAGE5
        MOV     A,#1110B
        AND     A,IRout_ON_OFF_5_0
        MOV     IRout_ON_OFF_5_0,A

        PAGE0
        MOV     A,P3STATE
        MOV     P3,A
        MOV     A,#1111B
        MOV     P3S,A
        JMP     @IR_TRANSMIT_OK


@IS_IR_TRANS_L4:
        MOV     A,#0001B
        JMP     @IS_IR_TRANS_L
@IS_IR_TRANS_L3:
        MOV     A,#0010B
        JMP     @IS_IR_TRANS_L
@IS_IR_TRANS_L2:
        MOV     A,#0100B
        JMP     @IS_IR_TRANS_L
@IS_IR_TRANS_L1:
        MOV     A,#1000B
@IS_IR_TRANS_L:
        AND     A,TRANS_L
        JMP     @READY_TO_TRANS_IR

@IS_IR_TRANS_H4:
        MOV     A,#0001B
        JMP     @IS_IR_TRANS_H
@IS_IR_TRANS_H3:
        MOV     A,#0010B
        JMP     @IS_IR_TRANS_H
@IS_IR_TRANS_H2:
        MOV     A,#0100B
        JMP     @IS_IR_TRANS_H
@IS_IR_TRANS_H1:
        MOV     A,#1000B
@IS_IR_TRANS_H:
        AND     A,TRANS_H
@READY_TO_TRANS_IR:
        CAJE    #0,@IR_SEND_0
        JMP     @IR_SEND_1
@IR_SEND_0:
        @@@Send_Low
        @@@Delay_500us
        @@@Send_Carrier
        @@@Delay_500us
        @@@Delay_500us
        @@@Delay_500us
        JMP     @IR_TRANSMIT_AGAIN

@IR_SEND_1:
        @@@Send_Low
        @@@Delay_500us
        @@@Delay_500us
        @@@Delay_500us
        @@@Send_Carrier
        @@@Delay_500us
        JMP     @IR_TRANSMIT_AGAIN

endif



ifdef   IR_Receive
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;      IR  receive mode
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@IR_RECEIVE:
        PAGE5
        mov     a,#0100b
        and     a,IRin_ON_OFF_5_2
        caje    #0100B,@F

        MOV     A,#1101B
        AND     A,TRIGGER_FLAG_5_1
        MOV     TRIGGER_FLAG_5_1,A
        JMP     @IR_RECEIVE_OK
@@:
        
        MOV     RECEIVE_L,#0
        MOV     RECEIVE_H,#0

;;; ###### RECEIVE IR !!! ######
@@WWAIT_WAKEUP_SIGNAL:
	page0
;;?????????????????
;;      RX= P3.3 or P3.2
        MOV     temp2_0,_RX_DATA
;;?????????????????

        MOV     A,P3
        AND     A,temp2_0
        CAJE    #0,@MMAYBE_HEAD
        JMP     @SKIP_RECEIVE_IR
@MMAYBE_HEAD:

        PAGE5
        mov     a,#0010b
        and     a,TRIGGER_FLAG_5_1
        caje    #0,@f
;;;;;; DELAY FOR WAKE-UP
;; warm_up time= 4 ms
;;;;; 550 us * (16-14)= 1100 us
        MOV     A,#1101B
        AND     A,TRIGGER_FLAG_5_1
        MOV     TRIGGER_FLAG_5_1,A

        PAGE1
        MOV     RECEIVE_COUNT_1,#14
        JMP     @WAIT_START_SIGNAL

@@:
;;;;;;; 550 us * (16-8)
        PAGE1
        MOV     RECEIVE_COUNT_1,#8
@WAIT_START_SIGNAL:
        @@@DELAY_500us
        MOV     A,RECEIVE_COUNT_1
        INCA
        MOV     RECEIVE_COUNT_1,A
        CAJE    #0,@READY_TO_RECEIVE_IR
        MOV     A,P3
        page0
        AND     A,temp2_0
        page1
        CAJE    #0,@WAIT_START_SIGNAL
@SKIP_RECEIVE_IR:
        JMP     @IR_RECEIVE_OK

@READY_TO_RECEIVE_IR:
  ;     @@@DELAY_500us
        MOV    A,P3
        page0
        AND     A,temp2_0
        CAJE    #0,@TO_RECEIVE_IR
        JMP     @@WWAIT_WAKEUP_SIGNAL

@TO_RECEIVE_IR:
;;;;;;;; First receive IR  ;;;;;;;;;;;;;;;
;;;;;;;; First receive IR  ;;;;;;;;;;;;;;;
;;;;;;;; First receive IR  ;;;;;;;;;;;;;;;
	page1

        MOV     RECEIVE_COUNT_1,#0
;;;;;;;;;;;;;; DATA 1
@RECEIVE_IR_AGAIN:
@@:
        MOV     A,P3                 ; 1
        page0
        AND     A,temp2_0              ; 1
        CAJE    _RX_DATA,@F          ; 3
        JMP     @B                   ; 2
@@:
        page1
        MOV     A,RECEIVE_COUNT_1
        INCA
        MOV     RECEIVE_COUNT_1,A
        CAJE    #1  , @IS_IR_RX_1
        CAJE    #2  , @IS_IR_RX_2
        CAJE    #3  , @IS_IR_RX_3
        CAJE    #4  , @IS_IR_RX_4
        CAJE    #5  , @IS_IR_RX_5
        CAJE    #6  , @IS_IR_RX_6
        CAJE    #7  , @IS_IR_RX_7
        CAJE    #8  , @IS_IR_RX_8

@IS_IR_RX_1:
        @@@IR_RX_DATA   #1000B,RECEIVE_H
        JMP     @RECEIVE_IR_AGAIN

@IS_IR_RX_2:
        @@@IR_RX_DATA   #0100B,RECEIVE_H
        JMP     @RECEIVE_IR_AGAIN

@IS_IR_RX_3:
        @@@IR_RX_DATA   #0010B,RECEIVE_H
        JMP     @RECEIVE_IR_AGAIN

@IS_IR_RX_4:
        @@@IR_RX_DATA   #0001B,RECEIVE_H
        JMP     @RECEIVE_IR_AGAIN

@IS_IR_RX_5:
        @@@IR_RX_DATA   #1000B,RECEIVE_L
        JMP     @RECEIVE_IR_AGAIN

@IS_IR_RX_6:
        @@@IR_RX_DATA   #0100B,RECEIVE_L
        JMP     @RECEIVE_IR_AGAIN
@IS_IR_RX_7:
        @@@IR_RX_DATA   #0010B,RECEIVE_L

@Ready_RECEIVE_IR_AGAIN:
        @@@RECEIVE_700us
        page0
        AND     A,temp2_0
        CAJE    #0,@RECEIVE_IR_AGAIN

;;;;;;;  RECEIVE IR DATA ERROR  ;;;;;;;;
        JMP     @@RECEIVE_HFLF

@IS_IR_RX_8:
;;;;;;  @@@IR_RX_DATA   #0001B,RECEIVE_L
        @@@RECEIVE_1ms
         
       
        page0
        AND     A,temp2_0
        CAJE    #0,@F
        MOV     A,#0001B
        page5
        OR      A,RECEIVE_L
        MOV     RECEIVE_L,A
@@:
;;;;############################################
;;;;############################################
;;;;    Determine receive IR code
;;;;############################################
;;;;############################################
        page5
        MOV     A,RECEIVE_H
        CAJE    #00H , @@RECEIVE_H0
        CAJE    #01H , @@RECEIVE_H1
        CAJE    #02H , @@RECEIVE_H2
        CAJE    #03H , @@RECEIVE_H3
        CAJE    #04H , @@RECEIVE_H4
        CAJE    #05H , @@RECEIVE_H5
        CAJE    #06H , @@RECEIVE_H6
        CAJE    #07H , @@RECEIVE_H7
        CAJE    #08H , @@RECEIVE_H8
        CAJE    #09H , @@RECEIVE_H9
        CAJE    #0AH , @@RECEIVE_HA
        CAJE    #0BH , @@RECEIVE_HB
        CAJE    #0CH , @@RECEIVE_HC
        CAJE    #0DH , @@RECEIVE_HD
        CAJE    #0EH , @@RECEIVE_HE
        JMP            @@RECEIVE_HF

        @@@DETERMINE_IR_RX_DATA  0
        @@@DETERMINE_IR_RX_DATA  1
        @@@DETERMINE_IR_RX_DATA  2
        @@@DETERMINE_IR_RX_DATA  3
        @@@DETERMINE_IR_RX_DATA  4
        @@@DETERMINE_IR_RX_DATA  5
        @@@DETERMINE_IR_RX_DATA  6
        @@@DETERMINE_IR_RX_DATA  7
        @@@DETERMINE_IR_RX_DATA  8
        @@@DETERMINE_IR_RX_DATA  9
        @@@DETERMINE_IR_RX_DATA  A
        @@@DETERMINE_IR_RX_DATA  B
        @@@DETERMINE_IR_RX_DATA  C
        @@@DETERMINE_IR_RX_DATA  D
        @@@DETERMINE_IR_RX_DATA  E
;;;;;;  @@@DETERMINE_IR_RX_DATA  F
@@RECEIVE_HF:
	page5
        MOV     A,RECEIVE_L
        CAJE    #00H , @@RECEIVE_HFL0
        CAJE    #01H , @@RECEIVE_HFL1
        CAJE    #02H , @@RECEIVE_HFL2
        CAJE    #03H , @@RECEIVE_HFL3
        CAJE    #04H , @@RECEIVE_HFL4
        CAJE    #05H , @@RECEIVE_HFL5
        CAJE    #06H , @@RECEIVE_HFL6
        CAJE    #07H , @@RECEIVE_HFL7
        CAJE    #08H , @@RECEIVE_HFL8
        CAJE    #09H , @@RECEIVE_HFL9
        CAJE    #0AH , @@RECEIVE_HFLA
        CAJE    #0BH , @@RECEIVE_HFLB
        CAJE    #0CH , @@RECEIVE_HFLC
        CAJE    #0DH , @@RECEIVE_HFLD
        CAJE    #0EH , @@RECEIVE_HFLE
        CAJE    #0FH , @@RECEIVE_HFLF
        JMP     @IR_RECEIVE_OK

endif        



ifdef  @@_EZ_IO_@@
Check_EZIO_Delay:
	page5 
	mov	a	EZIO_flag
	caje	#0000b	@@Check_EZIO_Delay_bk
	mov	a	EZIO_timerH		; clayton 20080416

	caje	#0000b	@f
	jmp	@@delayIO
@@:
	mov	a	EZIO_timerL		; clayton 20080416
	caje	#0000b	@@EZIO_Item		; clayton 20080416
	
@@delayIO:	
	page5
        mov     a       EZIO_timerL
        inca
        mov     EZIO_timerL a
        caje    #0000b  @@IO01_sec
        jmp	@@Check_EZIO_Delay_bk
@@IO01_sec:
        mov     a       EZIO_timerH
        inca
        mov     EZIO_timerH a           
        caje    #0000b  @@EZIO_Item
        jmp	@@Check_EZIO_Delay_bk
	
@@EZIO_end:

	DisableEZIO_@@
        page5
        mov  a       #0010b
        or      a       EventFlag			;bit1=1 of EventFlag no read event mark
        mov  EventFlag a 
	jmp	@@Check_EZIO_Delay_bk

@@EZIO_Item:
	rcode
	page7
	mov	temp6	a
	page0
	mov	a	fra1
	mov	temp2	a
	mov	a	#0011b
	and	a	temp2
	caje	#0000b 	@@Load_EZIO_Timer
	caje	#0001b	@@Load_IO_data
	caje	#0010b	@@load_PWMIO

	mov	a	fra2
	caje	#0000b	@@Load_EZIO_mark1		;for e0~e15
;	caje	#0001b	@@Load_EZIO_mark2		;for e16~e31
;	caje	#0010b	@@Load_EZIO_mark3		;for e32~e47
;	caje	#0011b	@@Load_EZIO_mark4		;for e48~e63
	caje	#0100b	@@Extend_Head_EZIO_Timer
	caje	#1000b	@@Extend_Tail	
	caje	#1111b	@@EZIO_end
	jmp	@@EZIO_Item
@@EZIO_BK:	
	page5
	mov	a	EZIO_flag
	caje	#0011b 	@f
	caje	#0111b	@@no_wave_ezio
	caje	#1011b	@@wave_ezio_event
	caje	#1111b	@@no_wave_ezio_event
	jmp	@@Check_EZIO_Delay_bk
@@:
	page5
	mov	EZIO_flag	#0001b		;clear EZIO flag
	page0
	mov	a	#0010b
	and	a	EZIO_FG
	caje	#0000b	@@wave_ezio_ret2	
	page5
	ret1
@@wave_ezio_ret2:
	page5
	ret2	
@@no_wave_ezio:
	page5
	mov	EZIO_flag	#0101b		;clear EZIO flag
;	ret1						;return to main loop
	page0
	mov	a	#0010b
	and	a	EZIO_FG
	caje	#0000b	@@no_wave_ezio_ret2
	page5
	ret1
@@no_wave_ezio_ret2:
	page5
	ret2
	
@@wave_ezio_event:
	page5
	mov	EZIO_flag	#1001b		;clear EZIO flag
;	ret1						;return to main loop
	page0
	mov	a	#0010b
	and	a	EZIO_FG
	caje	#0000b	@@wave_ezio_event_ret2
	page5
	ret1
@@wave_ezio_event_ret2:
	page5
	ret2
@@no_wave_ezio_event:
	page5
	mov	EZIO_flag	#1101b		;clear EZIO flag
;	ret1						;return to main loop
	page0
	mov	a	#0010b
	and	a	EZIO_FG
	caje	#0000b	@@no_wave_ezio_event_ret2
	page5
	ret1
@@no_wave_ezio_event_ret2:
	page5
	ret2	
		
@@Load_EZIO_Timer:
	page7
	mov	a	temp6
	page5
	mov	EZIO_timerL	a
	mov	a	fra2
	mov	EZIO_timerH	a
	
	jmp	@@EZIO_BK

@@Extend_Head_EZIO_Timer:
	page7					;load EZIO timer count value
	mov	a	temp6
	page5
	mov	EZIO_timerL	a			; Extend TimerL
	rcode					; Next word is TimerH
	mov	EZIO_timerH	a			; Load TimerH into EZIO_timerH
	rstcf
	jmp	@@SCANKEY1

@@Extend_tail:
	page5
	mov	EZIO_flag	#0111b
	jmp	@@EZIO_Item

@@Load_EZIO_mark1:				;Event mark flag setting & e0~e15 information setting
	page5
	mov	EZ_MarkH	#0000b		; because bit0&1 will "and" with Fra3 bit0&1, so set "high" 
	jmp	@@Load_EZIO_mark	
;@@Load_EZIO_mark2:				;Event mark flag setting & e16~e31 information setting
;	page5
;	mov	EZ_MarkH	#0001b		; because bit0&1 will "and" with Fra3 bit0&1, so set "high" 
;	jmp	@@Load_EZIO_mark	
;@@Load_EZIO_mark3:				;Event mark flag setting & e32~e47 information setting
;	page5
;	mov	EZ_MarkH	#0010b		; because bit0&1 will "and" with Fra3 bit0&1, so set "high" 
;	jmp	@@Load_EZIO_mark	
;@@Load_EZIO_mark4:				;Event mark flag setting & e48~e63 information setting
;	page5
;	mov	EZ_MarkH	#0011b		; because bit0&1 will "and" with Fra3 bit0&1, so set "high" 
;	jmp	@@Load_EZIO_mark	
	
@@Load_EZIO_mark:

	page7

	mov	a	temp6
	page5
	mov	EZ_Mark	a		
	mov	a	#1000b
	or	a	EZIO_flag
	mov	EZIO_flag	a
	jmp	@@EZIO_Item		

@@load_PWMIO:
	page7
	mov	a	temp6
	caje	#0011b	@@EZ_P3_PWM
;	caje	#0110b	@@EZ_P6_PWM		
@@not_P3_P6:
	page0
	mov	a	fra2
	mov	temp2	#1000b
	and	a	temp2
	caje	#0000b	read_1T
	rcode
	rcode
read_1T:
	rcode
	jmp	@@EZIO_Item

@@EZ_P3_PWM:
	page0
	mov	a	fra2
	caje	#0000b  @@set_P30_PWM
	caje	#0001b  @@set_P31_PWM
	caje	#0010b	@@set_P32_PWM
	caje	#0011b  @@set_P33_PWM
;	caje	#1000b  @@set_P30_auto_PWM
;	caje	#1001b  @@set_P31_auto_PWM
;	caje	#1010b	@@set_P32_auto_PWM
;	caje	#1011b  @@set_P33_auto_PWM
	jmp	@@not_P3_P6

@@set_P30_PWM:	
	
		
	rcode
	mov	temp2	a
	mov	a	fra2
	mov	PWM1H	a
	mov	a	temp2
	mov	PWM1L	a
	PWMIO_EN1
	jmp	@@EZIO_Item

@@set_P31_PWM:	
	
	rcode
	mov	temp2	a
		
	mov	a	fra2
	mov	PWM2H	a
	mov	a	temp2
	mov	PWM2L	a
	PWMIO_EN2
	jmp	@@EZIO_Item	

@@set_P32_PWM:	
	
	rcode
	mov	temp2	a	
	mov	a	fra2
	mov	PWM3H	a
	mov	a	temp2
	mov	PWM3L	a
	PWMIO_EN3
	jmp	@@EZIO_Item	
	
@@set_P33_PWM:	
	
	rcode
	mov	temp2	a
		
	mov	a	fra2
	mov	PWM4H	a
	mov	a	temp2
	mov	PWM4L	a
	PWMIO_EN4
	jmp	@@EZIO_Item	

@@set_P30_auto_PWM:
	rcode
@@set_P31_auto_PWM:		

@@set_P32_auto_PWM:

@@set_P33_auto_PWM:
	jmp	@@EZIO_Item
	
	



	
@@Load_IO_data:
	page7
	mov	a	temp6
	caje	#0001b	@@EZ_P1_0
	caje	#0010b	@@EZ_P2_0
	caje	#0011b	@@EZ_P3_0
	caje	#0110b	@@EZ_P6_0
	
	caje	#1001b	@@EZ_P1_1
	caje	#1010b	@@EZ_P2_1
	caje	#1011b	@@EZ_P3_1
	caje	#1110b	@@EZ_P6_1
	jmp	@@EZIO_Item

		
;;----------------------------------------------
@@EZ_P1_0:
	mov	a	fra2
	page2
	caje	#0000b  @@SetP10_0
	caje	#0001b  @@SetP11_0
	caje	#0010b  @@SetP12_0
	caje	#0011b  @@SetP13_0
	jmp	@@EZIO_Item

@@EZ_P1_1:
	mov	a	fra2
	page2
	caje	#0000b	@@SetP10_1
	caje	#0001b	@@SetP11_1
	caje	#0010b	@@SetP12_1
	caje	#0011b	@@SetP13_1
	jmp	@@EZIO_Item	
	
@@SetP10_0:
	mov	a	#1110b
	and	a	P1_go2
	mov	P1_go2	a
	mov	a	#1110b
	and	a	P1_go1
	mov	P1_go1	a
	jmp	@@EZIO_Item		
@@SetP10_1:
	mov	a	#1110b
	and	a	P1_go2
	mov	P1_go2	a
	mov	a	#0001b
	or	a	P1_go1
	mov	P1_go1	a
	jmp	@@EZIO_Item	
	
@@SetP11_0:
	mov	a	#1101b
	and	a	P1_go2
	mov	P1_go2	a
	mov	a	#1101b
	and	a	P1_go1
	mov	P1_go1	a
	jmp	@@EZIO_Item		
@@SetP11_1:
	mov	a	#1101b
	and	a	P1_go2
	mov	P1_go2	a
	mov	a	#0010b
	or	a	P1_go1
	mov	P1_go1	a
	jmp	@@EZIO_Item	

@@SetP12_0:
	mov	a	#1011b
	and	a	P1_go2
	mov	P1_go2	a
	mov	a	#1011b
	and	a	P1_go1
	mov	P1_go1	a
	jmp	@@EZIO_Item		
@@SetP12_1:
	mov	a	#1011b
	and	a	P1_go2
	mov	P1_go2	a
	mov	a	#0100b
	or	a	P1_go1
	mov	P1_go1	a
	jmp	@@EZIO_Item			
	
@@SetP13_0:
	mov	a	#0111b
	and	a	P1_go2
	mov	P1_go2	a
	mov	a	#0111b
	and	a	P1_go1
	mov	P1_go1	a
	jmp	@@EZIO_Item		
@@SetP13_1:
	mov	a	#0111b
	and	a	P1_go2
	mov	P1_go2	a
	mov	a	#1000b
	or	a	P1_go1
	mov	P1_go1	a
	jmp	@@EZIO_Item	
;;========================================================
@@EZ_P2_0:
	mov	a	fra2
	page2
	caje	#0000b  @@SetP20_0
	caje	#0001b  @@SetP21_0
	caje	#0010b  @@SetP22_0
	caje	#0011b  @@SetP23_0
	jmp	@@EZIO_Item
	
@@EZ_P2_1:
	mov	a	fra2
	page2
	caje	#0000b	@@SetP20_1
	caje	#0001b	@@SetP21_1
	caje	#0010b	@@SetP22_1
	caje	#0011b	@@SetP23_1
	jmp	@@EZIO_Item	
	
@@SetP20_0:
	mov	a	#1110b
	and	a	P2_go2
	mov	P2_go2	a
	mov	a	#1110b
	and	a	P2_go1
	mov	P2_go1	a
	jmp	@@EZIO_Item		
@@SetP20_1:
	mov	a	#1110b
	and	a	P2_go2
	mov	P2_go2	a
	mov	a	#0001b
	or	a	P2_go1
	mov	P2_go1	a
	jmp	@@EZIO_Item	
	
@@SetP21_0:
	mov	a	#1101b
	and	a	P2_go2
	mov	P2_go2	a
	mov	a	#1101b
	and	a	P2_go1
	mov	P2_go1	a
	jmp	@@EZIO_Item		
@@SetP21_1:
	mov	a	#1101b
	and	a	P2_go2
	mov	P2_go2	a
	mov	a	#0010b
	or	a	P2_go1
	mov	P2_go1	a
	jmp	@@EZIO_Item	

@@SetP22_0:
	mov	a	#1011b
	and	a	P2_go2
	mov	P2_go2	a
	mov	a	#1011b
	and	a	P2_go1
	mov	P2_go1	a
	jmp	@@EZIO_Item		
@@SetP22_1:
	mov	a	#1011b
	and	a	P2_go2
	mov	P2_go2	a
	mov	a	#0100b
	or	a	P2_go1
	mov	P2_go1	a
	
	jmp	@@EZIO_Item			
	
@@SetP23_0:
	mov	a	#0111b
	and	a	P2_go2
	mov	P2_go2	a
	mov	a	#0111b
	and	a	P2_go1
	mov	P2_go1	a
	jmp	@@EZIO_Item		
@@SetP23_1:
	mov	a	#0111b
	and	a	P2_go2
	mov	P2_go2	a
	mov	a	#1000b
	or	a	P2_go1
	mov	P2_go1	a
	jmp	@@EZIO_Item	
;;----------------------------------------------------
@@EZ_P3_0:
	mov	a	fra2
	page2
	caje	#0000b  @@SetP30_0
	caje	#0001b  @@SetP31_0
	caje	#0010b  @@SetP32_0
	caje	#0011b  @@SetP33_0
	jmp	@@EZIO_Item
	
@@EZ_P3_1:
	mov	a	fra2
	page2
	caje	#0000b	@@SetP30_1
	caje	#0001b	@@SetP31_1
	caje	#0010b	@@SetP32_1
	caje	#0011b	@@SetP33_1
	jmp	@@EZIO_Item	
@@SetP30_0:
	
	page2
	mov	a	#1110b
	and	a	P3_go2
	mov	P3_go2	a
	mov	a	#1110b
	and	a	P3_go1
	mov	P3_go1	a
	PWMIO_OFF1
	
	jmp	@@EZIO_Item		
@@SetP30_1:
	
	page2
	mov	a	#1110b
	and	a	P3_go2
	mov	P3_go2	a
	mov	a	#0001b
	or	a	P3_go1
	mov	P3_go1	a
	PWMIO_OFF1
	jmp	@@EZIO_Item	
	
@@SetP31_0:
	
	page2
	mov	a	#1101b
	and	a	P3_go2
	mov	P3_go2	a
	mov	a	#1101b
	and	a	P3_go1
	mov	P3_go1	a
	PWMIO_OFF2
	jmp	@@EZIO_Item		
@@SetP31_1:
	
	page2
	mov	a	#1101b
	and	a	P3_go2
	mov	P3_go2	a
	mov	a	#0010b
	or	a	P3_go1
	mov	P3_go1	a
	PWMIO_OFF2
	jmp	@@EZIO_Item	

@@SetP32_0:
	
	page2
	mov	a	#1011b
	and	a	P3_go2
	mov	P3_go2	a
	mov	a	#1011b
	and	a	P3_go1
	mov	P3_go1	a
	PWMIO_OFF3
	jmp	@@EZIO_Item		
@@SetP32_1:
	
	page2
	mov	a	#1011b
	and	a	P3_go2
	mov	P3_go2	a
	mov	a	#0100b
	or	a	P3_go1
	mov	P3_go1	a
	PWMIO_OFF3
	jmp	@@EZIO_Item			
	
@@SetP33_0:
	
	page2
	mov	a	#0111b
	and	a	P3_go2
	mov	P3_go2	a
	mov	a	#0111b
	and	a	P3_go1
	mov	P3_go1	a
	PWMIO_OFF4
	jmp	@@EZIO_Item		
@@SetP33_1:
	
	page2
	mov	a	#0111b
	and	a	P3_go2
	mov	P3_go2	a
	mov	a	#1000b
	or	a	P3_go1
	mov	P3_go1	a
	PWMIO_OFF4
	jmp	@@EZIO_Item		

;;+++++++++++++++++++++++++++++++++++++++++++++	
@@EZ_P6_0:
	mov	a	fra2
	page4
	caje	#0000b  @@SetP60_0
	caje	#0001b  @@SetP61_0
	caje	#0010b  @@SetP62_0
	caje	#0011b  @@SetP63_0
	jmp	@@EZIO_Item
	
@@EZ_P6_1:
	mov	a	fra2
	page4
	caje	#0000b	@@SetP60_1
	caje	#0001b	@@SetP61_1
	caje	#0010b	@@SetP62_1
	caje	#0011b	@@SetP63_1
	jmp	@@EZIO_Item	
	
@@SetP60_0:
	mov	a	#1110b
	and	a	P6_go2
	mov	P6_go2	a
	mov	a	#1110b
	and	a	P6_go1
	mov	P6_go1	a
	jmp	@@EZIO_Item		
@@SetP60_1:
	mov	a	#1110b
	and	a	P6_go2
	mov	P6_go2	a
	mov	a	#0001b
	or	a	P6_go1
	mov	P6_go1	a
	jmp	@@EZIO_Item	
	
@@SetP61_0:
	mov	a	#1101b
	and	a	P6_go2
	mov	P6_go2	a
	mov	a	#1101b
	and	a	P6_go1
	mov	P6_go1	a
	jmp	@@EZIO_Item		
@@SetP61_1:
	mov	a	#1101b
	and	a	P6_go2
	mov	P6_go2	a
	mov	a	#0010b
	or	a	P6_go1
	mov	P6_go1	a
	jmp	@@EZIO_Item	

@@SetP62_0:
	mov	a	#1011b
	and	a	P6_go2
	mov	P6_go2	a
	mov	a	#1011b
	and	a	P6_go1
	mov	P6_go1	a
	jmp	@@EZIO_Item		
@@SetP62_1:
	mov	a	#1011b
	and	a	P6_go2
	mov	P6_go2	a
	mov	a	#0100b
	or	a	P6_go1
	mov	P6_go1	a
	jmp	@@EZIO_Item			
	
@@SetP63_0:
	mov	a	#0111b
	and	a	P6_go2
	mov	P6_go2	a
	mov	a	#0111b
	and	a	P6_go1
	mov	P6_go1	a
	jmp	@@EZIO_Item		
@@SetP63_1:
	mov	a	#0111b
	and	a	P6_go2
	mov	P6_go2	a
	mov	a	#1000b
	or	a	P6_go1
	mov	P6_go1	a
	jmp	@@EZIO_Item	
;;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

endif	
	


ifdef	PWMEN12
ChecK_PWMIO_P3:
	page5
	mov	a	PWMIOEN1
	caje	#0000b	@@ChecK_PWMIO_P3_bk
	mov	a	#0001b
	and	a	PWMIOEN1
	caje	#0001b	@@adj_P30_PWM
@@check_P31_PWM:	
	page5
	mov	a	#0010b
	and	a	PWMIOEN1
	caje	#0010b	@@adj_P31_PWM
@@check_P32_PWM:	
	page5
	mov	a	#0100b
	and	a	PWMIOEN1
	caje	#0100b	@@adj_P32_PWM
@@check_P33_PWM:
	page5
	mov	a	#1000b
	and	a	PWMIOEN1
	caje	#1000b	@@adj_P33_PWM
	jmp	@@ChecK_PWMIO_P3_bk


@@adj_P30_PWM:
	page6
	mov	a	P30_step_TL
	inca	
	mov	P30_step_TL	a
	caje	#0000b	@@adj_P30_PWM_H
	jmp	@@check_P31_PWM			
@@adj_P30_PWM_H:
        mov	a	P30_step_TH
	inca	
	mov	P30_step_TH	a
	caje	#0000b	@@add_P30_PWM_duty
	jmp	@@check_P31_PWM
;-----------------------------------------
@@adj_P31_PWM:
	page6
	mov	a	P31_step_TL
	inca	
	mov	P31_step_TL	a
	caje	#0000b	@@adj_P31_PWM_H
	page5
	jmp	@@check_P32_PWM			
@@adj_P31_PWM_H:
        mov	a	P31_step_TH
	inca	
	mov	P31_step_TH	a
	caje	#0000b	@@add_P31_PWM_duty
	page5
	jmp	@@check_P32_PWM
;----------------------------------------
@@adj_P32_PWM:
	page6
	mov	a	P32_step_TL
	inca	
	mov	P32_step_TL	a
	caje	#0000b	@@adj_P32_PWM_H
	
	jmp	@@check_P33_PWM			
@@adj_P32_PWM_H:
        mov	a	P32_step_TH
	inca	
	mov	P32_step_TH	a
	caje	#0000b	@@add_P32_PWM_duty
	
	jmp	@@check_P33_PWM	
;----------------------------------------------
@@adj_P33_PWM:
	page6
	mov	a	P33_step_TL
	inca	
	mov	P33_step_TL	a
	caje	#0000b	@@adj_P33_PWM_H
	jmp	@@ChecK_PWMIO_P3_bk		
@@adj_P33_PWM_H:
        mov	a	P33_step_TH
	inca	
	mov	P33_step_TH	a
	caje	#0000b	@@add_P33_PWM_duty
	jmp	@@ChecK_PWMIO_P3_bk
;----------------------------------------------	
@@add_P30_PWM_duty:
	mov	a	P30_duty_L
	inca	
	mov	P30_duty_L	a
	caje	#0000b	@@add_P30_duty_H
@@load_PWM1L:	
	mov	a	P30_duty_L
	mov	PWM1L	a
	page7
	mov	a	P30_timer_tempH
	page6
	mov	P30_step_TH	a
	page5
	jmp	@@check_P31_PWM	
@@add_P30_duty_H:
	mov	a	P30_duty_H
	inca	
	mov	P30_duty_H	a
	mov	PWM1H	a
	jmp	@@load_PWM1L	
;;-----------------------------------------------
@@add_P31_PWM_duty:
	mov	a	P31_duty_L
	inca	
	mov	P31_duty_L	a
	caje	#0000b	@@add_P31_duty_H
@@load_PWM2L:	
	mov	PWM2L	a
	page5
	jmp	@@check_P32_PWM	
@@add_P31_duty_H:
	mov	a	P31_duty_H
	inca	
	mov	P31_duty_H	a
	mov	PWM2H	a
	jmp	@@load_PWM2L		
;--------------------------------------------------
@@add_P32_PWM_duty:
	mov	a	P32_duty_L
	inca	
	mov	P32_duty_L	a
	caje	#0000b	@@add_P32_duty_H
@@load_PWM3L:	
	mov	PWM3L	a
	page5
	jmp	@@check_P33_PWM	
@@add_P32_duty_H:
	mov	a	P32_duty_H
	inca	
	mov	P32_duty_H	a
	mov	PWM3H	a
	jmp	@@load_PWM3L			
;----------------------------------------------------	
@@add_P33_PWM_duty:
	mov	a	P33_duty_L
	inca	
	mov	P33_duty_L	a
	caje	#0000b	@@add_P33_duty_H
@@load_PWM4L:	
	mov	PWM4L	a
	jmp	@@ChecK_PWMIO_P3_bk
@@add_P33_duty_H:
	mov	a	P33_duty_H
	inca	
	mov	P33_duty_H	a
	mov	PWM4H	a
	jmp	@@load_PWM4L	
endif		

@@_4MS	EQU	@@SCANKEY1
LOCKED_OUT1	EQU	#0000B
LOCKED_OUT2	EQU	#0000B
FIRST_KNOCK1	EQU	#0000B
FIRST_KNOCK2	EQU	#0001B
KNOCK_AND_ANSWER1	EQU	#0000B
KNOCK_AND_ANSWER2	EQU	#0010B
JOKE_START1	EQU	#0000B
JOKE_START2	EQU	#0011B
JOKE_MIDDLE1	EQU	#0000B
JOKE_MIDDLE2	EQU	#0100B
JOKE_ANSWER1	EQU	#0000B
JOKE_ANSWER2	EQU	#0101B
@@TR1R:
	PAGE1
	MOV	A	TrigState1
	CAJE	#0000B	@@TR1R_0
	JMP	@@SCANKEY1
@@TR1R_0:
	MOV	A	TrigState2
	CAJE	#0001B	@@_KNOCK
	CAJE	#0010B	@@_KNOCK
	JMP	@@SCANKEY1
@@TR1F	EQU	@@SCANKEY1
@@TR2R:
	PAGE1
	MOV	A	TrigState1
	CAJE	#0000B	@@TR2R_0
	JMP	@@SCANKEY1
@@TR2R_0:
	MOV	A	TrigState2
	CAJE	#0011B	@@_START
	JMP	@@SCANKEY1
@@TR2F	EQU	@@SCANKEY1
@@TR3R	EQU	@@SCANKEY1
@@TR3F	EQU	@@SCANKEY1
@@TR4R	EQU	@@SCANKEY1
@@TR4F	EQU	@@SCANKEY1
@@TR5R:
	PAGE1
	MOV	A	TrigState1
	CAJE	#0000B	@@TR5R_0
	JMP	@@SCANKEY1
@@TR5R_0:
	MOV	A	TrigState2
	CAJE	#0010B	@@_WHO_IS_IT
	JMP	@@SCANKEY1
@@TR5F	EQU	@@SCANKEY1
@@TR6R:
	PAGE1
	MOV	A	TrigState1
	CAJE	#0000B	@@TR6R_0
	JMP	@@SCANKEY1
@@TR6R_0:
	MOV	A	TrigState2
	CAJE	#0100B	@@_MIDDLE
	JMP	@@SCANKEY1
@@TR6F	EQU	@@SCANKEY1
@@TR7R	EQU	@@SCANKEY1
@@TR7F	EQU	@@SCANKEY1
@@TR8R	EQU	@@SCANKEY1
@@TR8F	EQU	@@SCANKEY1
@@TR9R	EQU	@@SCANKEY1
@@TR9F	EQU	@@SCANKEY1
@@TR10R	EQU	@@SCANKEY1
@@TR10F	EQU	@@SCANKEY1
@@TR11R	EQU	@@SCANKEY1
@@TR11F	EQU	@@SCANKEY1
@@TR12R	EQU	@@SCANKEY1
@@TR12F	EQU	@@SCANKEY1
@@TR13R:
	PAGE1
	MOV	A	TrigState1
	CAJE	#0000B	@@TR13R_0
	JMP	@@SCANKEY1
@@TR13R_0:
	MOV	A	TrigState2
	CAJE	#0001B	@@_LAUGH
	CAJE	#0010B	@@_LAUGH
	CAJE	#0011B	@@_LAUGH
	CAJE	#0100B	@@_LAUGH
	CAJE	#0101B	@@_LAUGH
	JMP	@@SCANKEY1
@@TR13F	EQU	@@SCANKEY1
@@TR14R:
	PAGE1
	MOV	A	TrigState1
	CAJE	#0000B	@@TR14R_0
	JMP	@@SCANKEY1
@@TR14R_0:
	MOV	A	TrigState2
	CAJE	#0101B	@@_ANSWER
	JMP	@@SCANKEY1
@@TR14F	EQU	@@SCANKEY1
@@TR15R	EQU	@@SCANKEY1
@@TR15F	EQU	@@SCANKEY1
@@TR16R	EQU	@@SCANKEY1
@@TR16F	EQU	@@SCANKEY1
@@TR17R	EQU	@@SCANKEY1
@@TR17F	EQU	@@SCANKEY1
@@TR18R	EQU	@@SCANKEY1
@@TR18F	EQU	@@SCANKEY1
@@TR19R	EQU	@@SCANKEY1
@@TR19F	EQU	@@SCANKEY1
@@TR20R	EQU	@@SCANKEY1
@@TR20F	EQU	@@SCANKEY1
@@TR21R	EQU	@@SCANKEY1
@@TR21F	EQU	@@SCANKEY1
@@TR22R	EQU	@@SCANKEY1
@@TR22F	EQU	@@SCANKEY1
@@TR23R	EQU	@@SCANKEY1
@@TR23F	EQU	@@SCANKEY1
@@TR24R	EQU	@@SCANKEY1
@@TR24F	EQU	@@SCANKEY1
@@TR25R	EQU	@@SCANKEY1
@@TR25F	EQU	@@SCANKEY1
@@TR26R	EQU	@@SCANKEY1
@@TR26F	EQU	@@SCANKEY1
@@TR27R	EQU	@@SCANKEY1
@@TR27F	EQU	@@SCANKEY1
@@TR28R	EQU	@@SCANKEY1
@@TR28F	EQU	@@SCANKEY1
@@TR29R	EQU	@@SCANKEY1
@@TR29F	EQU	@@SCANKEY1
@@TR30R	EQU	@@SCANKEY1
@@TR30F	EQU	@@SCANKEY1
@@TR31R	EQU	@@SCANKEY1
@@TR31F	EQU	@@SCANKEY1
@@TR32R	EQU	@@SCANKEY1
@@TR32F	EQU	@@SCANKEY1
@@TR33R	EQU	@@SCANKEY1
@@TR33F	EQU	@@SCANKEY1
@@TR34R	EQU	@@SCANKEY1
@@TR34F	EQU	@@SCANKEY1
@@TR35R	EQU	@@SCANKEY1
@@TR35F	EQU	@@SCANKEY1
@@TR36R	EQU	@@SCANKEY1
@@TR36F	EQU	@@SCANKEY1
@@TR37R	EQU	@@SCANKEY1
@@TR37F	EQU	@@SCANKEY1
@@TR38R	EQU	@@SCANKEY1
@@TR38F	EQU	@@SCANKEY1
@@TR39R	EQU	@@SCANKEY1
@@TR39F	EQU	@@SCANKEY1
@@TR40R	EQU	@@SCANKEY1
@@TR40F	EQU	@@SCANKEY1
@@TR41R	EQU	@@SCANKEY1
@@TR41F	EQU	@@SCANKEY1
@@TR42R	EQU	@@SCANKEY1
@@TR42F	EQU	@@SCANKEY1
@@TR43R	EQU	@@SCANKEY1
@@TR43F	EQU	@@SCANKEY1
@@TR44R	EQU	@@SCANKEY1
@@TR44F	EQU	@@SCANKEY1
@@TR45R	EQU	@@SCANKEY1
@@TR45F	EQU	@@SCANKEY1
@@TR46R	EQU	@@SCANKEY1
@@TR46F	EQU	@@SCANKEY1
@@TR47R	EQU	@@SCANKEY1
@@TR47F	EQU	@@SCANKEY1
@@TR48R	EQU	@@SCANKEY1
@@TR48F	EQU	@@SCANKEY1
@@TR49R	EQU	@@SCANKEY1
@@TR49F	EQU	@@SCANKEY1
@@TR50R	EQU	@@SCANKEY1
@@TR50F	EQU	@@SCANKEY1
@@TR51R	EQU	@@SCANKEY1
@@TR51F	EQU	@@SCANKEY1
@@TR52R	EQU	@@SCANKEY1
@@TR52F	EQU	@@SCANKEY1
@@TR53R	EQU	@@SCANKEY1
@@TR53F	EQU	@@SCANKEY1
@@TR54R	EQU	@@SCANKEY1
@@TR54F	EQU	@@SCANKEY1
@@TR55R	EQU	@@SCANKEY1
@@TR55F	EQU	@@SCANKEY1
@@TR56R	EQU	@@SCANKEY1
@@TR56F	EQU	@@SCANKEY1
@@TR57R	EQU	@@SCANKEY1
@@TR57F	EQU	@@SCANKEY1
@@TR58R	EQU	@@SCANKEY1
@@TR58F	EQU	@@SCANKEY1
@@TR59R	EQU	@@SCANKEY1
@@TR59F	EQU	@@SCANKEY1
@@TR60R	EQU	@@SCANKEY1
@@TR60F	EQU	@@SCANKEY1
@@TR61R	EQU	@@SCANKEY1
@@TR61F	EQU	@@SCANKEY1
@@TR62R	EQU	@@SCANKEY1
@@TR62F	EQU	@@SCANKEY1
@@TR63R	EQU	@@SCANKEY1
@@TR63F	EQU	@@SCANKEY1
@@TR64R	EQU	@@SCANKEY1
@@TR64F	EQU	@@SCANKEY1
@@_INIT:
	PAGE1	
	MOV	TrigState1	LOCKED_OUT1
	MOV	TrigState2	LOCKED_OUT2
	FREQ	#0010B	#1110B
	PPDAC
	Mi_data	M0,0
	Mi_data	M1,0
	PAGE1	
	MOV	TrigState1	FIRST_KNOCK1
	MOV	TrigState2	FIRST_KNOCK2
	JMP	@@SCANKEY1
@@_KNOCK:
	PAGE1	
	MOV	TrigState1	KNOCK_AND_ANSWER1
	MOV	TrigState2	KNOCK_AND_ANSWER2
	VoiceName	<KNOCK.WAV>
	JMP	@@_TIMEOUT
@@_WHO_IS_IT:
	PAGE1	
	MOV	TrigState1	JOKE_START1
	MOV	TrigState2	JOKE_START2
	VoiceName	<WHO_IS_THERE.WAV>
	JMP	@@_TIMEOUT
@@_LAUGH:
	SWITCH_Mi	M1,@@_LAUGH1,@@_HAHA,@@_NOT_FUNNY,@@_HILARIOUS,@@_GREAT_JOB
	Mi_data	M1,0
	JMP	@@_LAUGH
@@_LAUGH1:
	Mi_Mj+data	M1,M1,1
	VoiceName	<LAUGH.WAV>
	JMP	@@SCANKEY1
@@_HAHA:
	Mi_Mj+data	M1,M1,1
	VoiceName	<HAHA.WAV>
	JMP	@@SCANKEY1
@@_GREAT_JOB:
	Mi_Mj+data	M1,M1,1
	VoiceName	<GREAT_JOB.WAV>
	JMP	@@SCANKEY1
@@_HILARIOUS:
	Mi_Mj+data	M1,M1,1
	VoiceName	<HILARIOUS.WAV>
	JMP	@@SCANKEY1
@@_NOT_FUNNY:
	Mi_Mj+data	M1,M1,1
	VoiceName	<NOT_FUNNY.WAV>
	JMP	@@SCANKEY1
@@_START:
	PAGE1	
	MOV	TrigState1	JOKE_MIDDLE1
	MOV	TrigState2	JOKE_MIDDLE2
	SWITCH_Mi	M0,@@_ACID,@@_ALASKA,@@_TERESA,@@_ARDWARGH,@@_DOCTOR
	Mi_data	M0,0
	JMP	@@_START
@@_MIDDLE:
	PAGE1	
	MOV	TrigState1	JOKE_ANSWER1
	MOV	TrigState2	JOKE_ANSWER2
	SWITCH_Mi	M0,@@_ACID_WHO,@@_ALASKA_WHO,@@_TERESA_WHO,@@_ARDWARGH_WHO,@@_DOCTOR_WHO
	JMP	@@SCANKEY1
@@_ANSWER:
	PAGE1	
	MOV	TrigState1	FIRST_KNOCK1
	MOV	TrigState2	FIRST_KNOCK2
	SWITCH_Mi	M0,@@_ACID_SIT,@@_ALASKA_QUESTION,@@_TERESA_FLY,@@_ARDWARGH_WALK
	JMP	@@SCANKEY1
@@_ACID:
	VoiceName	<ACID.WAV>
	JMP	@@_TIMEOUT
@@_ACID_WHO:
	VoiceName	<ACID_WHO.WAV>
	JMP	@@_TIMEOUT
@@_ACID_SIT:
	Mi_Mj+data	M0,M0,1
	VoiceName	<ACID_SIT_DOWN.WAV>
	JMP	@@SCANKEY1
@@_ALASKA:
	VoiceName	<ALASKA.WAV>
	JMP	@@_TIMEOUT
@@_ALASKA_WHO:
	VoiceName	<ALASKA_WHO.WAV>
	JMP	@@_TIMEOUT
@@_ALASKA_QUESTION:
	Mi_Mj+data	M0,M0,1
	VoiceName	<ALASKA_QUESTION.WAV>
	JMP	@@SCANKEY1
@@_TERESA:
	VoiceName	<TERESA.WAV>
	JMP	@@_TIMEOUT
@@_TERESA_WHO:
	VoiceName	<TERESA_WHO.WAV>
	JMP	@@_TIMEOUT
@@_TERESA_FLY:
	Mi_Mj+data	M0,M0,1
	VoiceName	<TERESA_FLY.WAV>
	JMP	@@SCANKEY1
@@_DOCTOR:
	VoiceName	<DOCTOR.WAV>
	JMP	@@_TIMEOUT
@@_DOCTOR_WHO:
	Mi_Mj+data	M0,M0,1
	VoiceName	<DOCTOR_WHO.WAV>
	PAGE1	
	MOV	TrigState1	FIRST_KNOCK1
	MOV	TrigState2	FIRST_KNOCK2
	JMP	@@SCANKEY1
@@_ARDWARGH:
	VoiceName	<ARDWARGH.WAV>
	JMP	@@_TIMEOUT
@@_ARDWARGH_WHO:
	VoiceName	<ARDWARGH_WHO.WAV>
	JMP	@@_TIMEOUT
@@_ARDWARGH_WALK:
	Mi_Mj+data	M0,M0,1
	VoiceName	<ARDWARGH_WALK.WAV>
	JMP	@@SCANKEY1
@@_TIMEOUT:
	DELAY	#1111B,#1111B,#0101B
	PAGE1	
	MOV	TrigState1	FIRST_KNOCK1
	MOV	TrigState2	FIRST_KNOCK2
	JMP	@@SCANKEY1
@@CHKBGROUND:
	JMP	@@CHKBGROUND_BACK
@@e1	EQU	@@SCANKEY1
@@e2	EQU	@@SCANKEY1
@@e3	EQU	@@SCANKEY1
@@e4	EQU	@@SCANKEY1
@@e5	EQU	@@SCANKEY1
@@e6	EQU	@@SCANKEY1
@@e7	EQU	@@SCANKEY1
@@e8	EQU	@@SCANKEY1
@@e9	EQU	@@SCANKEY1
@@e10	EQU	@@SCANKEY1
@@e11	EQU	@@SCANKEY1
@@e12	EQU	@@SCANKEY1
@@e13	EQU	@@SCANKEY1
@@e14	EQU	@@SCANKEY1
@@e15	EQU	@@SCANKEY1
