#include <SoftwareSerial.h>
#include "ESP8266WiFi.h"

const int resetPin = 16;
const String twilioNumber =  "YOUR TWILIO NUMBER";

String inputString = "";
String readCommand = "";
String SMSPayload = "";

SoftwareSerial swSer(12, 14, 128);

void setup() {

  pinMode(16, OUTPUT);

  pinMode(13,OUTPUT);
  digitalWrite(13,LOW);
  delay(1500);
  pinMode(13,INPUT);

  // not sure about this delay
  delay(10000);

  Serial.begin(9600);
  swSer.begin(4800);
  inputString.reserve(200);
  while(!Serial){
  }
  while(!swSer){
  }

  delay(500);
  
  Serial.println(" ");
  sendCommand("at",2,2);
  delay(1000);

}

void loop() {

  sendSMS();

  delay(5000);  

  shutdown();
  
}

String sendCommand(String command, int parseLine, int endLine) {
  bool listen = false;
  
  readCommand = "";
  
  delay(50);

  //Serial.println("COMMAND: ");
  //Serial.println(command);
  
  swSer.flush();

  while(swSer.available()){
    swSer.read();
  }
  
  swSer.println(command);
  listen = true;

  int count = 0;
  int timeout = 0;
  
  while(listen){
    if (swSer.available()) {

       char inChar = swSer.read();
       
       if(inChar == 0xA){

         count++;

        if(count == parseLine){

          readCommand = inputString;
          
        } 

        if(count == endLine){
          listen = false;
          //Serial.println("PARSE LINE " + String(count) + ":");
          //Serial.println(inputString);
        } else {
          //Serial.println("REPLY LINE " + String(count) + ":");
          //Serial.println(inputString);
        }

        inputString = "";
        
       } else {
        
        inputString += inChar;
        
       }

     } else {
      // no serial incoming
      timeout++;
      delay(1);
      if(timeout > 1000){
        //Serial.println("...");
        listen = false;
      }
    }
    
  } 

  inputString = "";

  return readCommand;
  
}


void sendSMS (){
  
  String batteryPercent = checkBattery();

  sendCommand("AT+CMGF=1",2,4);
  
  sendCommand("AT+CMGS=\""+twilioNumber+"\"",2,4);

  swSer.print("IFTTT#"+batteryPercent);
  
  swSer.write(0x1A);
  
}

String checkBattery (){
 sendCommand("at+cbc",2,4);
 
 String battery = readCommand;
 readCommand = "";

  char *p = &battery[0];
  char *str;

  int i = 0;
  while ((str = strtok_r(p, ",", &p)) != NULL){
    i++;
    
     if(i == 2){
       return str;
     }
  }

}

void shutdown (){
  pinMode(13,OUTPUT);
  digitalWrite(13,LOW);
  delay(1500);
  pinMode(13,INPUT);
  delay(1000);
  digitalWrite(16, HIGH);
}
