/*jslint node:true, vars:true, bitwise:true, unparam:true */
/*jshint unused:true */
/*global */

/*
A simple node.js application intended to blink the onboard LED on the Intel based development boards such as the Intel(R) Galileo and Edison with Arduino breakout board.

MRAA - Low Level Skeleton Library for Communication on GNU/Linux platforms
Library in C/C++ to interface with Galileo & other Intel platforms, in a structured and sane API with port nanmes/numbering that match boards & with bindings to javascript & python.

Steps for installing MRAA & UPM Library on Intel IoT Platform with IoTDevKit Linux* image
Using a ssh client: 
1. echo "src maa-upm http://iotdk.intel.com/repos/1.1/intelgalactic" > /etc/opkg/intel-iotdk.conf
2. opkg update
3. opkg upgrade

Article: https://software.intel.com/en-us/html5/articles/intel-xdk-iot-edition-nodejs-templates
*/

var mraa = require('mraa'); //require mraa
console.log('MRAA Version: ' + mraa.getVersion()); //write the mraa version to the Intel XDK console

//Load grove module.
var groveSensor = require('jsupm_grove'); 
var upmBuzzer = require("jsupm_buzzer");
var request = require('request');

var temp = new mraa.Aio(1); //new mraa.Gpio(3); //groveSensor.GroveTemp(3); //pin D3
var led = new mraa.Gpio(2); //groveSensor.GroveLed(2); //pin D2
var light = new mraa.Aio(2); //new mraa.Gpio(4); //groveSensor.GroveLight(4); //pin D4
var gyro = new mraa.Aio(0); //new mraa.Gpio(8); //pin A0;
var buzzer = new upmBuzzer.Buzzer(6); //pin D6
var air = new mraa.Aio(0); //setup access analog input Analog pin #0 (A0)
var motion = new mraa.Aio(0); 

var airValue = 0;
var tempValue = 0;
var lightValue = 0;
var gyroValue = 0;
var ledState = true; //Boolean to hold the state of Led

var date = 0;
var tempValue_old = 0;

led.dir(mraa.DIR_OUT); 

recordSensorVals(); //call the function
//blink();
//melody();



function melody() {
    //Play sound
    buzzer.playSound(upmBuzzer.DO, 100000);
    buzzer.playSound(upmBuzzer.SI, 100000);
    //setTimeout(melody, 100); 
    
}
function recordSensorVals()
{    
  date = new Date();
        
  tempValue = temp.read(); //read the value of the digital pin   
  airValue = air.read(); //read the value of the analog pin
  lightValue = light.read(); //read the value of the digital pin 
  gyroValue = gyro.read(); //read the value of the digital pin     

       
  //alerts    
  if(lightValue>=650){
   melody();   
  }
  if(((tempValue-tempValue_old)<0) || ((tempValue-tempValue_old)>0)){
   blink();   
  }
    
  //sensor readings to console   
  console.log("Date: "+date.getTime().toString()+", Temp: "+tempValue+"....Air: "+airValue+"...Light: "+lightValue+"...Gyro: "+gyroValue);    
     
  //send sensor data to  cloud (AWS EC2)
    request.post(
    'http://54.174.19.249:8080/VaccineMonitor/api/readSensors?date='+date.getTime().toString()+'&temp='+tempValue+'&air='+airValue+'&light='+lightValue+'&gyro='+gyroValue, 
     function (error, response, body) {
        //console.log("cloud response: "+response.statusCode);
         console.log("data sent to cloud");
        //if (!error && response.statusCode == 200) {
            //console.log("success!!");
        //}
    }
);
  tempValue_old = tempValue;
  setTimeout(recordSensorVals,1000); //call the indicated function after 1 second (1000 milliseconds)
}

function blink() {
   var i=0;
   for(i=0; i<10; i++){
        led.write(ledState?1:0); //if ledState is true then write a '1' (high) otherwise write a '0' (low) 
        ledState = !ledState; //invert the ledState 
   }
   //setTimeout(blink, 1000);
}

