----------------------------------------------------------------------------------
-- Company: Cal Poly SLO
-- Engineer: Ana Escalera & Tedmon Tran
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity timer is
    Port ( SW : in STD_LOGIC_VECTOR (7 downto 0);
           start : in std_logic;
           clk : in STD_LOGIC;
           Ctime : out STD_LOGIC_VECTOR (7 downto 0);
           done : out STD_LOGIC);
end timer;

architecture Behavioral of timer is

signal cdtime,oldSW : std_logic_vector(7 downto 0);

begin

timer: process(start,SW)
begin
    if(SW /= oldSW) then
        oldSW <= SW;
        cdtime <= SW;
    elsif(rising_edge(clk) AND start = '1') then
        if(cdtime > "00000000") then
            cdtime <= cdtime - 1;
            done <= '0';
        else
            done <= '1';
        end if;
    end if;
    end process;
Ctime <= cdtime;   
end Behavioral;