----------------------------------------------------------------------------------
-- Company: Cal Poly SLO
-- Engineer: Ana Escalera & Tedmon Tran
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;
-- Uncomment the following library declaration if instantiating
-- any Xilinx leaf cells in this code.
--library UNISIM;
--use UNISIM.VComponents.all;
entity mode is
    Port ( BTN : in STD_LOGIC;
           CLK : in STD_LOGIC;
           Z : out STD_LOGIC);
end mode;
architecture Behavioral of mode is
    type state_type is (ST0, ST1);
    signal PS, NS: state_type;
begin
sync_proc: process(CLK, NS)
    begin
if (rising_edge(CLK)) then 
    PS <= NS;
end if;
end process sync_proc;
comb_proc: process(PS, BTN)
begin
    Z <= '0';
    case PS is 
        when ST0 =>
        Z <= '0';
        if (BTN = '1') then
            NS <= ST1;
        else NS <= ST0;
        end if;
        when ST1 =>
            Z <= '1';
            if (BTN = '1') then
            NS <= ST0;
            else NS <= ST1;
            end if;
        when others =>
            Z <= '1';
        end case;
end process comb_proc;

end Behavioral;
