----------------------------------------------------------------------------------
-- Company: Cal Poly SLO
-- Engineer: Ana Escalera & Tedmon Tran
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;
-- Uncomment the following library declaration if instantiating
-- any Xilinx leaf cells in this code.
--library UNISIM;
--use UNISIM.VComponents.all;
entity MainModule is
Port (LBtn,CBtn,RBtn,TBtn,BBtn : in std_logic;
      CLK : in std_logic;
      SW : in std_logic_vector(15 downto 0);
      disp_en : out std_logic_vector(3 downto 0);
      segments : out std_logic_vector(7 downto 0);
      speakerout : out std_logic);
end MainModule;

architecture Behavioral of MainModule is


component clk_div2 is
    Port ( clk : in std_logic;
           sclk : out std_logic);
end component;

component timer is
    Port ( SW : in STD_LOGIC_VECTOR (7 downto 0);
           start : in STD_LOGIC;
           clk : in STD_LOGIC;
           Ctime : out STD_LOGIC_VECTOR (7 downto 0);
           done : out STD_LOGIC);
end component;

component mux is
    Port ( A : in STD_LOGIC_VECTOR (7 downto 0);
           B : in STD_LOGIC_VECTOR (7 downto 0);
           SEL : in STD_LOGIC;
           output : out STD_LOGIC_VECTOR (7 downto 0));
end component;

component sseg_dec is
    Port (      ALU_VAL : in std_logic_vector(7 downto 0); 
				   SIGN : in std_logic;
			  	VALID : in std_logic;
                    CLK : in std_logic;
                DISP_EN : out std_logic_vector(3 downto 0);
               SEGMENTS : out std_logic_vector(7 downto 0));
end component;

component blink is
    Port ( clk : in STD_LOGIC;
           seg : out STD_LOGIC_VECTOR (7 downto 0));
end component;

component mode is
    Port ( BTN : in STD_LOGIC;
           CLK : in STD_LOGIC;
           Z : out STD_LOGIC);
end component;

component clk_div3 is
    Port (  clk : in std_logic;
           sclk : out std_logic);
end component;

component music is
    Port ( CLK : in STD_LOGIC;
           speaker : out std_logic);
end component;

signal t1,tCtime,Tsegments,Bsegments,b3, Ssegments, TimeSeg,Stime,b2, Ltime, dispOut : std_logic_vector(7 downto 0);
signal clkdiv,tDone, z1, sclk, b1, sel1, btn1, btn2, t2, lapSel, buzz, speaker: std_logic;


begin

clkdiv2: clk_div3 port map(clk => CLK,
                           sclk => sclk); 
                
                           
timer1: timer port map(SW => SW(7 downto 0),
                       start => sw(15),
                       clk => clkdiv,
                       Ctime => tCtime,
                       done => tDone);
                       
clkdiv1: clk_div2 port map(clk => CLK,
                           sclk => clkdiv);

sseg1: sseg_dec port map(ALU_VAL => tCtime,
                         SIGN => '0',
                         VALID => '1',
                         CLK => CLK,
                         DISP_EN => disp_en,
                         SEGMENTS => Tsegments);

blink1: blink port map(clk => clkdiv,
                       seg => Bsegments);
                       
b2 <= "0000000" & sclk;  
sel1 <= tDone AND clkdiv;   
                     
BuzzerMux: mux port map(A => "00000000",
                       B => b2,
                       SEL => sel1,
                       output => b3);  
                       
buzz <= b3(0) AND not(z1);


TimerMux: mux port map(A => Tsegments,
                      B => Bsegments,
                      SEL => tDone,
                      output => TimeSeg);   
                                            
                                                          
                                 
mode1: mode port map (BTN => btn1,
                      CLK => CLK,
                      Z => z1);
                      
dispMux: mux port map (A => TimeSeg,
                       B => Ssegments,
                       SEL => z1,
                       output => segments);
                       
sseg2: sseg_dec port map (ALU_VAL => dispOut,
                          SIGN => '0',
                          VALID => '1',
                          CLK => CLK,
                          SEGMENTS => Ssegments);
                           
siren: music port map (CLK => CLK,
                       speaker => speaker);                           

speakerout <= speaker and buzz;

end Behavioral;