#include <TinyGPS++.h>
#include <SoftwareSerial.h>
#include <RF24Network.h>
#include <RF24.h>
#include <SPI.h>
#include <Adafruit_GFX.h>
#include <Adafruit_PCD8544.h>
#include <Wire.h>
#include <LSM303.h>

/*********************************************************************
	MTSuzuki Pet Tracker with Compass
	nRF24L01 receives GPS coordinates and battery voltage from collar 
	module. The GPS module gets local GPS coordinates. The Arduino
	calculates the difference and direction between the two.
	The compass is used to orient the display so that it points back
	to the collar module and displays the distance. 
	TinyGPS++ is used for the GPS and (TinyGPSPlus) object is
	used to find distance and direction 
	Uses LM303dhlc compass, Ublox-NEO-6M GPS, LCD5110 display
*********************************************************************/

/*********************************************************************
This is an example sketch for our Monochrome Nokia 5110 LCD Displays

  Pick one up today in the adafruit shop!
  ------> http://www.adafruit.com/products/338

These displays use SPI to communicate, 4 or 5 pins are required to
interface

Adafruit invests time and resources providing this open source code,
please support Adafruit and open-source hardware by purchasing
products from Adafruit!

Written by Limor Fried/Ladyada  for Adafruit Industries.
BSD license, check license.txt for more information
All text above, and the splash screen must be included in any redistribution
*********************************************************************/
//Test
/*unsigned long startMillis;
unsigned long currentMillis;
unsigned long hours;
unsigned long minutes;
*/

// lsm303 compass stuff
LSM303 compass;
int heading;
double distancem;	// distance in meters
double courseTo;	// heading 

byte setPin = 17;		//pushbutton, D17 is A3

// LCD 5110 connections
// D4 - Serial clock out (CLK)
// D14 - Serial data out (DIN)
// D2 - Data/Command select (D/C)
// D15 - LCD chip select (CE)
// D16 - LCD reset (RST)
Adafruit_PCD8544 display = Adafruit_PCD8544(4, 14, 2, 15, 16);

// GPS connections (RX pin connects to TX on module and v.v.) and Baud rate
static const int RXPin = 5, TXPin = 6;
static const uint32_t GPSBaud = 9600;

// The TinyGPS++ object
TinyGPSPlus gps;

// GPS Latitude[0]/Longitude[1]
double setLL[2];	//stored location
double myLL[2];		//current GPS location

// The serial connection to the GPS device
SoftwareSerial sGPS(RXPin, TXPin);

// nRF24L01(+) radio attached  (CE, CSN)
RF24 radio(9,10);
// Network uses that radio
RF24Network network(radio);
// Channel of our node
const uint16_t channel = 60;
// Address of our node
const uint16_t this_node = 0;

// How many packets have we sent already
unsigned long packets_sent;

// Structure of our payload, limited to 32 bytes
struct payload_t			// 32 bytes max
{
  unsigned long counter;	// 4 bytes
  double lat;				// 4 bytes
  double lng;				// 4 bytes
  float Vcc;				// 4 bytes
};

// packet variables
unsigned long Counter;
//double setLL[0];
//double setLL[1];
float Vcc;

// The following are for displaying direction on LCD5110
//position 0-N, 1-NNE, 2-NE, 3-ENE, 4-E, 5-ESE, 6-SE, 7-SSE
//         8-S, 9-SSW, 10-SW, 11-WSW, 12-W, 13-WNW, 14-NW, 15-NNW
byte position;

//x, y coordinates for pointer head on LCD5110
byte cursorxy[16][2] = {
    // 0-North 1-NNE   2-NE   3-ENE	 4-East  5-ESE   6-SE    7-SSE
       39, 0,  59, 0,  79, 0, 79, 8, 79, 16, 79, 24, 79, 32, 59, 32,
    // 8-South 9-SSW   10-SW  11-WSW 12-West 13-WNW 14-NW 15-NNW
       39, 32, 29, 32, 0, 32, 0, 24, 0, 16,  0, 8,  0, 0, 29, 0 };

// Pointer character					  
char LCDchar[16] = {'A','A','A','>','>','>','X','V','V','V','X','L','<','<','<','A'}; 					   
//x1, y1 ,x2, y2 coordinates for line
byte dline[16][4] = {
    // 0-North          1-NNE             2-NE			  3-ENE
       41, 7, 41, 39,   30, 39, 61, 5,    80, 7, 0, 39,   0, 24, 80, 11,
    // 4-E,              5-ESE            6-SE,           7-SSE
       0, 19, 80, 19,    0, 10, 80, 27,   0, 0, 79, 31,   31, 0, 61, 31,
    // 8-S			     9-SSW			  10-SW			  11-WSW
       41, 0, 41, 31,    61, 0, 31, 31,   5, 31, 83, 0,   83, 10, 2, 26, 
    // 12-W			     13-WNW			  14-NW			  15-NNW	
       0, 19, 83, 19,    83, 26, 4, 10,   0, 0, 83, 39,   60, 32, 31, 0};

//Prototypes
void getRadioData();		// get Radio data
void getGPS();				// get GPS data
void calculate();			// calculate distance and heading
int getHeading();			// get heading using compass
byte getPostion(int);		// get position using heading and 
void displayDirection();	// display info 

void setup(){
	Serial.begin(115200);
	
	// start GPS
	sGPS.begin(GPSBaud);

	// setup for compass
	Wire.begin();
	compass.init();
	compass.enableDefault();
	// Values from Calibrate sketch
	compass.m_min = (LSM303::vector<int16_t>){-433, -600, -546};
	compass.m_max = (LSM303::vector<int16_t>){+570, +488, +579};
	
	// setup for nrf24L01
	SPI.begin();
	// Radio setup
	radio.begin();
	// network.begin(/*channel*/, /*node address*/);
	network.begin(channel, this_node);
	
	//LCD5110 setup
	display.begin();
	display.setContrast(65);	// Choose best contrast
	display.display(); 			// show splashscreen
	delay(20);
	display.clearDisplay();   	// clears the screen and buffer

//	startMillis = millis();
	}

void loop(){
	// Pump the radio network regularly
	network.update();
//	delay(100);
	// Is there anything ready for us?
	while ( network.available() ){
		// If so, grab it and print it out
		getRadioData();
	}

	// wait until GPS is working
	while (sGPS.available() > 0){
		if (gps.encode(sGPS.read())){
//Serial.println("  read GPS");
			getGPS();			// get location
			calculate();		// calculate distance and direction
			// calculate position by compass heading and courseTo (GPS)
			position = getPostion(getHeading() + courseTo );
			displayDirection();	// display direction and distance
		}
	}
}

//////////////////////////////////////////////////////////////////////////////////
// getRadioData()					// get Network data
//////////////////////////////////////////////////////////////////////////////////
void getRadioData(){
	RF24NetworkHeader header;
	payload_t payload;
	bool done = false;

	while (!done){
		done = 	network.read(header,&payload,sizeof(payload));

		Counter = payload.counter;
		setLL[0] = payload.lat;
		setLL[1] = payload.lng;
		Vcc = payload.Vcc;
/*
		Serial.print("Packet #");
		Serial.print(Counter);
		Serial.print(" Lat: ");
		Serial.print(setLL[0],6);
		Serial.print(" Lng: ");
		Serial.print(setLL[1],6);
		Serial.print(" Vcc: ");
		Serial.print(Vcc);
		Serial.print(" Time(hr:min): ");
		currentMillis = millis() - startMillis;
		minutes = (currentMillis/(1000.0*60.0)); 
		hours =  (minutes/60.0);
		Serial.print(hours);
		Serial.print(":");
		Serial.println((int)minutes % 60);
*/
	}
}

//get GPS data
void getGPS(){
	if (gps.location.isValid()){
		myLL[0] = gps.location.lat();
		myLL[1] = gps.location.lng();
	}
}

//get heading using compass
int getHeading(){
	compass.read();
	heading = (int)compass.heading();
	return ((630 - heading) % 360);	// The lm303 is mounted 270 degrees off
}

//calculate distance and heading
void calculate(){
	if ((setLL[0] !=0.0) && (setLL[1] !=0.0)){
		distancem = TinyGPSPlus::distanceBetween(myLL[0],myLL[1],setLL[0],setLL[1]);
		courseTo =  TinyGPSPlus::courseTo(myLL[0],myLL[1],setLL[0],setLL[1]);
	}
}

//get position using heading and courseTo
byte getPostion(int headplus){

	headplus = headplus % 360;
	if ((headplus > 348) || (headplus < 12)) return 0;
	if ((headplus > 11) && (headplus < 34)) return 1;
	if ((headplus > 33) && (headplus < 57)) return 2;
	if ((headplus > 56) && (headplus < 79)) return 3;
	if ((headplus > 78) && (headplus < 102)) return 4;
	if ((headplus > 101) && (headplus < 124)) return 5;
	if ((headplus > 123) && (headplus < 147)) return 6;
	if ((headplus > 146) && (headplus < 169)) return 7;
	if ((headplus > 168) && (headplus < 192)) return 8;
	if ((headplus > 191) && (headplus < 214)) return 9;
	if ((headplus > 213) && (headplus < 237)) return 10;
	if ((headplus > 236) && (headplus < 259)) return 11;
	if ((headplus > 258) && (headplus < 282)) return 12;
	if ((headplus > 281) && (headplus < 304)) return 13;
	if ((headplus > 303) && (headplus < 327)) return 14;
	if ((headplus > 326) && (headplus < 349)) return 15;
} 

// display info 
void displayDirection(){
	int feet;
	display.clearDisplay();
	display.setCursor(cursorxy[position][0],cursorxy[position][1]); // head of arrow
	display.print(LCDchar[position]);
	display.drawLine(dline[position][0], dline[position][1], dline[position][2], dline[position][3], BLACK);
	display.setCursor(0,40); 
	feet = (int)(distancem*3.2808399);	// convert meters to feet
	if (feet >= 5280){
		display.print("miles: ");
		display.print(feet/5280.0);
	}else{
		display.print("Feet: ");
		display.print(feet);
	}
	display.display();
	delay(1000);
}
