#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/mman.h>

#define MAP_SIZE 4096UL
#define MAP_MASK (MAP_SIZE - 1)

#define ADC_BASE    0xfffe0000
#define ADC_CR      0x00
#define ADC_MR      0x04
#define ADC_CHER    0x10
#define ADC_SR      0x1c
#define ADC_CDR(x) (0x30+(x)*0x4)

#define PMC_BASE    0xfffffc00
#define PMC_PCER    0x10
#define ADC_PID     5;

void *adc_base;
void *pmc_base;

int main(int argc, char **argv) {
	int fd;


	if((fd = open("/dev/mem", O_RDWR | O_SYNC)) == -1) {
		printf("couldn't open /dev/mem\n");
		return 1;
	}
	/* map adc memory region */
	adc_base = mmap(0, MAP_SIZE, PROT_READ | PROT_WRITE, MAP_SHARED, fd, ADC_BASE  & ~MAP_MASK);
	if(adc_base == MAP_FAILED)
	{
		printf("mmap failed\n");
		return 1;
	}
	/* map pmc memory region */
	pmc_base = mmap(0, MAP_SIZE, PROT_READ | PROT_WRITE, MAP_SHARED, fd, PMC_BASE  & ~MAP_MASK);
	if(pmc_base == MAP_FAILED)
	{
		printf("mmap failed\n");
		return 1;
	}

	/* enable adc clock in pmc */
	*((volatile unsigned long *) (pmc_base + ((PMC_BASE + PMC_PCER) & MAP_MASK))) = 1 << ADC_PID;

	/* software reset */
	*((volatile unsigned long *) (adc_base + ((ADC_BASE + ADC_CR) & MAP_MASK))) = 0x00000001;
	/* enable adc channels 0-3 */
	*((volatile unsigned long *) (adc_base + ((ADC_BASE + ADC_CHER) & MAP_MASK))) = 0x0000000f;
	/* maximum start and sample & hold time, maximum prescaler, normal and high resolution mode, no hardware trigger */
	*((volatile unsigned long *) (adc_base + ((ADC_BASE + ADC_MR) & MAP_MASK))) = 0x0f1f3f00;
	/* start conversion */
	*((volatile unsigned long *) (adc_base + ((ADC_BASE + ADC_CR) & MAP_MASK))) = 0x00000002;

	/* wait for end of conversion of all channels */
	while((*(volatile unsigned long *) (adc_base + ((ADC_BASE + ADC_SR) & MAP_MASK)) & 0xf) != 0xf);

	/* read out adc values */
	printf("%04d\n", *((volatile unsigned long *) (adc_base + ((ADC_BASE + ADC_CDR(0)) & MAP_MASK))));
/*	printf("%08x\n", *((volatile unsigned long *) (adc_base + ((ADC_BASE + ADC_CDR(1)) & MAP_MASK))));
	printf("%08x\n", *((volatile unsigned long *) (adc_base + ((ADC_BASE + ADC_CDR(2)) & MAP_MASK))));
	printf("%08x\n", *((volatile unsigned long *) (adc_base + ((ADC_BASE + ADC_CDR(3)) & MAP_MASK))));
*/
	if(munmap(adc_base, MAP_SIZE) == -1)
		return 1;
	close(fd);

	return 0;
}
