VERSION 5.00
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSCOMM32.OCX"
Object = "{49F811F7-6005-4AAF-AE00-9D98766A6E26}#1.0#0"; "NTGraph.ocx"
Begin VB.Form Form1 
   Caption         =   "Magic NiMH - NiCd Smart Battery Charger"
   ClientHeight    =   7650
   ClientLeft      =   2115
   ClientTop       =   2355
   ClientWidth     =   10785
   Icon            =   "pc_thermometer.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   7650
   ScaleWidth      =   10785
   Begin VB.CheckBox shutdown 
      Caption         =   "Shut down when finished"
      Height          =   255
      Left            =   840
      TabIndex        =   57
      Top             =   7200
      Width           =   2295
   End
   Begin VB.CommandButton quick_charge_btn 
      Caption         =   "Quick Select"
      Height          =   375
      Left            =   8880
      TabIndex        =   53
      ToolTipText     =   "Charge with the default parameters .."
      Top             =   3480
      Width           =   1695
   End
   Begin VB.CheckBox Trickle_check 
      Caption         =   "Enable Trickle"
      Height          =   255
      Left            =   9360
      TabIndex        =   52
      ToolTipText     =   "Wither to switch to trickle charge after charge completed or Not."
      Top             =   6240
      Width           =   1335
   End
   Begin VB.Timer trickle_ton 
      Enabled         =   0   'False
      Interval        =   1000
      Left            =   5520
      Top             =   120
   End
   Begin VB.Timer trickle_toff 
      Enabled         =   0   'False
      Left            =   4920
      Top             =   120
   End
   Begin VB.Timer curr_temp_timer 
      Enabled         =   0   'False
      Interval        =   1000
      Left            =   4080
      Top             =   120
   End
   Begin VB.TextBox profile_name 
      Appearance      =   0  'Flat
      BackColor       =   &H80000004&
      Height          =   285
      Left            =   7920
      Locked          =   -1  'True
      TabIndex        =   44
      Top             =   3960
      Width           =   2775
   End
   Begin VB.TextBox max_temp 
      Appearance      =   0  'Flat
      BackColor       =   &H80000004&
      Height          =   285
      Left            =   7920
      TabIndex        =   42
      Top             =   6120
      Width           =   855
   End
   Begin VB.TextBox maxslope 
      Appearance      =   0  'Flat
      BackColor       =   &H80000004&
      Height          =   285
      Left            =   7920
      TabIndex        =   41
      Top             =   5760
      Width           =   855
   End
   Begin VB.TextBox batt_type 
      Appearance      =   0  'Flat
      BackColor       =   &H80000004&
      Height          =   285
      Left            =   7920
      Locked          =   -1  'True
      TabIndex        =   40
      Top             =   4320
      Width           =   855
   End
   Begin VB.CommandButton Profile 
      Caption         =   "Load Profile"
      Height          =   375
      Left            =   6360
      TabIndex        =   39
      Top             =   3480
      Width           =   1815
   End
   Begin VB.Timer DischargeFlash 
      Enabled         =   0   'False
      Interval        =   500
      Left            =   3480
      Top             =   120
   End
   Begin VB.Timer ChargeFlash 
      Enabled         =   0   'False
      Interval        =   500
      Left            =   3000
      Top             =   120
   End
   Begin VB.Frame Frame1 
      Caption         =   " Charger Controls  "
      Height          =   975
      Left            =   840
      TabIndex        =   32
      Top             =   6120
      Width           =   5175
      Begin VB.CommandButton pause 
         Caption         =   "Pause"
         Height          =   375
         Left            =   2400
         TabIndex        =   47
         Top             =   360
         Width           =   975
      End
      Begin VB.CommandButton Command1 
         Caption         =   "Charge"
         Height          =   375
         Left            =   240
         TabIndex        =   35
         Top             =   360
         Width           =   975
      End
      Begin VB.CommandButton Command2 
         Caption         =   "Reset"
         Height          =   375
         Left            =   3480
         TabIndex        =   34
         Top             =   360
         Width           =   975
      End
      Begin VB.CommandButton disch 
         BackColor       =   &H008080FF&
         Caption         =   "Discharge"
         Height          =   375
         Left            =   1320
         Style           =   1  'Graphical
         TabIndex        =   33
         Top             =   360
         Width           =   975
      End
   End
   Begin VB.TextBox charge_current 
      Appearance      =   0  'Flat
      BackColor       =   &H80000004&
      Height          =   285
      Left            =   7920
      Locked          =   -1  'True
      TabIndex        =   26
      Top             =   4680
      Width           =   855
   End
   Begin VB.TextBox batt_capacity 
      Appearance      =   0  'Flat
      BackColor       =   &H80000004&
      Height          =   285
      Left            =   7920
      Locked          =   -1  'True
      TabIndex        =   23
      Top             =   5040
      Width           =   855
   End
   Begin VB.Timer discharge_timer 
      Enabled         =   0   'False
      Interval        =   1000
      Left            =   2400
      Top             =   120
   End
   Begin VB.TextBox discharge_current 
      Height          =   285
      Left            =   7920
      TabIndex        =   20
      Text            =   "500"
      Top             =   6600
      Width           =   855
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Exit"
      Height          =   375
      Left            =   9120
      TabIndex        =   15
      Top             =   7080
      Width           =   1335
   End
   Begin VB.TextBox max_time 
      Appearance      =   0  'Flat
      BackColor       =   &H80000004&
      Height          =   285
      Left            =   7920
      TabIndex        =   11
      Top             =   5400
      Width           =   855
   End
   Begin VB.Timer FinishTimer 
      Enabled         =   0   'False
      Interval        =   60000
      Left            =   720
      Top             =   120
   End
   Begin NTGRAPHLib.NTGraph NTGraph1 
      Height          =   4815
      Left            =   120
      TabIndex        =   0
      Top             =   240
      Width           =   6135
      _Version        =   65536
      _ExtentX        =   10821
      _ExtentY        =   8493
      _StockProps     =   194
      BeginProperty TickFont {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Arial"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      BeginProperty LabelFont {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      BeginProperty IdentFont {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Arial"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      PlotAreaPicture =   "pc_thermometer.frx":08CA
      ControlFramePicture=   "pc_thermometer.frx":08E6
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   1000
      Left            =   1560
      Top             =   120
   End
   Begin MSCommLib.MSComm MSComm1 
      Left            =   0
      Top             =   120
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      DTREnable       =   -1  'True
   End
   Begin VB.Label Label25 
      BackColor       =   &H00E0E0E0&
      Caption         =   "mAh"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00000080&
      Height          =   255
      Left            =   9600
      TabIndex        =   56
      Top             =   2400
      Width           =   615
   End
   Begin VB.Label charge_capacity 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00E0E0E0&
      Caption         =   "0.0"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00000080&
      Height          =   255
      Left            =   8520
      TabIndex        =   55
      Top             =   2400
      Width           =   855
   End
   Begin VB.Label cap_label 
      BackColor       =   &H00E0E0E0&
      Caption         =   "Charge Capacity:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   6480
      TabIndex        =   54
      Top             =   2400
      Width           =   1815
   End
   Begin VB.Label status_label 
      Alignment       =   2  'Center
      BackColor       =   &H00E0E0E0&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00000080&
      Height          =   255
      Left            =   7440
      TabIndex        =   51
      Top             =   2040
      Width           =   2775
   End
   Begin VB.Label Label23 
      BackColor       =   &H00E0E0E0&
      Caption         =   "Status:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   6480
      TabIndex        =   50
      Top             =   2040
      Width           =   735
   End
   Begin VB.Label Label20 
      BackColor       =   &H00E0E0E0&
      Caption         =   "Start Temp."
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   8400
      TabIndex        =   49
      Top             =   480
      Width           =   1215
   End
   Begin VB.Label ambient 
      BackColor       =   &H00E0E0E0&
      Caption         =   "-"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00000080&
      Height          =   255
      Left            =   9720
      TabIndex        =   48
      Top             =   480
      Width           =   615
   End
   Begin VB.Label end_time 
      BackColor       =   &H00E0E0E0&
      Caption         =   "00:00"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00000080&
      Height          =   255
      Left            =   9600
      TabIndex        =   46
      Top             =   1560
      Width           =   855
   End
   Begin VB.Label Label22 
      BackColor       =   &H00E0E0E0&
      Caption         =   "End :"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   8880
      TabIndex        =   45
      Top             =   1560
      Width           =   615
   End
   Begin VB.Label Label21 
      Caption         =   "Profile Name:"
      Height          =   255
      Left            =   6720
      TabIndex        =   43
      Top             =   3960
      Width           =   975
   End
   Begin VB.Label start 
      BackColor       =   &H00E0E0E0&
      Caption         =   "00:00"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00000080&
      Height          =   255
      Left            =   7800
      TabIndex        =   38
      Top             =   1560
      Width           =   975
   End
   Begin VB.Label Label17 
      BackColor       =   &H00E0E0E0&
      Caption         =   "Started At :"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   6480
      TabIndex        =   37
      Top             =   1560
      Width           =   1215
   End
   Begin VB.Label duration_h 
      BackColor       =   &H00E0E0E0&
      Caption         =   "0.0 H"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00000080&
      Height          =   255
      Left            =   9480
      TabIndex        =   36
      Top             =   1200
      Width           =   975
   End
   Begin VB.Label Label19 
      Alignment       =   2  'Center
      Caption         =   "Discharge"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   1800
      TabIndex        =   31
      Top             =   5640
      Width           =   975
   End
   Begin VB.Label Label18 
      Alignment       =   2  'Center
      Caption         =   "Charge"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   960
      TabIndex        =   30
      Top             =   5640
      Width           =   735
   End
   Begin VB.Shape DischargeShape 
      BorderColor     =   &H00000080&
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   135
      Left            =   2040
      Top             =   5400
      Width           =   495
   End
   Begin VB.Shape chargeShape 
      BorderColor     =   &H00000080&
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   135
      Left            =   1080
      Top             =   5400
      Width           =   495
   End
   Begin VB.Label disch_duration 
      BackColor       =   &H00E0E0E0&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   9360
      TabIndex        =   29
      Top             =   3000
      Width           =   1095
   End
   Begin VB.Label Label16 
      Caption         =   "mA"
      Height          =   255
      Left            =   8880
      TabIndex        =   28
      Top             =   4680
      Width           =   495
   End
   Begin VB.Label Label15 
      Caption         =   "Charge current:"
      Height          =   255
      Left            =   6600
      TabIndex        =   27
      Top             =   4680
      Width           =   1095
   End
   Begin VB.Label Label14 
      Caption         =   "mAH"
      Height          =   255
      Left            =   8880
      TabIndex        =   25
      Top             =   5040
      Width           =   495
   End
   Begin VB.Label Label13 
      Caption         =   "Battery capacity:"
      Height          =   255
      Left            =   6480
      TabIndex        =   24
      Top             =   5040
      Width           =   1215
   End
   Begin VB.Label capacity 
      BackColor       =   &H00E0E0E0&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   7680
      TabIndex        =   22
      Top             =   3000
      Width           =   1335
   End
   Begin VB.Label Label12 
      Caption         =   "mA"
      Height          =   255
      Left            =   8880
      TabIndex        =   21
      Top             =   6600
      Width           =   495
   End
   Begin VB.Label Label11 
      Caption         =   "Dishcarge Current:"
      Height          =   255
      Left            =   6360
      TabIndex        =   19
      Top             =   6600
      Width           =   1335
   End
   Begin VB.Label Label10 
      BackColor       =   &H00E0E0E0&
      Caption         =   "Capacity :"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   6480
      TabIndex        =   18
      Top             =   3000
      Width           =   1095
   End
   Begin VB.Shape Shape2 
      BackColor       =   &H00E0E0E0&
      BackStyle       =   1  'Opaque
      Height          =   495
      Left            =   6360
      Top             =   2880
      Width           =   4215
   End
   Begin VB.Label Label9 
      Caption         =   "C"
      Height          =   255
      Left            =   8880
      TabIndex        =   17
      Top             =   6120
      Width           =   375
   End
   Begin VB.Label Label8 
      Caption         =   "Cut Off Temp. :"
      Height          =   255
      Left            =   6600
      TabIndex        =   16
      Top             =   6120
      Width           =   1095
   End
   Begin VB.Label Label7 
      Caption         =   "C/m"
      Height          =   255
      Left            =   8880
      TabIndex        =   14
      Top             =   5760
      Width           =   495
   End
   Begin VB.Label Label6 
      Caption         =   "Max Slope:"
      Height          =   255
      Left            =   6840
      TabIndex        =   13
      Top             =   5760
      Width           =   855
   End
   Begin VB.Label Label5 
      Caption         =   "Min"
      Height          =   255
      Left            =   8880
      TabIndex        =   12
      Top             =   5400
      Width           =   495
   End
   Begin VB.Label Label4 
      Caption         =   "Cut OffTime:"
      Height          =   255
      Left            =   6720
      TabIndex        =   10
      Top             =   5400
      Width           =   975
   End
   Begin VB.Label Label3 
      Caption         =   "Battery type:"
      Height          =   255
      Left            =   6720
      TabIndex        =   9
      Top             =   4320
      Width           =   975
   End
   Begin VB.Label duration 
      BackColor       =   &H00E0E0E0&
      Caption         =   "0.0 Min"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00000080&
      Height          =   255
      Left            =   7800
      TabIndex        =   8
      Top             =   1200
      Width           =   735
   End
   Begin VB.Label Label2 
      BackColor       =   &H00E0E0E0&
      Caption         =   "Duration    :"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   6480
      TabIndex        =   7
      Top             =   1200
      Width           =   1335
   End
   Begin VB.Label max_slope 
      BackColor       =   &H00E0E0E0&
      Caption         =   "-"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00000080&
      Height          =   255
      Left            =   9840
      TabIndex        =   6
      Top             =   840
      Width           =   615
   End
   Begin VB.Label Label1 
      BackColor       =   &H00E0E0E0&
      Caption         =   "Max Slope:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   8400
      TabIndex        =   5
      Top             =   840
      Width           =   1215
   End
   Begin VB.Label slope 
      BackColor       =   &H00E0E0E0&
      Caption         =   "-"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00000080&
      Height          =   255
      Left            =   7560
      TabIndex        =   4
      Top             =   840
      Width           =   495
   End
   Begin VB.Label temp2 
      BackColor       =   &H00E0E0E0&
      Caption         =   "-"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00000080&
      Height          =   255
      Left            =   7560
      TabIndex        =   3
      Top             =   480
      Width           =   615
   End
   Begin VB.Label lb2 
      BackColor       =   &H00E0E0E0&
      Caption         =   "Slope :"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   6480
      TabIndex        =   2
      Top             =   840
      Width           =   855
   End
   Begin VB.Label lb1 
      BackColor       =   &H00E0E0E0&
      Caption         =   "Temp. :"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   6480
      TabIndex        =   1
      Top             =   480
      Width           =   855
   End
   Begin VB.Shape Shape1 
      BackColor       =   &H00E0E0E0&
      BackStyle       =   1  'Opaque
      Height          =   2535
      Left            =   6360
      Top             =   240
      Width           =   4215
   End
   Begin VB.Menu file 
      Caption         =   "File"
      Begin VB.Menu exit 
         Caption         =   "Exit"
      End
   End
   Begin VB.Menu ef 
      Caption         =   "Edit Profile"
   End
   Begin VB.Menu dt 
      Caption         =   "Display Temperature"
   End
   Begin VB.Menu help 
      Caption         =   "Help"
      Begin VB.Menu about 
         Caption         =   "About"
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim v_exit As Integer
Dim counter As Long
Dim tmr As PerformanceTimer
Dim v_temp As Double
Dim v_prev_temp, v_prev_temp1 As Double
Dim v_prev_slope, v_max_slope As Double
Dim v_capacity_counter As Long
Dim v_capacity As Double
Dim vStartTemp As Double
Dim v_Temp_Diff As Double


Private Sub about_Click()
    About_form.Show
End Sub

Private Sub ChargeFlash_Timer()

 
If chargeShape.FillStyle = 1 Then
   chargeShape.FillStyle = 0
Else
   chargeShape.FillStyle = 1
End If

End Sub

Private Sub Command1_Click()
  If profile_name.Text <> "" Then
  
    start.Caption = Time
    ambient.Caption = Format(GetTemp, "00.0") & " C"
    status_label.Caption = ".. Charging .."
    NTGraph1.Caption = Form1.profile_name
    NTGraph1.ElementLineColor = &HFFFF&
    NTGraph1.SetRange 0, max_time.Text, 20, max_temp.Text + 5
    disch.Enabled = False
    PowerOn
    Timer1.Enabled = True
    FinishTimer.Enabled = True
    
    OpenLog

  Else
    MsgBox " Please select a profile .. ", vbCritical, Error
  End If
  

End Sub

Private Sub Command2_Click()
    disch.Enabled = True
    Command1.Enabled = True
    status_label.Caption = ".. Stopped .."
    PowerOff
    Timer1.Enabled = False
    FinishTimer.Enabled = False
    discharge_timer.Enabled = False
    
    trickle_ton.Enabled = False
    trickle_toff.Enabled = False
    
    Discharge_off
    
    If Command1.Enabled = True Then
      counter = 0
    End If
    
    If disch.Enabled = True Then
        v_capacity_counter = 0
    End If
    
    NTGraph1.ClearGraph
    
    clrTxt
   
    SaveLog
    Close #1

End Sub

Private Sub Command4_Click()
MSComm1.DTREnable = True
End Sub

Private Sub Command6_Click()
MSComm1.RTSEnable = True
End Sub

Private Sub Command7_Click()
MSComm1.RTSEnable = False
End Sub


Private Sub Command3_Click()
Unload Me
End Sub


Private Sub curr_temp_timer_Timer()
   temp_form.curr_temp.Caption = Format(GetTemp, "00.0")
End Sub




Private Sub disch_Click()
    If is_charged = True Then
        Command1.Enabled = False
        Discharge_on
        discharge_timer.Enabled = True
        status_label.Caption = ".. Discharging .."
    Else
      MsgBox " Please connect the batteries to the Discharge location .. ", vbCritical
    End If
End Sub



Private Sub discharge_timer_Timer()
    v_capacity_counter = v_capacity_counter + 1
    capacity.Caption = Round(discharge_current.Text * (v_capacity_counter / 3600), 1) & " mAH"
    
    disch_duration.Caption = Round(v_capacity_counter / 60, 1) & " min"
    
    If is_charged = False Then
      Discharge_off
      discharge_timer.Enabled = False
    End If
End Sub

Private Sub DischargeFlash_Timer()
    If DischargeShape.FillStyle = 1 Then
       DischargeShape.FillStyle = 0
    Else
       DischargeShape.FillStyle = 1
    End If
End Sub





Private Sub dt_Click()
 temp_form.Show
End Sub

Private Sub ef_Click()
 profile_form.Show
End Sub

Private Sub exit_Click()
    Unload Me
End Sub

Private Sub FinishTimer_Timer()
    
    slope.Caption = Round(v_temp - v_prev_temp, 1) & " C/min"

    ' get the max slope
    If (v_temp - v_prev_temp) > v_max_slope Then
        v_max_slope = v_temp - v_prev_temp
        max_slope.Caption = Round(v_max_slope, 1)
        
    End If
    
    ' Do not terminate the charging process if less that quarter of the total time
    
    
    'If (v_temp - v_prev_temp) >= Val(maxslope.Text) And counter > (Val(max_time.Text) * 60 / 4) Then
   
   ' Modified to terminate the charge if chargerd
    If (v_temp - v_prev_temp) >= Val(maxslope.Text) Then
      status_label.Caption = "Max. Slope Detection..."
      StopCharging
        
    End If
    
    v_prev_temp = v_temp
    'v_prev_slope = v_temp - v_prev_temp
    
    
End Sub

Private Sub Form_Load()
  MSComm1.CommPort = 1              ' Set the port number
  MSComm1.Settings = "9600,N,8,1"  ' Set UART parameters
  MSComm1.PortOpen = True           ' Required, might lock port
  MSComm1.DTREnable = False
  
  PowerOff
  v_exit = 0
  
  v_temp = 0
  v_prev_temp = 0
  v_prev_slope = 0
  v_prev_temp1 = 0
  v_max_slope = 0
  'maxslope.ListIndex = 3
  'batt_type.ListIndex = 1
  'max_temp.ListIndex = 3
  v_capacity_counter = 0
  v_capacity = 0
  
  ''''''''''''''''''''''''Cut Off Temperature difference '''''''''''''''''
  v_Temp_Diff = 12
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  
  
  chargeShape.FillStyle = 1
  DischargeShape.FillStyle = 1
  status_label.Caption = ".. Stopped .."
  
 With NTGraph1
        .FrameStyle = Flat
        .LabelColor = RGB(0, 0, 0)
        .ControlFrameColor = RGB(192, 192, 192)
        .ElementLineColor = RGB(255, 255, 0)
        .ShowGrid = True
        .Caption = "Battery Temperature Curve"
        .XLabel = "Time (min)"
        .YLabel = "Temperature C"
   End With


End Sub



Private Sub max_temp_Validate(Cancel As Boolean)
    NTGraph1.SetRange 0, max_time.Text * 60, 20, max_temp.Text + 5
End Sub


Private Sub pause_Click()
    disch.Enabled = True
    Command1.Enabled = True
    
    PowerOff
    Timer1.Enabled = False
    FinishTimer.Enabled = False
    discharge_timer.Enabled = False
    Discharge_off

End Sub

Private Sub Profile_Click()
     profile_form.Show
End Sub


Private Sub quick_charge_btn_Click()
    quick_charge.Show
End Sub

Private Sub Timer1_Timer()
    Dim temprary_temp As Double
    temprary_temp = GetTemp
    
    'temp.Text = v_temp
If (v_prev_temp1 - temprary_temp) < 0.5 Then
    v_temp = temprary_temp
    temp2.Caption = Format(v_temp, "00.0") & " C"


    If counter = 0 Then
      v_prev_temp = v_temp
    End If
  
        counter = counter + 1
        With NTGraph1
         .PlotAreaColor = vbBlack
         .PlotXY Round(counter / 60, 1), v_temp, 0
        End With
    
    duration.Caption = Round(counter / 60, 1) & " min"
    duration_h.Caption = Round(counter / 60 / 60, 2) & " H"
    charge_capacity.Caption = Round(charge_current.Text * (counter / 3600), 2)
    
'''''''''''''''''''''''''''Get the Start temp after 1 min''''''''''''''
    If counter = 60 Then
        vStartTemp = v_temp
        'MsgBox "start :" & vStartTemp
    End If
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    
    If ChargeFinished(v_temp) = "temp" Then
       status_label.Caption = "Max Temp. Exceeded ..."
       StopCharging
       
    ElseIf ChargeFinished(v_temp) = "time" Then
       status_label.Caption = "Max Time. Exceeded ..."
       StopCharging

    End If
    
    v_prev_temp1 = v_temp
 'Else
 ' MsgBox "The Wrong temp: " & temprary_temp
    
End If
   
End Sub

Public Sub PowerOn()
    MSComm1.RTSEnable = True
    ChargeFlash.Enabled = True
End Sub


Public Sub PowerOff()
    MSComm1.RTSEnable = False
    ChargeFlash.Enabled = False
    chargeShape.FillStyle = 1
    
End Sub

Public Sub Discharge_on()
    MSComm1.RTSEnable = True
    DischargeFlash.Enabled = True
End Sub

Public Sub Discharge_off()
    MSComm1.RTSEnable = False
    DischargeFlash.Enabled = False
    DischargeShape.FillStyle = 1
    
End Sub

Public Function is_charged() As Boolean
    If MSComm1.CTSHolding = True Then
       is_charged = True
    Else
       is_charged = False
    End If
End Function

' Modified by Hossam on 9/4/2007
' To let the function to return the termination method ( time or temp )

Public Function ChargeFinished(pTemp As Double) As String
  
  Dim maxTemp As Double
  
    If counter < 60 Then
       maxTemp = Val(max_temp.Text)
    Else
        maxTemp = vStartTemp + v_Temp_Diff
        If maxTemp > Val(max_temp.Text) Then
          maxTemp = Val(max_temp.Text)
        End If
        'MsgBox "Cut off: " & maxTemp
    End If
    
    If pTemp >= maxTemp Then
        ChargeFinished = "temp"
    ElseIf counter > Val(max_time.Text) * 60 Then
        ChargeFinished = "time"
    Else
        ChargeFinished = ""
    End If
  
End Function

Private Sub clrTxt()
    For Each txt In Me.Controls
        If TypeOf txt Is TextBox Then
          txt.Text = ""
        End If
    Next
    discharge_current.Text = 500
End Sub


Public Function GetTemp() As Double
Set tmr = New PerformanceTimer
Dim temp As Double
Dim elapsedTime As Long
Dim RunOutCounter As Long
    
    RunOutCounter = 0
    MSComm1.DTREnable = True

    tmr.StartTimer
    Do
        RunOutCounter = RunOutCounter + 1
        
        ' check for the hardware
        If RunOutCounter > 10000 Then
            MsgBox "Cann't detect the smart Charger .. ", vbCritical
            PowerOff
            Timer1.Enabled = False
            FinishTimer.Enabled = False
            Exit Do
        End If
        
    Loop While MSComm1.DSRHolding = False
    tmr.StopTimer
    
    elapsedTime = tmr.TimeElapsed(pvMicroSecond)
    temp = Round(2722 / Log(Val(elapsedTime)) - 218.5, 1)
    MSComm1.DTREnable = False
    GetTemp = temp
End Function

Public Sub StopCharging()
        PowerOff
        Timer1.Enabled = False
        FinishTimer.Enabled = False
        end_time.Caption = Time
        NTGraph1.SaveAs (Form1.profile_name.Text & Format(Date, " dd-mm-yyyy") & "-" & Format(Time, "HH.MM") & ".jpg")
       
        SaveLog
        Close #1

        
        If Trickle_check.Value = 1 Then
            SwitchToTrickle
        End If
        
        If shutdown.Value = 1 Then
         ShutDownPC
        End If
        
        
        'MsgBox "Battery Charged .. " & "Slope: " & slope.Caption & " Temp.: " & temp2.Caption & "prev_temp:" & v_prev_temp
        'MsgBox "Battery Charged .. ", vbInformation
     
End Sub
Public Sub OpenLog()
  
  ' log information
  ' Added in 9/4/2007
  Open "charger.Log" For Append As #1
  Print #1, vbCrLf
  Print #1, Date & " " & start.Caption
  Print #1, "Profile: " & Form1.profile_name
  Print #1, "Charge Current: " & charge_current.Text & "mA"
  Print #1, "Start temp.   : " & ambient.Caption

End Sub
Public Sub SaveLog()
    ' Saving data into log
    Print #1, "Finsihed with: " & status_label.Caption
    Print #1, "     Charging capacity: " & charge_capacity.Caption & "mAh"
    Print #1, "     Elapsed time     : " & duration.Caption
    Print #1, "     Max. temperature : " & temp2.Caption
    Print #1, "     Max. Slobe       : " & max_slope.Caption
    
End Sub


Public Sub SwitchToTrickle()
    status_label.Caption = ".. Trickle Charging .."
    trickle_toff.Interval = Round((Val(Form1.charge_current) / (0.05 * Val(batt_capacity)) - 1) * 1000, 0)
    'MsgBox (Val(Form1.charge_current) / (0.05 * Val(batt_capacity)) - 1) * 1000
    trickle_toff.Enabled = True
End Sub



Private Sub trickle_toff_Timer()
    PowerOn
    trickle_ton.Enabled = True
    
End Sub

Private Sub trickle_ton_Timer()
    PowerOff
    trickle_ton.Enabled = False
End Sub

Public Sub ShutDownPC()
 ExitWindows EWX_SHUTDOWN, &HFFFFFFFF
End Sub

