#include "MeOrion.h"
#include <Arduino.h>
#include "SoftwareSerial.h"
#include <Wire.h>
//#include <stdlib.h>
#define DISTMIN 35
#define STEP 10
#define DELAY 200
#define ANGLEMAX 140
#define ANGLEMIN 60
#define CENTER 90
#define LMAX 75
#define RMAX 115

MeBluetooth bluetooth(5);
MeUltrasonicSensor ultraS(7);
MeEncoderNew moteurard(0x09, SLOT1);
MeEncoderNew moteurarg(0x09, SLOT2);
MePort portcam(3);
Servo Aubaservo;
Servo Gaudroiservo;
int16_t servo1pin =  portcam.pin1();
int16_t servo2pin =  portcam.pin2();
MePort portdir(4);
Servo Dirservo;
int16_t servo3pin =  portdir.pin1();


long randNumber;
int moveSpeed = 150;
unsigned char table[128] = {0};
char cmd;
char incoming[5]="    ";

void setup()
{
  Serial.begin(115200);
  Serial.setTimeout(100);
  bluetooth.begin(115200);
  delay (DELAY);
  Aubaservo.attach(portcam.pin2());
  Gaudroiservo.attach(portcam.pin1());
  Dirservo.attach(portdir.pin1());
  Centservo();
  Dirservo.write(CENTER);
  moteurarg.begin();
  moteurard.begin();
  Serial.print( "salut lolo :)\n");
}

void loop()
{
  int position1, moveSpeed, dir, dir1;
  if ( Serial.available() >=  5) {
    char cmd = Serial.read();
   // Serial.print( cmd);

    char incoming[5]="    ";
    Serial.readBytes(incoming, 4);
   // Serial.print( incoming);
    
  if ( cmd == 'c' ) {
   // Serial.print( "step1");
         if ( strcmp( incoming, "link" ) == 0 ) Connected();
         else if ( strcmp( incoming, "frwd" ) == 0 ) Forward();
         else if ( strcmp( incoming, "stop" ) == 0 ) Stop();
         else if ( strcmp( incoming, "left" ) == 0 ) Left();
         else if ( strcmp( incoming, "rght" ) == 0 ) Right();
         else if ( strcmp( incoming, "flft" ) == 0 ) frontLeft();
         else if ( strcmp( incoming, "frgt" ) == 0 ) frontRight();
         else if ( strcmp( incoming, "brgt" ) == 0 ) backLeft();
         else if ( strcmp( incoming, "brgt" ) == 0 ) backRight();
         else if ( strcmp( incoming, "rvrs" ) == 0 ) Back();
         else if ( strcmp( incoming, "camu" ) == 0 ) Camup();
         else if ( strcmp( incoming, "camd" ) == 0 ) Camdown();
         else if ( strcmp( incoming, "caml" ) == 0 ) Camleft();
         else if ( strcmp( incoming, "camr" ) == 0 ) Camright();
         else if ( strcmp( incoming, "rmod" ) == 0 ) Modretro();
         else if ( strcmp( incoming, "cent" ) == 0 ) Centservo();
          }
          

    else if ( cmd == 'v' ) {
            bool num = true;
           while (num){
              position1 = atoi(incoming);
        if (position1 < ANGLEMAX && position1 > ANGLEMIN){
          Aubaservo.write(position1);
          num = false;
              }
          else if (position1 >= ANGLEMAX){
              Aubaservo.write(ANGLEMAX);
            num = false;
              }
          else if (position1 <= ANGLEMIN){
               Aubaservo.write(ANGLEMIN);
               num = false;
              }
            }
           }
     else if ( cmd == 'h' ) {
            bool num = true;
           while (num){
              position1 = atoi(incoming);
        if (position1 < ANGLEMAX && position1 > ANGLEMIN){
          Gaudroiservo.write(position1);
          num = false;
              }
          else if (position1 >= ANGLEMAX){
              Gaudroiservo.write(ANGLEMAX);
            num = false;
              }
          else if (position1 <= ANGLEMIN){
               Gaudroiservo.write(ANGLEMIN);
               num = false;
              }
    }
  }
  }
}
void Connected()
{
  Serial.print("tout est operationnel \n vitesse = ");
  Serial.print(moveSpeed);
  Serial.print("\n");
  Forward();
  delay(DELAY);
  Back();
  delay(300);
  Stop();
}
void FwdBck()
{
  Dirservo.write(CENTER);
  delay(100);
  Dirservo.write(95);
  delay(DELAY);
}
void Forward()
{
  FwdBck(); 
  moteurarg.runSpeed(-moveSpeed);
  moteurard.runSpeed(moveSpeed);
  Serial.print("avance\n ");
}
void Back()
{
  FwdBck();
  moteurarg.runSpeed(moveSpeed);
  moteurard.runSpeed(-moveSpeed);
}

void frontLeft()
{    
  Dirservo.write(LMAX);
  moteurarg.runSpeed(-moveSpeed);
  moteurard.runSpeed(moveSpeed*2);

}
void frontRight()
{
  Dirservo.write(RMAX);
  moteurarg.runSpeed(-moveSpeed*2);
  moteurard.runSpeed(moveSpeed);
}
void Left()
{
  moteurarg.runSpeed(-moveSpeed );
  moteurard.runSpeed(-moveSpeed );
}
void Right()
{
  moteurarg.runSpeed(moveSpeed );
  moteurard.runSpeed(moveSpeed );
}
void backLeft()
{
  Dirservo.write(RMAX);
  moteurarg.runSpeed(moveSpeed*2 );
  moteurard.runSpeed(-moveSpeed );
}
void backRight()
{
  Dirservo.write(LMAX);
  moteurarg.runSpeed(moveSpeed );
  moteurard.runSpeed(-moveSpeed*2 );
}
void Stop()
{
  moteurarg.runSpeed(0);
  moteurard.runSpeed(0);
  Serial.print("stop\n ");
}

void Centservo()
{
  Gaudroiservo.attach(portcam.pin1());
  Aubaservo.attach(portcam.pin2());
  Gaudroiservo.write(CENTER);
  Aubaservo.write(CENTER);
  delay(DELAY);
  Serial.print("Gaudroi = ");
  Serial.print(CENTER);
  Serial.print("\nAuba = ");
  Serial.print(CENTER);
  Serial.print("\n");
}
void Modretro()
{
  Aubaservo.attach(portcam.pin2());
  Aubaservo.write(30);
  delay(DELAY);
  Gaudroiservo.attach(portcam.pin1());
  Gaudroiservo.write(90);
  delay(DELAY);
}

void Camup()
{
int angle = Aubaservo.read();
 Serial.print(angle);
if (angle < ANGLEMAX){
  Aubaservo.write(angle + STEP);
}
else {
  Aubaservo.write(ANGLEMAX);
}
}
void Camdown()
{
int angle = Aubaservo.read();
 Serial.print(angle);
if (angle > ANGLEMIN){
  Aubaservo.write(angle - STEP);
}
else {
  Aubaservo.write(ANGLEMIN);
}
}
void Camleft()
{
int angle = Gaudroiservo.read();
 Serial.print(angle);
if (angle < ANGLEMAX){
  Gaudroiservo.write(angle + STEP);
}
else {
  Gaudroiservo.write(ANGLEMAX);
}
}
void Camright()
{
int angle = Gaudroiservo.read();
 Serial.print(angle);
if (angle >ANGLEMIN){
  Gaudroiservo.write(angle - STEP);
}
else {
  Gaudroiservo.write(ANGLEMIN);
}
}

void SlowDown()
{
  moveSpeed = moveSpeed - STEP;
}
void SpeedUp()
{
  moveSpeed = moveSpeed + STEP;
}