/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.SerialException;
import processing.app.debug.RunnerException;
import processing.app.debug.Target;
import processing.app.debug.Uploader;

public class AvrdudeUploader
extends Uploader {
    public boolean uploadUsingPreferences(String buildPath, String className, boolean verbose) throws RunnerException, SerialException {
        Target t;
        this.verbose = verbose;
        Map<String, String> boardPreferences = Base.getBoardPreferences();
        String uploadUsing = boardPreferences.get("upload.using");
        if (uploadUsing == null) {
            uploadUsing = Preferences.get("upload.using");
        }
        if (uploadUsing.equals("bootloader")) {
            return this.uploadViaBootloader(buildPath, className);
        }
        if (uploadUsing.indexOf(58) == -1) {
            t = Base.getTarget();
        } else {
            String targetName = uploadUsing.substring(0, uploadUsing.indexOf(58));
            t = Base.targetsTable.get(targetName);
            uploadUsing = uploadUsing.substring(uploadUsing.indexOf(58) + 1);
        }
        Collection params = this.getProgrammerCommands(t, uploadUsing);
        params.add("-Uflash:w:" + buildPath + File.separator + className + ".hex:i");
        return this.avrdude(params);
    }

    private boolean uploadViaBootloader(String buildPath, String className) throws RunnerException, SerialException {
        Map<String, String> boardPreferences = Base.getBoardPreferences();
        ArrayList<String> commandDownloader = new ArrayList<String>();
        String protocol = boardPreferences.get("upload.protocol");
        if (protocol.equals("stk500")) {
            protocol = "stk500v1";
        }
        commandDownloader.add("-c" + protocol);
        commandDownloader.add("-P" + (Base.isWindows() ? "\\\\.\\" : "") + Preferences.get("serial.port"));
        commandDownloader.add("-b" + Integer.parseInt(boardPreferences.get("upload.speed")));
        commandDownloader.add("-D");
        commandDownloader.add("-Uflash:w:" + buildPath + File.separator + className + ".hex:i");
        if (boardPreferences.get("upload.disable_flushing") == null || boardPreferences.get("upload.disable_flushing").toLowerCase().equals("false")) {
            this.flushSerialBuffer();
        }
        return this.avrdude(commandDownloader);
    }

    public boolean burnBootloader(String targetName, String programmer) throws RunnerException {
        return this.burnBootloader(this.getProgrammerCommands(Base.targetsTable.get(targetName), programmer));
    }

    private Collection getProgrammerCommands(Target target, String programmer) {
        Map<String, String> programmerPreferences = target.getProgrammers().get(programmer);
        ArrayList<String> params = new ArrayList<String>();
        params.add("-c" + programmerPreferences.get("protocol"));
        if ("usb".equals(programmerPreferences.get("communication"))) {
            params.add("-Pusb");
        } else if ("serial".equals(programmerPreferences.get("communication"))) {
            params.add("-P" + (Base.isWindows() ? "\\\\.\\" : "") + Preferences.get("serial.port"));
            if (programmerPreferences.get("speed") != null) {
                params.add("-b" + Integer.parseInt(programmerPreferences.get("speed")));
            }
        }
        if (programmerPreferences.get("force") != null && programmerPreferences.get("force").toLowerCase().equals("true")) {
            params.add("-F");
        }
        if (programmerPreferences.get("delay") != null) {
            params.add("-i" + programmerPreferences.get("delay"));
        }
        return params;
    }

    protected boolean burnBootloader(Collection params) throws RunnerException {
        Target t;
        Map<String, String> boardPreferences = Base.getBoardPreferences();
        ArrayList<String> fuses = new ArrayList<String>();
        fuses.add("-e");
        fuses.add("-Ulock:w:" + boardPreferences.get("bootloader.unlock_bits") + ":m");
        if (boardPreferences.get("bootloader.extended_fuses") != null) {
            fuses.add("-Uefuse:w:" + boardPreferences.get("bootloader.extended_fuses") + ":m");
        }
        fuses.add("-Uhfuse:w:" + boardPreferences.get("bootloader.high_fuses") + ":m");
        fuses.add("-Ulfuse:w:" + boardPreferences.get("bootloader.low_fuses") + ":m");
        if (!this.avrdude(params, fuses)) {
            return false;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        String bootloaderPath = boardPreferences.get("bootloader.path");
        if (bootloaderPath.indexOf(58) == -1) {
            t = Base.getTarget();
        } else {
            String targetName = bootloaderPath.substring(0, bootloaderPath.indexOf(58));
            t = Base.targetsTable.get(targetName);
            bootloaderPath = bootloaderPath.substring(bootloaderPath.indexOf(58) + 1);
        }
        File bootloadersFile = new File(t.getFolder(), "bootloaders");
        File bootloaderFile = new File(bootloadersFile, bootloaderPath);
        bootloaderPath = bootloaderFile.getAbsolutePath();
        ArrayList<String> bootloader = new ArrayList<String>();
        bootloader.add("-Uflash:w:" + bootloaderPath + File.separator + boardPreferences.get("bootloader.file") + ":i");
        bootloader.add("-Ulock:w:" + boardPreferences.get("bootloader.lock_bits") + ":m");
        return this.avrdude(params, bootloader);
    }

    public boolean avrdude(Collection p1, Collection p2) throws RunnerException {
        ArrayList p = new ArrayList(p1);
        p.addAll(p2);
        return this.avrdude(p);
    }

    public boolean avrdude(Collection params) throws RunnerException {
        ArrayList<String> commandDownloader = new ArrayList<String>();
        commandDownloader.add("avrdude");
        if (Base.isLinux()) {
            commandDownloader.add("-C" + Base.getHardwarePath() + "/tools/avrdude.conf");
        } else {
            commandDownloader.add("-C" + Base.getHardwarePath() + "/tools/avr/etc/avrdude.conf");
        }
        if (this.verbose || Preferences.getBoolean("upload.verbose")) {
            commandDownloader.add("-v");
            commandDownloader.add("-v");
            commandDownloader.add("-v");
            commandDownloader.add("-v");
        } else {
            commandDownloader.add("-q");
            commandDownloader.add("-q");
        }
        commandDownloader.add("-p" + Base.getBoardPreferences().get("build.mcu"));
        commandDownloader.addAll(params);
        return this.executeUploadCommand(commandDownloader);
    }
}

