#include <UTFT.h>
#include <UTouch.h>
#include <EEPROM.h>
//#include <SoftwareSerial.h>
#include <avr/pgmspace.h>

#define pad_bk 0,150,0 // R,G,B
#define reticle_color 0,255,0 //R,G,B

#define pad_topX 10
#define pad_topY 10
#define pad_bottomX 229
#define pad_bottomY 229

byte MIDIcontroller = 1;

UTFT myGLCD(ITDB24, A5,A4,A3,A2); 
UTouch myTouch(A1,10,A0,8,9);
extern uint8_t BigFont[];
extern unsigned int arrow_ico[0x546];
long old_x=10, old_y=10;

byte old_valueX;
byte old_valueY;

bool MIDIXsend = true;
bool ConfigSaved = true;

//SoftwareSerial mySerial(41, 43); // RX, TX

void setup()
{

  readConfig();
  myGLCD.InitLCD(LANDSCAPE);
  myGLCD.clrScr();
  myGLCD.setFont(BigFont);
  
  myTouch.InitTouch(LANDSCAPE);
  myTouch.setPrecision(PREC_EXTREME);
  //myGLCD.fillScr(255,144,0);

  Serial1.begin(31250);
  //mySerial.begin(31250);
  
  draw_Main();
}
void loop()
{
  long x, y;
  byte valueX;
  byte valueY;

  while (myTouch.dataAvailable() == true)
  {
    myTouch.read();
    x = myTouch.getX();
    y = myTouch.getY();
    if ((x!=-1) and (y!=-1))
    {
      
      if((x>=pad_topX) and (x<=pad_bottomX) and (y>=pad_topX) and (y <=pad_bottomY)) // XY pad touch
      {
        draw_Pad(x,y);
        old_x=x;
        old_y=y;
        valueX=CoordToMIDI(x-pad_topX);
        valueY=127-CoordToMIDI(y-pad_topY);  // on fl studio y axis begin from bottom, on tft y axis begin from top
        //myGLCD.printNumI(valueX,30,30,3);
        //myGLCD.printNumI(valueY,30,50,3);        
        
        if (valueX!=old_valueX)
        {
          // send midi X        
          SendMIDIControl(1,MIDIcontroller,valueX);  // channel=1 , control , value
          old_valueX = valueX;
        }   
        if (valueY!=old_valueY)
        {
          // send midi Y       
          SendMIDIControl(1,MIDIcontroller+1,valueY);  // channel=1 , control , value
          old_valueY = valueY;
        }   
        
       }
      if ((x>=239) and (x<=312) and (y>=8) and (y<=58) and !ConfigSaved) // button1 fired
      {
        ConfigSaved=true;
        myGLCD.setColor(255,255,255);    //set color white for pop-up message
        myGLCD.print("Config.",100,100); //display popup message row1
        myGLCD.print("saved",100,120);   //display popup message row2
        saveConfig();
        delay(1000);
        myGLCD.print("       ",100,100); // delete pop-up message row1
        myGLCD.print("      ",100,120);  // delete pop-up message row2
        draw_Pad(old_x,old_y);           // redraw pad reticle
        myGLCD.setColor(reticle_color);      
        myGLCD.printNumI(MIDIcontroller,240,42,3,'0'); //redraw MIDI control 
        
      }
      if ((x>=239) and (x<=312) and (y>=68) and (y<=116)) // button2 fired
      {
        if (MIDIcontroller<99) 
        {
          MIDIcontroller=MIDIcontroller+2;
          myGLCD.setColor(255,255,255);
          myGLCD.printNumI(MIDIcontroller,240,42,3,'0');
          ConfigSaved=false;
          delay(50);        
        }
      }    
      if ((x>=239) and (x<=312) and (y>=124) and (y<=174)) // button3 fired
      {
        if (MIDIcontroller>1)
        {
          MIDIcontroller=MIDIcontroller-2;        
          myGLCD.setColor(255,255,255);
          myGLCD.printNumI(MIDIcontroller,240,42,3,'0');
          ConfigSaved=false;
          delay(50);
        }        
      }    
      if ((x>=239) and (x<=312) and (y>=182) and (y<=232)) // button4 fired
      {
        myGLCD.setColor(255,255,255);
        if (MIDIXsend)
        {
          SendMIDIControl(1,MIDIcontroller,old_valueX);  // chanel , control , value
          myGLCD.print("MIDI X",100,100);
          MIDIXsend=false;
        }
        else
        {
          SendMIDIControl(1,MIDIcontroller+1,old_valueY);  // chanel , control , value
          myGLCD.print("MIDI Y",100,100);
          MIDIXsend=true;        }
        myGLCD.print("send",100,120);
        delay(800);
        myGLCD.print("      ",100,100);
        myGLCD.print("    ",100,120);
        draw_Pad(old_x,old_y); 
      }
    }
  }
}

void draw_Main()
{
  myGLCD.setColor(pad_bk);
  myGLCD.fillRect(pad_topX-2,pad_topY-2,pad_bottomX+2,pad_bottomY+2);
  myGLCD.setColor(reticle_color);
  myGLCD.drawRect(pad_topX-2,pad_topY-2,pad_bottomX+2,pad_bottomY+2);  
  myGLCD.setColor(pad_bk);
  myGLCD.setBackColor(pad_bk);

  myGLCD.fillRect(239,8,312,58); //button1 background 
  myGLCD.fillRect(239,68,312,116); //button2 background 
  myGLCD.fillRect(239,124,312,174); //button3 background 
  myGLCD.fillRect(239,182,312,232); //button4 background 
  myGLCD.setColor(reticle_color);
  myGLCD.drawRect(239,8,312,58); //button1 rectangle
  myGLCD.drawRect(239,68,312,116); //button2 rectangle
  myGLCD.drawRect(239,124,312,174); //button3 rectangle
  myGLCD.drawRect(239,182,312,232); //button4rectangle

  myGLCD.print("MIDI",240,22); //button1 text
  myGLCD.printNumI(MIDIcontroller,240,42,3,'0'); //button1 text
  myGLCD.print("CTRL",240,78); //button2 text - line 1
  myGLCD.print("+",265,98); //button2 text - line 2
  myGLCD.print("CTRL",240,134); //button3 text - line 1
  myGLCD.print("-",265,154); //button3 text - line 2
  myGLCD.print("MIDI",240,192); //button4 text - line 1
  myGLCD.print("send",240,210); //button4 text - line 2
}

void draw_Pad(long x, long y)
{
      // we draw 3 three lines for x and three lines for y
      // for better visibility
      myGLCD.setColor(pad_bk);
      myGLCD.drawLine(old_x-1,pad_topY,old_x-1,pad_bottomY); // clear old line x-1
      myGLCD.drawLine(old_x+1,pad_topY,old_x+1,pad_bottomY); // clear old line x+1
      myGLCD.drawLine(old_x,pad_topY,old_x,pad_bottomY);     // clear old line x
      myGLCD.drawLine(pad_topX,old_y-1,pad_bottomY,old_y-1); // clear old line y-1    
      myGLCD.drawLine(pad_topX,old_y+1,pad_bottomY,old_y+1); // clear old line y+1    
      myGLCD.drawLine(pad_topX,old_y,pad_bottomY,old_y);     // clear old line y
      myGLCD.setColor(reticle_color);
      myGLCD.drawLine(x-1,pad_topY,x-1,pad_bottomY);         // draw new line x-1
      myGLCD.drawLine(x+1,pad_topY,x+1,pad_bottomY);         // draw new line x+1
      myGLCD.drawLine(x,pad_topY,x,pad_bottomY);             // draw new line x
      myGLCD.drawLine(pad_topX,y-1,pad_bottomX,y-1);         // draw new line1 y-1
      myGLCD.drawLine(pad_topX,y+1,pad_bottomX,y+1);         // draw new line2 y+1
      myGLCD.drawLine(pad_topX,y,pad_bottomX,y);             // draw new line3 y
}

byte CoordToMIDI(unsigned int coord)
{
  float temp;
  temp=coord;
  temp=temp/1.72;
  return (byte)temp;  
}

void SendMIDIControl(byte channel, byte controller, byte value) {
  byte tmpChannel = (channel & 0b00001111)-1;       //0= channel ...  1=channel2 ... etc
  tmpChannel = 0b10110000 + tmpChannel;             //midi data first bit allways 1, + 011 control change command + midi channel
  byte tmpController = controller & 0b01111111;    //midi data first bit allways 0
  byte tmpValue = value & 0b01111111;              //midi data first bit allways 0
  Serial1.write(tmpChannel);
  Serial1.write(tmpController);
  Serial1.write(tmpValue);
}

void saveConfig(){
  EEPROM.write(0, MIDIcontroller); // write at eeprom addr 0
}

void readConfig(){
  MIDIcontroller=EEPROM.read(0);  
  // if value is 0 or >99 , invalid value , initialize to 1,
  if ((MIDIcontroller==0) or (MIDIcontroller>99)) MIDIcontroller=1;
  
}
