// *****************************************************************
// ****                 Automatic Tubular Bells                 ****
// ****                     www.tolaemon.com                    ****
// ****                       Source code                       ****
// ****                  01/01/2006 - 01/09/2006                ****
// ****                     Jordi Bartolome                     ****
// ****                                                         ****
// **** IMPORTANT:                                              ****
// **** Using parts of this code means accepting all conditions ****
// **** exposed on the atb web: www.tolaemon.com/atb            ****
// *****************************************************************

#include <C:\Archivos de programa\WinAVR\avr\include\inttypes.h>
#include <C:\Archivos de programa\WinAVR\avr\include\avr\io.h>
#include <C:\Archivos de programa\WinAVR\avr\include\avr\interrupt.h>
#include <C:\Archivos de programa\WinAVR\avr\include\avr\iom32.h>

#include "movements.h"

#if defined(COM11)
#  define XCOM11 COM11
#elif defined(COM1A1)
#  define XCOM11 COM1A1
#else
#  error "need either COM1A1 or COM11"
#endif

#ifndef _UARTPARSER_
#define _UARTPARSER_

#define F_OSC 8000000 /* oscillator-frequency in Hz */
#define UART_BAUD_RATE 9600
#define UART_BAUD_CALC(UART_BAUD_RATE,F_OSC) ((F_OSC)/((UART_BAUD_RATE)*16l)-1)


#define INITIAL_COMMAND_SYMBOL '<'
#define FINAL_COMMAND_SYMBOL '>'

#define MOVEMENTS_START 'S'
#define MOVEMENTS_CLEAR 'C'
#define MOVEMENTS_ADD 'A'

void USART_Force_Transmit( unsigned char data );
void UARTPARSER_Init();
void USART_Force_Transmit( uint8_t data );
uint8_t UARTPARSER_InputShift(uint8_t value);
uint8_t UARTPARSER_InputUnshift(uint8_t * value);
uint8_t UARTPARSER_InputGet(uint8_t * value);
uint8_t UARTPARSER_OutputShift(uint8_t value);
uint8_t UARTPARSER_OutputUnshift(uint8_t * value);
uint8_t UARTPARSER_OutputGet(uint8_t * value);
void UARTPARSER_PollInputBuffer();
void UARTPARSER_PollOutputBuffer();



#endif

