// *****************************************************************
// ****                 Automatic Tubular Bells                 ****
// ****                     www.tolaemon.com                    ****
// ****                       Source code                       ****
// ****                  01/01/2006 - 01/09/2006                ****
// ****                     Jordi Bartolome                     ****
// ****                                                         ****
// **** IMPORTANT:                                              ****
// **** Using parts of this code means accepting all conditions ****
// **** exposed on the atb web: www.tolaemon.com/atb            ****
// *****************************************************************

#include <C:\Archivos de programa\WinAVR\avr\include\inttypes.h>
#include <C:\Archivos de programa\WinAVR\avr\include\avr\io.h>
#include <C:\Archivos de programa\WinAVR\avr\include\avr\interrupt.h>
#include <C:\Archivos de programa\WinAVR\avr\include\avr\iom32.h>
#include "motors.h"

#ifndef _MOVEMENTS_
#define _MOVEMENTS_

#define N_MOVEMENT_COMPONENTS 4	// number of movements components for a motor

#define FREE 0 // it is free, it has no movement programed
#define READY 1 // it is has all or some movement components programed and is ready to run
#define RUNNING 2 // it is executint the movement
#define FINISHED 3 // it has been executed and now is finished

typedef struct{
	uint8_t ints_cicle_level_limit;// number of interruptions of a cicle on which the motor has energy (controls duty cicle)
	uint8_t n_cicles;// number of cicles on which the motor will have
	uint8_t direction;// direction on which the motor is running
}t_movement_component;

typedef struct{
	t_movement_component component[N_MOVEMENT_COMPONENTS]; // basic movement component and is equivalent to a motor action
	uint8_t total;// number of movement components which compose the movement
	uint8_t index;// the movement component which is being executed by the motor
	uint8_t state;// the state of the movement
}t_movement;

t_movement movement[6];

void MOVEMENTS_Init();
void MOVEMENTS_Start(uint8_t n_movement);
void MOVEMENTS_Clear(uint8_t n_movement);
uint8_t MOVEMENTS_Finished_or_Free(uint8_t n_motor);
void MOVEMENTS_Add(uint8_t n_motor,uint8_t ints_cicle_level_limit,uint8_t n_cicles,uint8_t direction);
void MOVEMENTS_Check();


#endif
