// *****************************************************************
// ****                 Automatic Tubular Bells                 ****
// ****                     www.tolaemon.com                    ****
// ****                       Source code                       ****
// ****                  01/01/2006 - 01/09/2006                ****
// ****                     Jordi Bartolome                     ****
// ****                                                         ****
// **** IMPORTANT:                                              ****
// **** Using parts of this code means accepting all conditions ****
// **** exposed on the atb web: www.tolaemon.com/atb            ****
// *****************************************************************

#include <C:\Archivos de programa\WinAVR\avr\include\inttypes.h>
#include <C:\Archivos de programa\WinAVR\avr\include\avr\io.h>
#include <C:\Archivos de programa\WinAVR\avr\include\avr\interrupt.h>
#include <C:\Archivos de programa\WinAVR\avr\include\avr\iom32.h>

#ifndef _MOTORS_
#define _MOTORS_

#define N_INTS_CICLE 50 // number of CTC interruptions which makes one cicle
#define N_MOTORS 6	// number of motors
#define NO_MOTION 		0 // 00
#define RIGHT_MOTION   	1 // 01
#define LEFT_MOTION     2 // 10
#define BLOCKED_MOTION  3 // 11

#define RIGHT_POSITION  1
#define FRONT_POSITION	2
#define LEFT_POSITION  	3
#define BACK_POSITION	4

typedef struct {
	uint8_t ints_cicle_level_limit;// number of interruptions of a cicle on which the motor has energy (controls duty cicle)
	uint8_t n_cicles;// number of cicles on which the motor will have
	uint8_t direction;// direction on which the motor is running
	uint8_t position;// position of the motor
}t_motor;

uint8_t MOTORS_State(uint8_t n_motor);
uint8_t MOTORS_Position(uint8_t n_motor);
void MOTORS_Set(uint8_t n_motor,uint8_t ints_cicle_level_limit,uint8_t n_cicles,uint8_t direction);
void MOTORS_Init();
void MOTORS_Check();
void MOVEMENTS_Center();

#endif
