// *****************************************************************
// ****                 Automatic Tubular Bells                 ****
// ****                     www.tolaemon.com                    ****
// ****                       Source code                       ****
// ****                  01/01/2006 - 01/09/2006                ****
// ****                     Jordi Bartolome                     ****
// ****                                                         ****
// **** IMPORTANT:                                              ****
// **** Using parts of this code means accepting all conditions ****
// **** exposed on the atb web: www.tolaemon.com/atb            ****
// *****************************************************************

#include <C:\Archivos de programa\WinAVR\avr\include\inttypes.h>
#include <C:\Archivos de programa\WinAVR\avr\include\avr\io.h>
#include <C:\Archivos de programa\WinAVR\avr\include\avr\interrupt.h>
#include <C:\Archivos de programa\WinAVR\avr\include\avr\iom32.h>
#include "motors.h"
#include "movements.h"
#include "uartparser.h"


/* Peripheral and hardware intialization */
void ioinit (void) {
	/* Port A configuration */
	DDRA = DDRA|0xF0;/* port A first 4 bits as input [0..3] and 4 last bits as output [4..7] */	
	PORTA=PORTA&0x0F;/* port A last 4 bits initial value 0x0*/
	
	/* Port C configuration */
	DDRC = DDRC|0xFF;/* port C as output, remember to disable OCDEN otherway we wont be able to acces PORTC 3..5 */

	/* Port D configuration */
	DDRD = DDRD|0xFE;/* port D as output except bit 0 */

	// Timer configuration
	TCCR0 = TCCR0 |(1<<CS01)|(1<<CS00);// configuracion del preescaler del TIMER0 CLK/64 por lo que el TIMER0 se incrementa cada 4000000/64=62500 veces/seg lo que equivale a una sea de sicnronismo de T=0,016ms
	TCCR0 = TCCR0 |(1<<WGM01);// se pone el timer en mode CTC (WGM00=0,WGM01=1): cuando el valor del contador TCT0 sea igual a del registro TCCR0 se resetee y TCNT0 valga 0 de nuevo
	OCR0 = 63;// cuando el contador valga X (TCNT0=X=OCR) se genera interrupcion y el timer se resetear de nuevo
	TIMSK=TIMSK|(1<<OCIE0);// activo la interrupcion por TIME COMPARE 0 asi cuando (TCNT0=OCR) habra interrupcion

	// USART Initialitzation
	UARTPARSER_Init( );

	SREG=SREG|0x80;/* activo las interrupciones */

};//ioinit



/* Function which takes de value recived on "data" and sends it through the USART. If the
   byte has been trnasmitted without problems it returns 1, but if the transfer fails it
   returns 0 */
unsigned char USART_Transmit( unsigned char data ){
	unsigned char retorno=0;

	if ( !( UCSRA & (1<<UDRE)) ){
		// si el buffer de tansmision todavia no esta vacio
		retorno=0;
	}else{
		// si el buffer ya esta vacio se pone el dato para q se envie
		UDR = data;
		retorno = 1;
	};//if
	return retorno;
	
};//USART_Transmit


int main (void) {
	
	// system peripherals are intialized
	ioinit ();
	
	UARTPARSER_OutputShift('O');
	UARTPARSER_OutputShift('K');
	
	MOTORS_Init();
	MOVEMENTS_Init();

	/* loop forever, the interrupts are doing the rest */
	for (;;){
		MOVEMENTS_Check();
		MOVEMENTS_Center();
		UARTPARSER_PollInputBuffer();
		UARTPARSER_PollOutputBuffer();
	};/*for*/
	return (0);

}
