//group of arrows
pointer[] pointers; 
boolean reset = true;
int num;
public static float yPos, yPos2;

//twitter initialization
tweet twitter;

//Serial communication
import processing.serial.*;
Serial port;
String portname = "COM1";
int baudrate = 9600;
int reading = 0;

PImage picture,blueButton,redButton;
//initialize play for mp3
import ddf.minim.*;
Minim minim;
AudioPlayer yeah;

//initialize variables
PFont font;
int target;
int level = 1;
int score = 0;
int recorded;
int achievement;
boolean win = false;
boolean lose = false;
PrintWriter output;
String[] file;
String[] values;
int[] value;

void setup() {
  size(600, 600);

  //initialize port
  port = new Serial(this, portname, baudrate);
  println(port);

  //load image
  picture = loadImage("view.jpg");
  blueButton = loadImage("bluebutton.png");
  redButton = loadImage("redbutton.png");
  
  //music
  minim = new Minim(this);
  yeah = minim.loadFile("yeah.mp3");
  yeah.play();

  //font
  font = loadFont("BerlinSansFB-Bold-48.vlw");
  textFont(font);

  values = loadStrings("Values.txt"); //load values
  value = new int[values.length];
  for (int i=0; i < values.length; i++) {
    println(values);
    value[i] = Integer.valueOf(values[i]).intValue(); //convert string to integer
  }

  file = loadStrings("Highscore.txt"); //load previous record
  for (int i=0; i < file.length; i++) {
    recorded = Integer.valueOf(file[i]).intValue(); //convert string to integer
  }
  
  frameRate(value[0]);
}

void draw() {
  yPos = 0; //reset arrow location
  yPos2 = 0;
  view(); //draw background design

  //level 1
  if (level == 1) {
    if (reset) {
      make();
      target = value[1];
    }
    if ((millis() >= value[4])&&(score >= target)) {
      level = 2;
      reset = true;
      redraw();
    }
    else if (millis() >= value[4]) {
      lose = true;
    }
  }
  //level 2
  else if (level == 2) {
    if (reset) {
      make();
      target = value[2];
    }
    if ((millis() >= value[5])&&(score >= target)) {
      level = 3;
      reset = true;
      redraw();
    }
    else if (millis() >= value[5]) {
      lose = true;
    }
  }
  //level 3
  else if (level == 3) {
    if (reset) {
      make();
      target = value[3];
    }
    if ((millis() >= value[6])&&(score >= target)) {
      win = true;
    }
    else if (millis() >= value[6]) {
      lose = true;
    }
  }

  //instructions
  textSize(40);
  text("Controls", 410, 50);
  textSize(20);
  text("'a' to hit left \n'l' to hit right", 410, 100);
  String beat = ("Target score: " + target);
  text(beat, 405, 200);
  text("Elapsed time:", 410, 250);
  text(millis()/1000, 410, 280);
  String beatH = ("Previous Highscore:\n"+recorded);
  text(beatH,410,320);

  //level and score
  fill(0);
  score = score + achievement;
  textSize(40);
  text("Score", 420, 450);
  text(score, 420, 480);
  String lev = "Level "+level;
  text(lev, 420, 410);
  achievement=0; //reset achievement

  //display arrow
  for (int i=0;i<num;i++) {
    pointers[i].arr();//make the arrow
    pointers[i].motion();
  }

  //Controls output and actions when player finishes all rounds
  if (win) {
    fill(255, 73, 73, 190);
    textSize(80);
    text("YOU WIN!!!\nPress ESC", 80, 300);
    //save("Tap score " + score +".jpg"); //can be used if you want to save display upon winning

    //compare stored highscore and save highest score
    if (score >= recorded) {
      fill(0);
      text("\tNEW\nHIGHSCORE!!!", 20, 100);
      output = createWriter("Highscore.txt");
      output.println(score);
      output.flush();
      output.close();
      
      //send result to twitter
      twitter = new tweet(score);
      twitter.sendHighscore();
    }
    noLoop(); //stop display
  }
  else if (lose) {
    fill(255, 73, 73, 190);
    textSize(80);
    text("YOU LOSE!!!\nTRY AGAIN :P", 50, 350);
    noLoop();
  }
  //read serial port
  while (port.available () > 0) {
    portRead();
  }
}

void stop() //stop music
{
  // always close Minim audio classes when you finish with them
  yeah.close();
  // always stop Minim before exiting
  minim.stop();
  super.stop();
}

void view() { //background design
  smooth();
  noStroke();
  background(0); //set white background
  image(picture,0,0);
  fill(151, 16, 201, 90);//purple bar
  quad(15, 450, 385, 450, 385, 490, 15, 490);
  fill(2,56,242,30);//side bars
  quad(400, 10, 590, 10, 590, 590, 400, 590);
  fill(242,2,79,30);
  quad(405, 15, 585, 15, 585, 585, 405, 585);
  image(blueButton, 0,450);
  image(redButton, 200,450);
  fill(30);
}

void make() { //create arrows
  num = value[7]; //number of arrows
  reset = false;
  pointers = new pointer[num];
  
  //make arrows
  for (int i=0;i<num;i++) {
    pointers[i] = new pointer(level);//make a new arrow
  }
  background(0);//show refresh
  delay(2000);
}

void portRead() { //acts almost like an interrupt when keys are pressed
  fill(255);
  reading = port.read();
  if (reading == 'A') {
    ellipse(100, 550, 80, 80);
    for (int i=0; i<pointers.length ;i++) {
      if ((yPos >= 450)) {
        achievement = 100;
      }
    }
  }
  else if (reading == 'B') {
    ellipse(300, 550, 80, 80);
    for (int i=0; i<pointers.length ;i++) {
      if ((yPos2 >= 450)) {
        achievement = 100;
      }
    }
  }
  fill(30);
}

void keyPressed() { //acts near to an interrupt when keys are pressed
  if (key == 'a') {
    ellipse(100, 550, 80, 80);
    if ((yPos >= 450)) {
      delay(5);
      achievement = 100;
    }
  }
  else if (key == 'l') {
    ellipse(300, 550, 80, 80);
    if ((yPos2 >= 450)) {
      delay(5);
      achievement = 100;
    }
  }
}
