/*

Music Player Shield Example

This example shows an application on 1Sheeld's music player shield.

By using this example, you can play and pause music from
your smartphone using 2 hardware push buttons.

*/

/* Include 1Sheeld library. */
#include <OneSheeld.h>
#include <CapacitiveSensor.h>


CapacitiveSensor minus = CapacitiveSensor(2,3);
CapacitiveSensor plus = CapacitiveSensor(2,4);
CapacitiveSensor back = CapacitiveSensor(2,5);
CapacitiveSensor playb = CapacitiveSensor(2,6);
CapacitiveSensor pauseb = CapacitiveSensor(2,7);
CapacitiveSensor nextb = CapacitiveSensor(2,8);

int ledPin = 8;
int skip_counter = 0;
int skip_enabled = 1;

int debounce=millis();
int volume=5;

typedef enum{
  ENTERPAUSED,
  PAUSED,
  ENTERPLAYING,
  PLAYING
}STATE;

STATE state = PAUSED;

void setup() 
{
  /* Start communication. */
  OneSheeld.begin();
  
  //start in paused state
  /* Turn off the LED. */
      digitalWrite(ledPin,LOW);
      /* Turn off the music. */
      MusicPlayer.pause();
      /* Wait for 300 ms. */
      delay(50);
    
  
}

void loop()
{
    long minusval = minus.capacitiveSensor(15);
    long plusval =  plus.capacitiveSensor(15);
    long backval =  back.capacitiveSensor(15);
    long playval =  playb.capacitiveSensor(15);
    long pauseval =  pauseb.capacitiveSensor(15);
    long nextval =  nextb.capacitiveSensor(15);
  
  
  
  if (minusval>700&&(millis()-debounce>500)){
    volume--;
    MusicPlayer.setVolume(volume);
    debounce=millis();
  }
  else if (plusval>700&&(millis()-debounce>500)){
    volume++;
    MusicPlayer.setVolume(volume);
    debounce=millis();
  }
  else if (backval>700&&(millis()-debounce>500)){
    MusicPlayer.previous();
    debounce=millis();
  }
  else if (playval>700&&(millis()-debounce>500)){
    MusicPlayer.play();
    debounce=millis();
  }
  else if (pauseval>700&&(millis()-debounce>500)){
    MusicPlayer.pause();
    debounce=millis();
  }
  else if (nextval>700&&(millis()-debounce>500)){
    MusicPlayer.next();
    debounce=millis();
  }

}
