' Therm4.Bas - PICAXE-08M2 (Stable Code)
' Modified 9/22/2011 to enhance finetune routine w/ scaleup values
' Modified 9/09/2011 to add 4-Line LCD display
' Modified 7/10/2011 for PICAXE 08M2
'
' Illustrates an interface with an NTC thermistor.
' Original prototype by phanderson.com
' copyright, Peter H Anderson, Baltimore, MD, June, '05
'
' Measures voltage across the thermistor and uses a combination of table lookup
' and linear interpolation to calculate the temperature in degrees C.
'
' Enhancements by M. Burnette for 08M2 and LCD code & clean-up
' copyright, Mickey R Burnette, Lawrenceville, GA, September 2011
' 929 Bytes / 2048
'
' WIRING:
' NTC is grounded on one side and 10K is used as a pull-up to +5.  
' ADC is at junction, PIN #3 on PICAXE 08M2
'
#picaxe 08m2
#Terminal off
#freq m4
'#no_data	' REMARK THIS LINE for First Time programming of uC!

' The default power-up operating frequency is 4MHz
' LCD is on port C.1 which is 08M2 physical PIN #6
' PIN #7 port C.0 commonly used for SerTxD is NOT used in this project

SYMBOL DigitC	= B0
SYMBOL WholeC	= B1	' ADVal not needed when TC_100 is calculated
SYMBOL ADValHi8	= B2
SYMBOL ADValLow2	= B3
SYMBOL N		= B4
SYMBOL SignFlag	= B4	' N is not need when this is used
SYMBOL Diff		= B5
SYMBOL DigitF	= B5	' Diff not needed when this is used
SYMBOL WholeF	= B6
SYMBOL Fract	= B7
SYMBOL COMMAND	= B8
SYMBOL WholeH	= B9
SYMBOL DigitH	= B10
SYMBOL Sign		= B11
SYMBOL WholeL	= B12
SYMBOL DigitL	= B13
SYMBOL ChangeMe14 = B14
SYMBOL ChangeMe15 = B15
SYMBOL Adjustment = B16
SYMBOL AdjMajor	= B17
'SYMBOL table - aliases for word values
SYMBOL SetPoint 	= W9
SYMBOL ADVal	= W10
SYMBOL TC_100	= W10
SYMBOL TempC	= W11
SYMBOL TempHigh   = W12
SYMBOL TempLow    = W13
'
SYMBOL CLOCK	= m4		' Default 4MHz
SYMBOL BAUD		= N4800_4	' For use with modified (OPEN J3) DataVision LCD
'Note to self: serout on C.0 gives really weird results... eats characters
SYMBOL MONITOR = C.1	' RS232 output on this pin

' Setup frequency for internal resonator
SetFreq CLOCK

' Initialize Dual 2-line LCD Display
COMMAND = 0 : GoSub DataVision

'Initialize low temperature history
TempLow = 65535

' Bytes 1 & 2 in EEPROM hold SetPoint factor (little endian)
Read 254, WORD SetPoint

'Enable C.3 pullup
Pullup %001000	' If grounded, enter EEPROM/Temperature adjustment mode
Pause 500
IF PINC.3 = 0 Then FineTune
'
' _______________________ Main Routines Follow _____________________
Top:
	GoSub MeasTemp
	If TC_100 = $7fff Then 
		COMMAND = 2 : GoSub DataVision
		serout MONITOR,BAUD,("Out of Range !!!")
		
	ELSE
		GoSub CalcTemp
		GoSub UpdateLCD_T
		GoSub UpdateLCD_L
	EndIF
	Pause 5000
	Goto Top

MeasTemp:
	ReadADC10 C.4, ADVal
	ADValHi8 = ADVal / 4    ' isolate the high 8 bits
	ADValLow2 = ADVal & $03 ' low two bits
	' Default= 10542 from Peter's calculations
	TC_100 = SetPoint
	' Lookup table range is limited
	If ADValHi8 < 16 OR ADValHi8 > 251 Then	' Out of Range
		TC_100 = $7fff
	End If
	For N = 0 to ADValHi8 ' continue to subtract (walk the table)
		Read N, Diff
		TC_100 = TC_100 - Diff
	Next
	' Now for the low two bits, a linear interpolation
	N = N + 1
	Read N, Diff
	Diff = Diff / 4 * ADValLow2
	TC_100 = TC_100 - Diff
	RETURN

CalcTemp:
	SignFlag = TC_100 / 256 / 128
	If SignFlag = 0 Then
		Sign = " "
		GoTo Positive
	Else
		TC_100 = TC_100 ^ $ffff + 1	' twos comp
		Sign = "-"
	EndIf

	Positive:
	' Celsius display
	TempC  = TC_100
	WholeC  = TempC / 100
	Fract  = TC_100 % 100
	DigitC  = Fract / 10	'WholeC "." DigitC
	' C --> F conversion
	TC_100 = TC_100 * 9 / 5 + 3200
	'
	' Farenheit display
	WholeF = TC_100 / 100
	Fract = TC_100 % 100
	DigitF = Fract / 10	'WholeF "." DigitF
	'Digit = Fract % 10
	'
	' Perform high history for Farenheit
	IF TC_100 > TempHigh Then
		TempHigh = TC_100
	EndIF
	'
	' High display
	WholeH = TempHigh / 100
	Fract = TempHigh % 100
	DigitH = Fract / 10	'WholeH "." DigitH
	'
	' Perform low history for Farenheit
	IF TC_100 < TempLow Then
		TempLow = TC_100
	EndIF
	'
	' Low display
	WholeL = TempLow / 100
	Fract = TempLow % 100
	DigitL = Fract / 10	'WholeL "." DigitL
	RETURN

DataVision:	' LCD stuff for Data Vision Dual 2x16 display Firmware 16215-1 S2RB Philco P345A
	;COMMAND = 0	' CLEAR ALL 4 LINES
	;COMMAND = 1	' GOTO Top Display
	;COMMAND = 2	' CLEAR Top Display
	;COMMAND = 3	' GOTO Lower Display
	;COMMAND = 4	' CLEAR Lower Display
	;COMMAND = 5	' Split-Line Filler Characters (16 spaces)
	;COMMAND = 6	' Lower Display OFF
	;COMMAND = 7	' Lower Display ON
	;COMMAND = 8	' Home without Clearing Top
	;COMMAND = 9	' Home without Clearing Lower

	Select Case COMMAND
		Case 0
			GoSub ClearTop
			GoSub ClearBottom
		Case 1
			serout MONITOR,BAUD,($12)
		Case 2
			GoSub ClearTop
		Case 3
			serout MONITOR,BAUD,($16)
		Case 4
			GoSub ClearBottom
		Case 5
			serout MONITOR,BAUD,("                        ")
		Case 6
			serout MONITOR,BAUD,(%00010101,%00001010)
		Case 7
			serout MONITOR,BAUD,(%00010101,%00001100)
		Case 8
			serout MONITOR,BAUD,(%00010001,%10000000)
		Case 9
			serout MONITOR,BAUD,(%00010101,%10000000)
	End Select
	RETURN
	
ClearTop:
	serout MONITOR,BAUD,(%00010001,%00000001)'Upper HOME+CLEAR L1                                    ")
	RETURN

ClearBottom:
	serout MONITOR,BAUD,(%00010101,%00000001)'Lower HOME+CLEAR L1                                   ")
	RETURN

UpdateLCD_T:
	COMMAND = 8 : GoSub DataVision	' Home Top
	COMMAND = 1 : GoSub DataVision	' Select Top
	IF WholeC < 10 then
		serout MONITOR,BAUD,(" ",Sign,#WholeC,".",#DigitC,"    Celsius")
	ELSE
		serout MONITOR,BAUD,(Sign,#WholeC,".",#DigitC,"    Celsius")
	EndIF
	COMMAND = 5 : GoSub DataVision	' Spacer
	serout MONITOR,BAUD,(" ",#WholeF,".",#DigitF,"  Farenheit")
	RETURN
	'
UpdateLCD_L:	
	COMMAND = 9 : GoSub DataVision	' Home Lower
	COMMAND = 3 : GoSub DataVision	' Select Lower
	IF WholeH < 10 then
		serout MONITOR,BAUD,("  ",#WholeH,".",#DigitH,"  Record Hi")
	ELSE
		serout MONITOR,BAUD,(" ",#WholeH,".",#DigitH,"  Record Hi")
	EndIF
	COMMAND = 5 : GoSub DataVision	' Spacer
	serout MONITOR,BAUD,(" ",#WholeL,".",#DigitL,"  Record Lo")
	RETURN

FineTune:
	' The wiper of a 10K pot is connected to C.2 and the other ends are +5 & GND
	' The wiper is adjusted until the correct temperature is displayed and the jumper
	' GNDing PINC.3 is removed to lock-in and write the correction factor to EEPROM
	COMMAND = 4 : GoSub DataVision
	COMMAND = 3 : GoSub DataVision
	serout MONITOR,BAUD,(">> Tune MODE << ")
	COMMAND = 5 : GoSub DataVision
	serout MONITOR,BAUD,("(+/-):  ",#Adjustment)
	ReadADC C.2, Adjustment		' New Low Byte
	' If the pot is at extremes for 10 seconds (5 loops) then Inc/Dec the HighByte
	If Adjustment = 0 or Adjustment = 255 then
		INC AdjMajor
	Else
		AdjMajor = 0
	EndIf
	If AdjMajor = 5 then
		SetPoint = SetPoint / 256
		Select case Adjustment
			Case 0
				DEC SetPoint
			Case 255
				INC SetPoint
		End Select
		SetPoint = SetPoint * 256
		AdjMajor = 0
	EndIf
	SetPoint = SetPoint / 256	' High Byte
	SetPoint = SetPoint * 256 + Adjustment	' New Word Value
	GoSub MeasTemp
	GoSub CalcTemp
	GoSub UpdateLCD_T
	Pause 2000
	IF PINC.3 = 0 Then FineTune
	Write 254, WORD SetPoint	' Little endian
	COMMAND = 4 : GoSub DataVision
	COMMAND = 3 : GoSub DataVision
	serout MONITOR,BAUD,(">> UPDATED !!<< ")
	COMMAND = 5 : GoSub DataVision
	serout MONITOR,BAUD,("Reboot in 2 sec.")
	Pause 2000
	RESET
	
' REMEMBER TO REMARK THE NO_DATA COMPILER DIRECTIVE ON FIRST PROGRAMMING

 ' EEPROM locations 0 - 15 not used for temperature scaling
 ' EEPROM loc 254 and loc 255 are for calibration Lo:Hi bytes
  EEPROM  0, (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
  EEPROM 16, (254, 236, 220, 206, 194, 183, 173, 164)
  EEPROM 24, (157, 149, 143, 137, 131, 126, 122, 117)
  EEPROM 32, (113, 110, 106, 103, 100, 97, 94, 92)
  EEPROM 40, (89, 87, 85, 83, 81, 79, 77, 76)
  EEPROM 48, (74, 73, 71, 70, 69, 67, 66, 65)
  EEPROM 56, (64, 63, 62, 61, 60, 59, 58, 57)
  EEPROM 64, (57, 56, 55, 54, 54, 53, 52, 52)
  EEPROM 72, (51, 51, 50, 49, 49, 48, 48, 47)
  EEPROM 80, (47, 46, 46, 46, 45, 45, 44, 44)
  EEPROM 88, (44, 43, 43, 43, 42, 42, 42, 41)
  EEPROM 96, (41, 41, 41, 40, 40, 40, 40, 39)
  EEPROM 104, (39, 39, 39, 39, 38, 38, 38, 38)
  EEPROM 112, (38, 38, 37, 37, 37, 37, 37, 37)
  EEPROM 120, (37, 36, 36, 36, 36, 36, 36, 36)
  EEPROM 128, (36, 36, 36, 36, 36, 35, 35, 35)
  EEPROM 136, (35, 35, 35, 35, 35, 35, 35, 35)
  EEPROM 144, (35, 35, 35, 35, 35, 35, 35, 35)
  EEPROM 152, (35, 35, 35, 35, 35, 35, 35, 35)
  EEPROM 160, (36, 36, 36, 36, 36, 36, 36, 36)
  EEPROM 168, (36, 36, 36, 37, 37, 37, 37, 37)
  EEPROM 176, (37, 37, 38, 38, 38, 38, 38, 39)
  EEPROM 184, (39, 39, 39, 39, 40, 40, 40, 41)
  EEPROM 192, (41, 41, 42, 42, 42, 43, 43, 43)
  EEPROM 200, (44, 44, 45, 45, 46, 46, 47, 47)
  EEPROM 208, (48, 48, 49, 50, 50, 51, 52, 53)
  EEPROM 216, (53, 54, 55, 56, 57, 58, 59, 61)
  EEPROM 224, (62, 63, 65, 66, 68, 70, 72, 74)
  EEPROM 232, (76, 78, 81, 84, 87, 90, 94, 98)
  EEPROM 240, (102, 107, 113, 119, 126, 135, 144, 156)
  EEPROM 248, (170, 187, 208, 235,0, 0, 162, 40)