   // **********************************
   // **********************************
  
   // TRACK ONE:    SHAVE AND A HAIRCUT

   // TRACK TWO:    STAR WARS THEME
   
   // TRACK THREE:  STAR WARS CANTINA    (SOURCE JMBONDY: https://www.youtube.com/watch?v=Cx0dJEyfZAI)

   // TRACK FOUR:   BEAT IT
  
   // **********************************
   // **********************************

#include "pitches.h"    // Library that contains frequencies for each musical note


///////////// SONG CARD CALIBRATIONS:///////////////////////////////////

int track1UpperLimit = 1023;   // Set the upper and lower limits for each track's light sensor reading
// Card 1 Value:       1000
int track1LowerLimit = 1015;

int track2UpperLimit = 1015;
// Card 2 Value:       725
int track2LowerLimit = 700;

int track3UpperLimit = 700;
// Card 3 Value:       420
int track3LowerLimit = 400;

int track4UpperLimit = 400;
// Card 2 Value:       90
int track4LowerLimit = 1;

///////////////////////////////////////////////////////////////////////

int lightSensorPin = A0;    // The light sensor will be connected to pin a0
int speakerPin = 5;         // The speaker will be connected to pin d5

int lightSensorValue = 0;   // Create a variable to store the value from the light sensor


void setup()
{
  pinMode(lightSensorPin, INPUT);    // The light sensor pin will be an input
  pinMode(speakerPin, OUTPUT);       // The speaker pin will be an output
}


void loop()
{
  lightSensorValue = analogRead(lightSensorPin);      // Check the light sensor and store that value in lightSensorValue
  
  
  
  
   // *******************************
   // *******************************
   // TRACK ONE: SHAVE AND A HAIRCUT
   // *******************************
   // *******************************
  
  if (lightSensorValue >= track1LowerLimit && lightSensorValue <= track1UpperLimit)  // If the light sensor value is between the upper and lower limits
  {
 
    int melody[] = { 
                      NOTE_C4, NOTE_G3,NOTE_G3, NOTE_A3, NOTE_G3,0, NOTE_B3, NOTE_C4     //the notes of the sone (using pitches.h library)
                   };
    
    int noteDurations[] = {
                            4, 8, 8, 4,4,4,4,4     // note durations: 4 = quarter note, 8 = eighth note, etc.:
                          };
    
    for (int thisNote = 0; thisNote < sizeof(noteDurations)/2; thisNote++) 
    {
      int noteDuration = 1000/noteDurations[thisNote];   // to calculate the note duration, take one second divided by the note type. (e.g. quarter note = 1000 / 4, eighth note = 1000/8, etc.)
      tone(speakerPin, melody[thisNote],noteDuration);
      int pauseBetweenNotes = noteDuration * 1.30;       // to distinguish the notes, set a minimum time between them. The note's duration + 30% seems to work well:
      delay(pauseBetweenNotes);
      noTone(5); // stop the tone playing:
      if (analogRead(lightSensorPin) < track1LowerLimit || analogRead(lightSensorPin) > track1UpperLimit)  //If the light sensor is no longer in the correct range...
       {
        break;                                                                                             // Break out of the for loop and stop playing the song
       } 
      
    }
    delay(1000); // Pause Between Songs
  }
  
   // *****************************
   // *****************************
   // TRACK TWO: STAR WARS THEME
   // *****************************
   // *****************************
  
  else if (lightSensorValue >= track2LowerLimit && lightSensorValue <= track2UpperLimit)
  {
    
    int melody[]  = { 
                      NOTE_D4, NOTE_D4, NOTE_D4,
                      NOTE_G4, NOTE_D5,
                      NOTE_C5, NOTE_B4, NOTE_A4, NOTE_G5, NOTE_D5,
                      NOTE_C5, NOTE_B4, NOTE_A4, NOTE_G5, NOTE_D5,
                      NOTE_C5, NOTE_B4, NOTE_C5, NOTE_A4
                    };
    
    int noteDurations[] = {  
                             8, 8, 8,
                             2, 2,
                             8, 8, 8, 2, 4,
                             8, 8, 8, 2, 4, 
                             8, 8, 8, 2
                          };
                                 
    for (int thisNote = 0; thisNote < sizeof(noteDurations)/2; thisNote++) //Play each note of the song, one by one.
    {
      int noteDuration = 1000/noteDurations[thisNote];   // to calculate the note duration, take one second divided by the note type. (e.g. quarter note = 1000 / 4, eighth note = 1000/8, etc.)
      tone(speakerPin, melody[thisNote],noteDuration);
      int pauseBetweenNotes = noteDuration * 1.30;       // to distinguish the notes, set a minimum time between them. The note's duration + 30% seems to work well:
      delay(pauseBetweenNotes);
      noTone(5); // stop the tone playing:
      if (analogRead(lightSensorPin) < track2LowerLimit || analogRead(lightSensorPin) >= track2UpperLimit) //If the light sensor is no longer in the correct range...
       {
        break;                                              // Break out of the for loop and stop playing the song
       } 
    }
    delay(1000); // Pause Between Songs
  }
  
    
  
   // *****************************
   // *****************************
   // TRACK THREE: BEAT IT
   // *****************************
   // *****************************
  
   else if (lightSensorValue >= track3LowerLimit && lightSensorValue <= track3UpperLimit)
  {
 
    const int melody[] = { 
                            NOTE_B4,  NOTE_B4,  NOTE_B4,  NOTE_A4,  NOTE_B4,  NOTE_A4,  NOTE_B4,
                            NOTE_D5,  NOTE_B4,  NOTE_A4,  NOTE_B4,  NOTE_B4,
                            NOTE_B4,  NOTE_B4,  NOTE_B4,  NOTE_B4,  NOTE_B4,  NOTE_B4,  NOTE_A4,  NOTE_G4,
                            NOTE_A4,  NOTE_G4,  NOTE_B4,  0      ,  NOTE_B4,
                            NOTE_A4,  NOTE_G4,  NOTE_E4,  NOTE_D4,  NOTE_E4,  NOTE_E4,  NOTE_E4,          // LINE 5
                            NOTE_FS4, NOTE_E4,  NOTE_D4,  NOTE_B3,  NOTE_D4,  NOTE_E4,
                            NOTE_G4,  NOTE_E4,  0      ,  0      ,  NOTE_E4,
                            NOTE_FS4, NOTE_D4,  0      ,  0      ,  
                         };
    
    const int noteDurations[] = {
                                    4, 8, 8, 8, 8, 8, 8,          // LINE 1
                                    8, 8, 4, 3, 8,
                                    8, 8, 8, 8, 8, 8, 8, 8,
                                    8, 8, 4, 4, 4,
                                    8, 8, 8, 8, 4, 8, 8,          // LINE 5
                                    8, 8, 8, 8, 4, 4,    
                                    8, 8, 4, 4, 4,
                                    8, 8, 4, 2,
                                };
    
    for (int thisNote = 0; thisNote < sizeof(noteDurations)/2; thisNote++) 
    {
      int noteDuration = 1500/noteDurations[thisNote];   // to calculate the note duration, take one second divided by the note type. (e.g. quarter note = 1000 / 4, eighth note = 1000/8, etc.)
      tone(speakerPin, melody[thisNote],noteDuration);
      int pauseBetweenNotes = noteDuration * 1.30;       // to distinguish the notes, set a minimum time between them. The note's duration + 30% seems to work well:
      delay(pauseBetweenNotes);
      noTone(5); // stop the tone playing:
      if (analogRead(lightSensorPin) < track3LowerLimit || analogRead(lightSensorPin) >= track3UpperLimit) //If the light sensor is no longer in the correct range...
       {
        break;                                              // Break out of the for loop and stop playing the song
       } 
    }
    delay(1000); // Pause Between Songs
  }
  
  
   // *******************************
   // *******************************
   // TRACK FOUR: STAR WARS CANTINA
   // *******************************
   // *******************************
  
   else if (lightSensorValue >= track4LowerLimit && lightSensorValue <= track4UpperLimit)
  {
    
    int melody[] = {
                       NOTE_A4,        0,   NOTE_D5,         0, 
                       NOTE_A4,        0,   NOTE_D5,         0,
                       NOTE_A4,  NOTE_D5,         0,   NOTE_A4, 
                             0,        0,  NOTE_GS4,   NOTE_A4, 
                             0,  NOTE_A4,  NOTE_GS4,   NOTE_A4, 
                       NOTE_G4,        0,  NOTE_FS4,   NOTE_G4, 
                      NOTE_FS4,  NOTE_F4,   NOTE_D4,   NOTE_A4,
                   };
                    
                    
    int noteDurations[] = {  
                               4, 64,  4, 64, 
                               4, 64,  4, 64, 
                               8,  4, 64,  8, 
                              64,  8,  8,  4, 
                              64,  8,  8,  8, 
                               8,  8,  8,  8, 
                               8,  3,  2
                          };
                                 
    for (int thisNote = 0; thisNote < sizeof(noteDurations)/2; thisNote++) //Play each note of the song, one by one.
    {
      int noteDuration = 1000/noteDurations[thisNote];   // to calculate the note duration, take one second divided by the note type. (e.g. quarter note = 1000 / 4, eighth note = 1000/8, etc.)
      tone(speakerPin, melody[thisNote],noteDuration);
      int pauseBetweenNotes = noteDuration * 1.30;       // to distinguish the notes, set a minimum time between them. The note's duration + 30% seems to work well:
      delay(pauseBetweenNotes);
      noTone(5); // stop the tone playing:
      if (analogRead(lightSensorPin) < track4LowerLimit || analogRead(lightSensorPin) >= track4UpperLimit) //If the light sensor is no longer in the correct range...
       {
        break;                                              // Break out of the for loop and stop playing the song
       } 
    }
    delay(1000);  // Pause Between Songs
  }

  
   else
     {
      delay(100);      // If the light sensor doesn't pick up any light, wait for 100 miliseconds, then go back to the start of the loop and check again.
     }
}







