package com.example.rte1cob.blecontroller;

import android.app.Activity;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.support.v7.app.ActionBarActivity;
import android.os.Bundle;
import android.text.Editable;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.SeekBar;
import android.widget.TextView;


public class activity_ble_edit extends ActionBarActivity {


    public static String BLE_DEVICE_NAME = "BLEDEVICENAME";
    public static String BLE_DEVICE_ADDRESS = "BLEDEVICEADDRESS";
    public static String BLE_DEVICE_NEW_SHORT_NAME = "BLEDEVICENEWSHORTNAME";
    public static String BLE_DEVICE_NEW_RANGE = "BLEDEVICENEWRANGE";

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        // save data
        final EditText txtedit_BLEEdit_ShortName = (EditText)findViewById(R.id.txtedit_bleEdit_ShortName);
        final SeekBar sckbr_BLEEdit_Range= (SeekBar)findViewById(R.id.sldr_bleEdit_Range);
        TextView txt_BLEEdit_Name = (TextView)findViewById(R.id.txt_bleEdit_Name);
        TextView txt_BLEEdit_Address = (TextView)findViewById(R.id.txt_bleEdit_Address);
        outState.putString(BLE_DEVICE_NEW_SHORT_NAME, txtedit_BLEEdit_ShortName.getText().toString());//your data
        outState.putInt(BLE_DEVICE_NEW_RANGE, sckbr_BLEEdit_Range.getProgress());//your data
        outState.putString(BLE_DEVICE_NAME, txt_BLEEdit_Name.getText().toString());//your data
        outState.putString(BLE_DEVICE_ADDRESS, txt_BLEEdit_Address.getText().toString());//your data
        super.onSaveInstanceState(outState);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_activity_ble_edit);

       final Intent intent = getIntent();
        TextView txt_BLEEdit_Name = (TextView)findViewById(R.id.txt_bleEdit_Name);
        TextView txt_BLEEdit_Address = (TextView)findViewById(R.id.txt_bleEdit_Address);
        String BLE_Name = intent.getStringExtra(BLEContrller.BLE_DEVICE_NAME);
        String BLE_Address = intent.getStringExtra(BLEContrller.BLE_DEVICE_ADDRESS);
        String BLE_ShortName = intent.getStringExtra(BLEContrller.BLE_DEVICE_SHORT_NAME);
        int BLE_Range = intent.getIntExtra(BLEContrller.BLE_DEVICE_RANGE, 0);
       final EditText txtedit_BLEEdit_ShortName = (EditText)findViewById(R.id.txtedit_bleEdit_ShortName);
        final SeekBar sckbr_BLEEdit_Range= (SeekBar)findViewById(R.id.sldr_bleEdit_Range);
        txt_BLEEdit_Name.setText(BLE_Name);
        txtedit_BLEEdit_ShortName.setText(BLE_ShortName);
        txt_BLEEdit_Address.setText(BLE_Address);
        sckbr_BLEEdit_Range.setProgress(BLE_Range);

        final Button btnOK = (Button)(findViewById(R.id.btn_bleEdit_Ok));
        btnOK.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
                Editable shortName = txtedit_BLEEdit_ShortName.getText();
               intent.putExtra(BLE_DEVICE_NEW_SHORT_NAME,shortName.toString() );
                intent.putExtra(BLE_DEVICE_NEW_RANGE, sckbr_BLEEdit_Range.getProgress());
                setResult(Activity.RESULT_OK, intent);
                finish();
            }
        });


        if(savedInstanceState != null) {
            txt_BLEEdit_Name.setText(savedInstanceState.getString(BLE_DEVICE_NAME));
            txt_BLEEdit_Address.setText(savedInstanceState.getString(BLE_DEVICE_ADDRESS));
            txtedit_BLEEdit_ShortName.setText(savedInstanceState.getString(BLE_DEVICE_NEW_SHORT_NAME));
            sckbr_BLEEdit_Range.setProgress(savedInstanceState.getInt(BLE_DEVICE_NEW_RANGE));
        }

    }


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
       // getMenuInflater().inflate(R.menu.menu_activity_ble_edit, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_settings) {
            return true;
        }

        return super.onOptionsItemSelected(item);
    }
}
