package com.example.rte1cob.blecontroller;

import android.app.ActionBar;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothProfile;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.StrictMode;
import android.support.v7.app.ActionBarActivity;
import android.os.Bundle;
import android.view.DragEvent;
import android.view.Gravity;
import android.view.Menu;
import android.view.MenuItem;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.bluetooth.BluetoothDevice;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.ScaleAnimation;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.Switch;
import android.widget.Toast;

import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONException;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;




public class BLEContrller extends ActionBarActivity implements View.OnClickListener, View.OnDragListener {


    enum  ScanState{SCAN_START, SCAN_STOP};
    ScanState scanState = ScanState.SCAN_START;
    BluetoothAdapter btAdapter = null;
    int REQUEST_ENABLE_BT = 1;
    public static ListAdapter lstBLEadapter;
   public static List<BLEListDataHolder> dataHolderList;

    public static String BLE_DEVICE_NAME = "BLEDEVICENAME";
    public static String BLE_DEVICE_ADDRESS = "BLEDEVICEADDRESS";
    public static String BLE_DEVICE_SHORT_NAME = "BLEDEVICESHORTNAME";
    public static String BLE_DEVICE_RANGE = "BLEDEVICERANGE";
    public int BLE_DEVICE_EDIT_REQUEST_CODE = 2;
    Thread thread;
    public boolean RunRssiThread = true;
    public boolean RssiThreadStopped = false;
    MediaPlayer mp;

    public static String BTN_SCAN_STATE= "BTNSCANSTATE";
    public static String LIST_SCAN_DATA= "LISTSCANDATA";

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        // save data
        outState.putSerializable(BTN_SCAN_STATE, scanState);//your data
        super.onSaveInstanceState(outState);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permitAll().build();
        StrictMode.setThreadPolicy(policy);


        setContentView(R.layout.activity_blecontrller);

        mp =new  MediaPlayer();
        mp.setAudioStreamType(AudioManager.STREAM_MUSIC);
        try {
            AssetFileDescriptor descriptor = getAssets().openFd("alert.mp3");
            mp.setDataSource(descriptor.getFileDescriptor());
            mp.prepare();
        }
        catch (Exception e) {

        }

        BluetoothManager btManager = (BluetoothManager)getSystemService(Context.BLUETOOTH_SERVICE);

        //get bluetooth adaptor and turn on bluetooth
        btAdapter = btManager.getAdapter();
        if (btAdapter != null && !btAdapter.isEnabled()) {
            Intent enableIntent = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
            startActivityForResult(enableIntent, REQUEST_ENABLE_BT);
        }

        //Scan button and listener
       final Button btnScan = (Button)(findViewById(R.id.btnScan));
        btnScan.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {

                postData();
                if(scanState == ScanState.SCAN_START) {
                    StopScan(btnScan);
                }
                else
                if(scanState == ScanState.SCAN_STOP) {
                    StartScan(btnScan);
                }
            }
        });

        if(savedInstanceState != null) {
            scanState =  (ScanState)savedInstanceState.getSerializable(BTN_SCAN_STATE);
            if (scanState == ScanState.SCAN_START) {
                StartScan(btnScan);
            } else if (scanState == ScanState.SCAN_STOP) {
                StopScan(btnScan);
            }
        }

        final ListView listBle = (ListView) findViewById(R.id.lstLeDevices);
        //Create an adaptor for list view and handle list view select event
        if(savedInstanceState == null) {
            dataHolderList = new ArrayList<BLEListDataHolder>();
            lstBLEadapter = new ListAdapter(dataHolderList, this, this, this);
        }
        listBle.setAdapter(lstBLEadapter);


    }



    private  void  StopScan(Button btnScan)
    {
        btnScan.setText("Stop Scan");
        scanState = ScanState.SCAN_STOP;
        btAdapter.startLeScan(leScanCallback);
        int imageResource = R.drawable.btn_scan_press;
        Drawable image = getResources().getDrawable(imageResource);
        btnScan.setBackground(image);

        final ImageView imgScan = (ImageView)findViewById(R.id.imgScanCircle);

        ImageView imgview = (ImageView)findViewById(R.id.imageView);
       imgview.setVisibility(View.INVISIBLE);

        AlphaAnimation alpha = new AlphaAnimation(1.0f, 0.0f);
        ScaleAnimation scaleAnm =new ScaleAnimation(0, 1,0, 1, Animation.RELATIVE_TO_SELF, 0.5f, Animation.RELATIVE_TO_SELF, 0.5f);


        scaleAnm.setDuration(1000);
        alpha.setDuration(1000);

        scaleAnm.setRepeatCount(Animation.INFINITE);
        alpha.setRepeatCount(Animation.INFINITE);

      final  AnimationSet set = new AnimationSet(true);


        set.setInterpolator(new AccelerateDecelerateInterpolator());

        set.addAnimation(alpha);
        set.addAnimation(scaleAnm);

        imgScan.startAnimation(set);
        imgScan.setVisibility(View.VISIBLE);

    }

    private  void  StartScan(Button btnScan)
    {

        ImageView imgScan = (ImageView)findViewById(R.id.imgScanCircle);
        imgScan.setVisibility(View.INVISIBLE);
        imgScan.clearAnimation();
        btnScan.setText("Start Scan");
        scanState = ScanState.SCAN_START;
        btAdapter.stopLeScan(leScanCallback);
        int imageResource = R.drawable.btn_scan;
        Drawable image = getResources().getDrawable(imageResource);
        btnScan.setBackground(image);

        ImageView imgview = (ImageView)findViewById(R.id.imageView);
        imgview.setVisibility(View.VISIBLE);


    }

    int i=0;


    @Override
    public boolean onDrag( View view, DragEvent d) {

       // onClick(view);
        return true;
    }


    @Override
    public void onClick ( View view ) {
        // view is the row view returned by getView
        // The position is stored as tag, so it can be retrieved using getTag ()
        CharSequence text = "";

            if(view instanceof Switch)
            {
                if(((Switch)view).isChecked())
                {
                    RunRssiThread = false;
                   // text = "Item clicked : " + lstBLEadapter.getItem((int)view.getTag()).device.getName() + " :" + "ON";
                    ((BLEListDataHolder)lstBLEadapter.getItem((int)view.getTag())).IsSelected = true;
                    ((BLEListDataHolder)lstBLEadapter.getItem((int)view.getTag())).bluetoothGatt = ((BLEListDataHolder)lstBLEadapter.getItem((int)view.getTag())).device.connectGatt(this, false, btleGattCallback);
                    RunRssiThread = true;
                     thread = new Thread() {
                        @Override
                        public void run() {
                            try {
                                RssiThreadStopped = false;
                                while(RunRssiThread) {
                                    sleep(1000);
                                    boolean IsExceededRange = false;
                                    for(int i=0; i<lstBLEadapter.getCount(); i++)
                                    {
                                        BLEListDataHolder holder = (BLEListDataHolder)lstBLEadapter.getItem(i);
                                        if(holder != null && holder.IsSelected == true) {
                                            holder.bluetoothGatt.readRemoteRssi();
                                            int asRssi = Math.abs(holder.rssi);
                                            if(holder.Range != -1) {
                                                if (asRssi > holder.Range) {
                                                    IsExceededRange = true;
                                               }
                                            }
                                            if(holder.blueCharacteristic != null) {

                                                ByteBuffer b = ByteBuffer.allocate(4);
                                                b.putInt(asRssi);
                                                byte[] result = b.array();
                                                holder.blueCharacteristic.setValue(result);
                                                holder.bluetoothGatt.writeCharacteristic(holder.blueCharacteristic);
                                            }
                                        }
                                    }
                                    if(IsExceededRange) {
                                        try{

                                            mp.reset();
                                            AssetFileDescriptor descriptor = getAssets().openFd("alert.mp3");
                                            mp.setDataSource(descriptor.getFileDescriptor());
                                            mp.prepare();

                                            mp.start();
                                        }
                                        catch (Exception e) {

                                        }
                                    }
                                    RssiThreadStopped = true;
                                }
                            } catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    };

                    thread.start();

                }
            else {
                   //text = "Item clicked : " + lstBLEadapter.getItem((int)view.getTag()).device.getName() + " :" + "OFF";
                    ((BLEListDataHolder)lstBLEadapter.getItem((int)view.getTag())).IsSelected = false;
                    ((BLEListDataHolder)lstBLEadapter.getItem((int)view.getTag())).bluetoothGatt = null;
                }
             }
            else
            {
           // text = "Item clicked : " + lstBLEadapter.getItem((int)view.getTag()).device.getName();
                Intent intent = new Intent(this, activity_ble_edit.class);
                intent.putExtra(BLE_DEVICE_NAME,  ((BLEListDataHolder)lstBLEadapter.getItem((int)view.getTag())).device.getName());
                intent.putExtra(BLE_DEVICE_ADDRESS,  ((BLEListDataHolder)lstBLEadapter.getItem((int)view.getTag())).device.getAddress());
                intent.putExtra(BLE_DEVICE_SHORT_NAME,  ((BLEListDataHolder)lstBLEadapter.getItem((int)view.getTag())).CustomName);
                intent.putExtra(BLE_DEVICE_RANGE,  ((BLEListDataHolder)lstBLEadapter.getItem((int)view.getTag())).Range);

                startActivityForResult(intent, BLE_DEVICE_EDIT_REQUEST_CODE);
            }
      /*  int duration = Toast.LENGTH_SHORT;
        Toast toast = Toast.makeText(this, text, duration);
        toast.setGravity(Gravity.CENTER_HORIZONTAL | Gravity.CENTER_VERTICAL,
                duration, duration);
        toast.show();*/
    }

    private BluetoothAdapter.LeScanCallback leScanCallback = new BluetoothAdapter.LeScanCallback() {
        @Override
        public void onLeScan(final BluetoothDevice device, final int rssi, final byte[] scanRecord) {

            if(lstBLEadapter.FindItemByAddress(device.getAddress()) == false) {
                BLEListDataHolder BLEData = new BLEListDataHolder();
                BLEData.device = device;
                BLEData.IsSelected = false;
                BLEData.rssi = rssi;
                dataHolderList.add(BLEData);
                lstBLEadapter.notifyDataSetChanged();
            }
        }
    };

@Override
protected void onActivityResult(int requestCode, final int resultCode, final Intent data) {
    // Check which request we're responding to
    if (requestCode == BLE_DEVICE_EDIT_REQUEST_CODE) {
        // Make sure the request was successful

            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (resultCode == RESULT_OK) {
                        BLEListDataHolder dataHolder = lstBLEadapter.getItemByAddress(data.getStringExtra(BLE_DEVICE_ADDRESS));
                        dataHolder.CustomName = data.getStringExtra(activity_ble_edit.BLE_DEVICE_NEW_SHORT_NAME);
                        dataHolder.Range = data.getIntExtra(activity_ble_edit.BLE_DEVICE_NEW_RANGE, -1);

                        lstBLEadapter.notifyDataSetChanged();
                    }
                }
            });

    }
}


    private final BluetoothGattCallback btleGattCallback = new BluetoothGattCallback() {

        @Override
        public void onCharacteristicChanged(BluetoothGatt gatt, final BluetoothGattCharacteristic characteristic) {
            // this will get called anytime you perform a read or write characteristic operation


        }

        @Override
        public void onReadRemoteRssi (final BluetoothGatt gatt, final int rssi, int status)
        {
            if(status == BluetoothGatt.GATT_SUCCESS) {


                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        BLEListDataHolder dataHolder =  lstBLEadapter.getItemByAddress(gatt.getDevice().getAddress());
                        if(dataHolder.rssi !=rssi) {
                            dataHolder.rssi = rssi;

                            lstBLEadapter.notifyDataSetChanged();
                        }
                    }
                });

            }

        }

        @Override
        public void onConnectionStateChange(final BluetoothGatt gatt, final int status, final int newState) {
            // this will get called when a device connects or disconnects
            if (newState == BluetoothProfile.STATE_CONNECTED) {
                gatt.discoverServices();
            }
        }

        @Override
        public void onServicesDiscovered(final BluetoothGatt gatt, final int status) {
            // this will get called after the client initiates a            BluetoothGatt.discoverServices() call
            List<BluetoothGattService> services = gatt.getServices();
            for (BluetoothGattService service : services) {

                if(String.copyValueOf(service.getUuid().toString().toCharArray(),4,4).equals("fff0")){
                List<BluetoothGattCharacteristic> characteristics = service.getCharacteristics();
                    for (BluetoothGattCharacteristic characteristic : characteristics) {
                        if(String.copyValueOf(characteristic.getUuid().toString().toCharArray(),4,4).equals("fff1")) {
                            BLEListDataHolder dataHolder =  lstBLEadapter.getItemByAddress(gatt.getDevice().getAddress());
                            dataHolder.blueCharacteristic = characteristic;
                            break;
                        }
                    }
                    break;
                    }
                }
               /* BLEListDataHolder dataHolder =  lstBLEadapter.getItemByAddress(gatt.getDevice().getAddress());
                dataHolder.blueCharacteristic  =characteristics.get(0);
*/
            }



    };

    public void postData() {
        // Create a new HttpClient and Post Header

        HttpClient httpclient = new DefaultHttpClient();
        HttpPost httppost = new HttpPost("http://api.thingspeak.com/update");

        try {
            // Add your data
            List<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>(2);
            nameValuePairs.add(new BasicNameValuePair("key", "3DNYGC5M2WJR2JOL"));
            nameValuePairs.add(new BasicNameValuePair("field1", "56.78.98.76"));
            nameValuePairs.add(new BasicNameValuePair("field2", "-78db"));
            httppost.setEntity(new UrlEncodedFormEntity(nameValuePairs));

            // Execute HTTP Post Request
            HttpResponse response = httpclient.execute(httppost);

        } catch (ClientProtocolException e) {
            // TODO Auto-generated catch block
        } catch (IOException e) {
            // TODO Auto-generated catch block
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
       // getMenuInflater().inflate(R.menu.menu_blecontrller, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_settings) {
            return true;
        }

        return super.onOptionsItemSelected(item);
    }
}
