#include "WProgram.h"
void msg1();
void pong();
byte doubleToByte(double num);
void getInput();
void cls();
void display(int delay_ms);
void numSet(int num,int x);
void one(int x);
void two(int x);
void three(int x);
void four(int x);
void five(int x);
void six(int x);
void seven(int x);
void eight(int x);
void nine(int x);
void zero(int x);
void a(int x);
void b(int x);
void c(int x);
void d(int x);
void e(int x);
void f(int x);
void g(int x);
void h(int x);
void i(int x);
void j(int x);
void k(int x);
void l(int x);
void m(int x);
void n(int x);
void o(int x);
void p(int x);
void q(int x);
void r(int x);
void s(int x);
void t(int x);
void u(int x);
void v(int x);
void w(int x);
void x(int x);
void y(int x);
void z(int x);
/* pong using 7x5 led matrix
 * --------------
 * by: Jonathan Hodgins
 * copyleft 2008
 */

//game variables 
byte p1X=0,p2X=6;
double p1Y,p2Y;
double ballX=3, ballY=2,startBallY=2;//the x position of the ball
double ballVX=0.5, ballVY = 0.5, startBallVY=0.5;
bool numPlayers=1;
byte score1,score2;
const int paddleTime=250;//the length the paddle is up after a button push
bool leftPaddle=false;//used to turn the paddle on and off
bool rightPaddle=false;
long tempClock;//used to store when the paddles were first shown, to calculate when to turn them off
long moveDelay=500, startingMoveDelay=500;
double p2Speed=0.75;

//display variables(not mutual with pong)
int displayTime=650;

//output variables
int pinx[7]={
  5,6,7,8,10,11,12};
int piny[5]={
  0,1,2,3,4};
const byte maxX=6,maxY=4;
bool ledState[maxX+1][maxY+1];
int timer = 100;
long clock;

//input variables
int pushedValue = 512;
bool sw1=false,sw2=false,sw3=false;
bool oldSw1=false,oldSw2=false,oldSw3=false;
byte sw1Pin=5,sw2Pin=4,sw3Pin=3;
byte pot1=0,pot2=0, potPin1=2, potPin2=1;

//sound variables
byte speakerPin=9;
byte p1Hit=260, p2Hit=290, wallHit=330;//these number are the frequency in Hz
byte current=0;

void setup(){
  for (int i=0;i<=maxX;i++)
    pinMode(pinx[i], OUTPUT);
  for (int i=0;i<=maxY;i++)
    pinMode(piny[i], OUTPUT);
  pinMode(speakerPin, OUTPUT);
  tempClock=millis();
}


void loop()
{
  getInput();

  if(sw1==false)
  {
    cls();
    msg1();
  }
  else
  {
    cls();
    pong();
  }

  if(sw3)
    display(50);
  else
    display(100);

}

void msg1()
{
  current=0;//reset the sound
  if(sw1!=oldSw1)//signals it just started
  {
    tempClock=millis();
  }
  if(sw2)
    if(millis()-tempClock<=displayTime*2)
    {
      u(0);
      o(4);
    }
    else if(millis()-tempClock>=displayTime*2 && millis()-tempClock<=displayTime*4)
    {
      i(0);
      t(4);
    }
    else if(millis()-tempClock>=displayTime*5)
    {
      tempClock=millis();
    }
    else
    {
    }
  else
    if(millis()-tempClock<=displayTime*2)
    {
      e(0);
      r(4);
    }
    else if(millis()-tempClock>=displayTime*2 && millis()-tempClock<=displayTime*4)
    {
      t(0);
      w(4);
    }
    else if(millis()-tempClock>=displayTime*5)
    {
      tempClock=millis();
    }
}

void pong()
{
  if(sw1!=oldSw1)//signals it just started
  {
    score1=0;
    score2=0;
    ballX=1;
    ballVX=abs(ballVX);
    ballVY=startBallVY;
    moveDelay=startingMoveDelay;
    tempClock=millis();
    if(sw2==true)//change the number of players
      numPlayers=0;//actually 1 player
    else
      numPlayers=1;//actually 2 players
  }
  if(sw2!=oldSw2)//signals it just switched number of players
  {
    cls();
    current=0;//reset the sound
    if(sw2==true)//change the number of players
    {
      one(0);
      p(4);
      numPlayers=0;//actually 1 player
    }
    else
    {
      two(0);
      p(4);
      numPlayers=1;//actually 2 players
    }
    score1=0;
    score2=0;
    display(900);
  }
  else
  {
    cls();
    current=0;//reset the sound
    p1Y=3-(analogRead(potPin1)/256);
    if(numPlayers==1)
      p2Y=3-(analogRead(potPin2)/256);

    if(millis()-tempClock>=moveDelay)//move
    {
      if(numPlayers==0)//controls the computer player
      {
        if(ballY>doubleToByte(p2Y+1))
          p2Y+=p2Speed;
        if(ballY<doubleToByte(p2Y))
          p2Y-=p2Speed;
      }

      if(doubleToByte(ballX+0.5)==p1X+1 && (doubleToByte(ballY)==p1Y||doubleToByte(ballY)==p1Y+1))// bounce the ball
      {
        current=p1Hit;
        if(doubleToByte(ballY)==p1Y)
          ballVY-=0.2;
        else if(doubleToByte(ballY)==p1Y+1)
          ballVY+=0.2;

        ballVX=abs(ballVX);
        if (moveDelay>10)
          moveDelay-=10;
      }
      if(doubleToByte(ballX-0.5)==p2X-1 && (doubleToByte(ballY)==p2Y||doubleToByte(ballY)==p2Y+1))// bounce the ball
      {
        current=p2Hit;
        if(doubleToByte(ballY)==p2Y)
          ballVY-=0.2;
        else if(doubleToByte(ballY)==p2Y+1)// bounce the ball
          ballVY+=0.2;

        ballVX=-abs(ballVX);
        if (moveDelay>10)
          moveDelay-=10;
      }

      ballX+=ballVX;
      ballY+=ballVY;

      if(ballY<0||ballY-0.5>maxY)
      {
        current=wallHit;
        ballVY=-ballVY;
        ballY+=ballVY;
      }

      if(ballX<1 || ballX>=maxX)//if someone scored
      {
        cls();
        current=0;//reset the sound
        if(ballX>=maxX)//if it was player 1
        {
          score1++;
          ballX=1;
          ballVX=abs(ballVX);
          ballVY=startBallVY;
          ballY=startBallY;
          moveDelay=startingMoveDelay;
        }
        else if(ballX<1)//or player 2
        {
          score2++;
          ballX=5;
          ballVX=-abs(ballVX);
          ballVY=startBallVY;
          moveDelay=startingMoveDelay;
        }
        cls();//display the current score
        numSet(score1,0);
        numSet(score2,4);
        display(2000);
        if(score1>=9 || score2>=9)// if someone won
        {
          cls();
          p(0);
          if(score1>=9)
            one(4-2);
          if(score2>=9)
            two(4);
          display(2000);
          cls();
          w(0);
          ledState[3][1]=HIGH;
          ledState[3][2]=HIGH;
          ledState[3][3]=HIGH;
          ledState[3][4]=HIGH;
          n(4);
          display(3000);
          cls();
          score1=0;
          score2=0;
        }
        cls();
        display(600);
      }

      if(moveDelay>=8)
        moveDelay-=8;

    }

    //generate the output
    ledState[p1X][doubleToByte(p1Y)]=HIGH;
    ledState[p1X][doubleToByte(p1Y+1)]=HIGH;

    ledState[p2X][doubleToByte(p2Y)]=HIGH;
    ledState[p2X][doubleToByte(p2Y+1)]=HIGH;

    ledState[doubleToByte(ballX)][doubleToByte(ballY)]=HIGH;//display the ball
  }
}

byte doubleToByte(double num)
{
  return num;
}

void getInput()
{
  oldSw1=sw1;
  oldSw2=sw2;
  oldSw3=sw3;
  if (analogRead(sw1Pin)>pushedValue)
    sw1=HIGH;
  else
    sw1=LOW;
  if (analogRead(sw2Pin)>pushedValue)
    sw2=HIGH;
  else
    sw2=LOW;
  if (analogRead(sw3Pin)>pushedValue)
    sw3=HIGH;
  else
    sw3=LOW;

  pot1=analogRead(potPin1);
  pot2=analogRead(potPin2);
}

void cls()
{
  for (int i=0;i<=maxX;i++)
    for (int j=0;j<=maxY;j++)
      ledState[i][j]=LOW; 
}

void display(int delay_ms)
{
  clock = millis();
  while (millis()-clock < delay_ms)
  {
    for (int y=0;y<5;y++)
    {
      for (int x=0;x<7;x++)
        digitalWrite(pinx[x], ledState[x][y]);
      digitalWrite(piny[y],LOW);
      delayMicroseconds(200);
      //generate the sound
      if(current>0)
        if(millis()%(1000/current)<=1)
          digitalWrite(speakerPin,HIGH);
        else
          digitalWrite(speakerPin,LOW);
      digitalWrite(piny[y],HIGH);
    }
  }
  digitalWrite(speakerPin,LOW);
  current=0;
}

// an easier way to set the numbers on the clock
//@num the number to display
//@ x the location to display num
void numSet(int num,int x)
{
  if(num==0)
    zero(x);
  else if(num==1)
    one(x);
  else if(num==2)
    two(x);
  else if(num==3)
    three(x);
  else if(num==4)
    four(x);
  else if(num==5)
    five(x);
  else if(num==6)
    six(x);
  else if(num==7)
    seven(x);
  else if(num==8)
    eight(x);
  else if(num==9)
    nine(x);
  else
    ledState[2][x+1]=HIGH;
}

//from here on it is just cose to draw numbers and letters at any given x location
void one(int x)
{
  ledState[x+2][0]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x+2][4]=HIGH;
}
void two(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void three(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void four(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x+2][4]=HIGH;
}
void five(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void six(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void seven(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x+2][4]=HIGH;
}
void eight(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void nine(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x+2][4]=HIGH;
}
void zero(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void a(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void b(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void c(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void d(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
}
void e(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void f(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x][4]=HIGH;
}
void g(int x)
{
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x+1][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void h(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void i(int x)
{
  ledState[x+1][0]=HIGH;
  ledState[x+1][1]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+1][3]=HIGH;
  ledState[x+1][4]=HIGH;
}
void j(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x+1][1]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+1][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
}
void k(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void l(int x)
{
  ledState[x][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
}
void m(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+1][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void n(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+1][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void o(int x)
{
  ledState[x+1][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x+1][4]=HIGH;
}
void p(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x][4]=HIGH;
}
void q(int x)
{
  ledState[x+1][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x+1][3]=HIGH;
  ledState[x+2][4]=HIGH;
}
void r(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void s(int x)
{
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
}
void t(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x+1][1]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+1][3]=HIGH;
  ledState[x+1][4]=HIGH;
}
void u(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void v(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x+1][3]=HIGH;
  ledState[x+1][4]=HIGH;
}
void w(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+1][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x+1][4]=HIGH;
}
void x(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void y(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+1][3]=HIGH;
  ledState[x+1][4]=HIGH;
}
void z(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
  ledState[x+2][4]=HIGH;
}

int main(void)
{
	init();

	setup();
    
	for (;;)
		loop();
        
	return 0;
}

