/* Developed in Fablab Dhahran - Mado
 * www.fablabdhahran.org
 * 
 * Special thanks to PrinceTronics for their SuperMarioBros Theme melody
 * http://www.princetronics.com/supermariothemesong/
 */

#include "pitches.h"
#define melodyPin 3

int Do = 4;
int Re = 5;
int Mi = 6;
int Fa = 7;
int Sol = 8;
int La = 9;
int Si = 10;
int Marioo = 11;


int LED_SYNC = 13;

const int Delay = 120;

int Speaker = 3;

int melody1[] = {NOTE_C4, NOTE_D4,NOTE_E4, 
NOTE_F4, NOTE_G4, NOTE_A4, NOTE_B4, NOTE_C5};

int melody[] = {
  NOTE_E7, NOTE_E7, 0, NOTE_E7,
  0, NOTE_C7, NOTE_E7, 0,
  NOTE_G7, 0, 0,  0,
  NOTE_G6, 0, 0, 0,
 
  NOTE_C7, 0, 0, NOTE_G6,
  0, 0, NOTE_E6, 0,
  0, NOTE_A6, 0, NOTE_B6,
  0, NOTE_AS6, NOTE_A6, 0,
 
  NOTE_G6, NOTE_E7, NOTE_G7,
  NOTE_A7, 0, NOTE_F7, NOTE_G7,
  0, NOTE_E7, 0, NOTE_C7,
  NOTE_D7, NOTE_B6, 0, 0,
 
  NOTE_C7, 0, 0, NOTE_G6,
  0, 0, NOTE_E6, 0,
  0, NOTE_A6, 0, NOTE_B6,
  0, NOTE_AS6, NOTE_A6, 0,
 
  NOTE_G6, NOTE_E7, NOTE_G7,
  NOTE_A7, 0, NOTE_F7, NOTE_G7,
  0, NOTE_E7, 0, NOTE_C7,
  NOTE_D7, NOTE_B6, 0, 0
};
//Mario main them tempo
int tempo[] = {
  12, 12, 12, 12,
  12, 12, 12, 12,
  12, 12, 12, 12,
  12, 12, 12, 12,
 
  12, 12, 12, 12,
  12, 12, 12, 12,
  12, 12, 12, 12,
  12, 12, 12, 12,
 
  9, 9, 9,
  12, 12, 12, 12,
  12, 12, 12, 12,
  12, 12, 12, 12,
 
  12, 12, 12, 12,
  12, 12, 12, 12,
  12, 12, 12, 12,
  12, 12, 12, 12,
 
  9, 9, 9,
  12, 12, 12, 12,
  12, 12, 12, 12,
  12, 12, 12, 12,
};
//Underworld melody
int underworld_melody[] = {
  NOTE_C4, NOTE_C5, NOTE_A3, NOTE_A4,
  NOTE_AS3, NOTE_AS4, 0,
  0,
  NOTE_C4, NOTE_C5, NOTE_A3, NOTE_A4,
  NOTE_AS3, NOTE_AS4, 0,
  0,
  NOTE_F3, NOTE_F4, NOTE_D3, NOTE_D4,
  NOTE_DS3, NOTE_DS4, 0,
  0,
  NOTE_F3, NOTE_F4, NOTE_D3, NOTE_D4,
  NOTE_DS3, NOTE_DS4, 0,
  0, NOTE_DS4, NOTE_CS4, NOTE_D4,
  NOTE_CS4, NOTE_DS4,
  NOTE_DS4, NOTE_GS3,
  NOTE_G3, NOTE_CS4,
  NOTE_C4, NOTE_FS4, NOTE_F4, NOTE_E3, NOTE_AS4, NOTE_A4,
  NOTE_GS4, NOTE_DS4, NOTE_B3,
  NOTE_AS3, NOTE_A3, NOTE_GS3,
  0, 0, 0
};
//Underwolrd tempo
int underworld_tempo[] = {
  12, 12, 12, 12,
  12, 12, 6,
  3,
  12, 12, 12, 12,
  12, 12, 6,
  3,
  12, 12, 12, 12,
  12, 12, 6,
  3,
  12, 12, 12, 12,
  12, 12, 6,
  6, 18, 18, 18,
  6, 6,
  6, 6,
  6, 6,
  18, 18, 18, 18, 18, 18,
  10, 10, 10,
  10, 10, 10,
  3, 3, 3
};



void setup(void) {
  Serial.begin(9600);
  pinMode(LED_SYNC, OUTPUT);
  pinMode(melodyPin, OUTPUT);//buzzer
  
  pinMode(Do, INPUT);
  pinMode(Re, INPUT);
  pinMode(Mi, INPUT);
  pinMode(Fa, INPUT);
  pinMode(Sol,INPUT);
  pinMode(La, INPUT);
  pinMode(Si, INPUT);
  pinMode(Marioo,INPUT);
}

void loop() {
  ClickButton();
}

int song = 0;
 
void sing(int s) {
  song = s;
  if (song == 2) {
    Serial.println(" 'Underworld Theme'");
    int size = sizeof(underworld_melody) / sizeof(int);
    for (int thisNote = 0; thisNote < size; thisNote++) {
 
      // to calculate the note duration, take one second
      // divided by the note type.
      //e.g. quarter note = 1000 / 4, eighth note = 1000/8, etc.
      int noteDuration = 1000 / underworld_tempo[thisNote];
 
      buzz(melodyPin, underworld_melody[thisNote], noteDuration);
 
      // to distinguish the notes, set a minimum time between them.
      // the note's duration + 30% seems to work well:
      int pauseBetweenNotes = noteDuration * 1.30;
      delay(pauseBetweenNotes);
 
      // stop the tone playing:
      buzz(melodyPin, 0, noteDuration);
 
    }
 
  } else {
 
    Serial.println(" 'Mario Theme'");
    int size = sizeof(melody) / sizeof(int);
    for (int thisNote = 0; thisNote < size; thisNote++) {
 
      // to calculate the note duration, take one second
      // divided by the note type.
      //e.g. quarter note = 1000 / 4, eighth note = 1000/8, etc.
      int noteDuration = 1000 / tempo[thisNote];
 
      buzz(melodyPin, melody[thisNote], noteDuration);
 
      // to distinguish the notes, set a minimum time between them.
      // the note's duration + 30% seems to work well:
      int pauseBetweenNotes = noteDuration * 1.30;
      delay(pauseBetweenNotes);
 
      // stop the tone playing:
      buzz(melodyPin, 0, noteDuration);
 
    }
  }
}
 
void buzz(int targetPin, long frequency, long length) {
  digitalWrite(13, HIGH);
  long delayValue = 1000000 / frequency / 2; // calculate the delay value between transitions
  //// 1 second's worth of microseconds, divided by the frequency, then split in half since
  //// there are two phases to each cycle
  long numCycles = frequency * length / 1000; // calculate the number of cycles for proper timing
  //// multiply frequency, which is really cycles per second, by the number of seconds to
  //// get the total number of cycles to produce
  for (long i = 0; i < numCycles; i++) { // for the calculated length of time...
    digitalWrite(targetPin, HIGH); // write the buzzer pin high to push out the diaphram
    delayMicroseconds(delayValue); // wait for the calculated delay value
    digitalWrite(targetPin, LOW); // write the buzzer pin low to pull back the diaphram
    delayMicroseconds(delayValue); // wait again or the calculated delay value
  }
  digitalWrite(13, LOW);
 
}


void ClickButton(){
  
  if(digitalRead(Do) == 1){
    Serial.println("DO");
    digitalWrite(LED_SYNC, HIGH);
    tone(Speaker, melody1[0]);
    delay(Delay);
  }else if(digitalRead(Re) == 1){
    Serial.println("RE");
    digitalWrite(LED_SYNC, HIGH);
    tone(Speaker, melody1[1]);
    delay(Delay);
  }else if(digitalRead(Mi) == 1){
    Serial.println("MI");
    digitalWrite(LED_SYNC, HIGH);
    tone(Speaker, melody1[2]);
    delay(Delay);
  }else if(digitalRead(Fa) == 1){
    Serial.println("FA");
    digitalWrite(LED_SYNC, HIGH);
    tone(Speaker, melody1[3]);
    delay(Delay);
  }else if(digitalRead(Sol) == 1){
    Serial.println("SOL");
    digitalWrite(LED_SYNC, HIGH);
    tone(Speaker, melody1[4]);
    delay(Delay);
  }else if(digitalRead(La) == 1){
    Serial.println("La");
    digitalWrite(LED_SYNC, HIGH);
    tone(Speaker, melody1[5]);
    delay(Delay);
  }else if(digitalRead(Si) == 1){
    Serial.println("Si");
    digitalWrite(LED_SYNC, HIGH);
    tone(Speaker, melody1[6]);
    delay(Delay);
  }else if(digitalRead(Marioo) == 1){
    Serial.println("Marioo");
    digitalWrite(LED_SYNC, HIGH);
    sing(1);
    sing(2);
    delay(Delay);
  }else{
    digitalWrite(LED_SYNC, LOW);
    noTone(Speaker);
  }
}




