/*
 * main.c
 *
 *  Created on: Aug 19, 2011
 *      Author: cberg
 *      Made for Max7221 controlled Rapunzel Wig
 */

#include <avr/io.h>
#include <util/delay.h>
#include <avr/interrupt.h>
//#include <stdlib.h>
#include "LEDControl.h"

#define stand_int 0x0F; //standard intensity

static const uint8_t inner_delay = 250;


//Goes throw a glowing loop - does this 5 times
void glow()
{
	all_set(0xFF); //All On
	uint8_t dir = 0x00; //0=down,1=up
	uint8_t val = stand_int;
	//TODO - modify while loop to stop after a while
	uint8_t loops = 0;
	while (loops < 5)
	{
		sdp8(REG_INTENSITY, val);
		_delay_ms(100);
		if (dir == 0x00)//down
			val--;
		else//up
			val++;
		if (val == 0x01) //prevents a value of 0 from being used
			dir = 1;
		else if (val == 0x0F)
		{
			dir = 0;
			loops++;
		}
	}
	sdp8(REG_INTENSITY, 0x0F); //set to max intensity once done
}

//This starts the glowing at the scalp and then down the braid
void start_glow()
{
	all_set(0x00);
	sdp8(REG_INTENSITY,0x0f);//TODO - add slow increase in intensity
	sdp8(REG_DIGIT0, 0x18);
	sdp8(REG_DIGIT1, 0x18);
	sdp8(REG_DIGIT2, 0x0C);
	_delay_ms(250);
	//sdp8(REG_INTENSITY,0x0B);
	sdp8(REG_DIGIT0, 0x3C);
	sdp8(REG_DIGIT1, 0x3C);
	sdp8(REG_DIGIT2, 0x1E);
	_delay_ms(250);
	//sdp8(REG_INTENSITY,0x0C);
	sdp8(REG_DIGIT0, 0x7E);
	sdp8(REG_DIGIT1, 0x7E);
	sdp8(REG_DIGIT2, 0x3F);
	_delay_ms(250);
	//sdp8(REG_INTENSITY,0x0D);
	sdp8(REG_DIGIT0, 0x7E);
	sdp8(REG_DIGIT1, 0x7E);
	_delay_ms(250);
	//sdp8(REG_INTENSITY,0x0E);
	sdp8(REG_DIGIT0, 0xFF);
	sdp8(REG_DIGIT1, 0xFF);
	sdp8(REG_DIGIT2, 0xFF);
	_delay_ms(250);
	//sdp8(REG_INTENSITY,0x0F);
	uint8_t disp = 0;
	for (uint8_t segment = REG_DIGIT3; segment <= REG_DIGIT7; segment++)
	{
		disp=0;
		for(uint8_t i = 0; i < 8; i++)
		{
			disp+= 1<<i;
			sdp8(segment, disp);
			_delay_ms(250);
		}
	}
}
//reverse of the start_glow method
void glow_off()
{
	all_set(0xFF);
	sdp8(REG_INTENSITY,0x0F);//TODO - add slow increase in intensity
	uint8_t disp = 0;
	for (uint8_t segment = REG_DIGIT7; segment >= REG_DIGIT3; segment--)
	{
		disp=0xFF;
		for (uint8_t i = 8; i> 0; i--)//sequentially turn off leds 8 through 1
		{
			disp -= 1<<(i-1);
			sdp8(segment, disp);
			_delay_ms(250);
		}
	}
	sdp8(REG_DIGIT2, 0xFF);
	_delay_ms(250);
	sdp8(REG_DIGIT0, 0x7E);
	sdp8(REG_DIGIT1, 0x7E);
	_delay_ms(250);
	sdp8(REG_DIGIT0, 0x7E);
	sdp8(REG_DIGIT1, 0x7E);
	sdp8(REG_DIGIT2, 0x3F);
	_delay_ms(250);
	sdp8(REG_DIGIT0, 0x3C);
	sdp8(REG_DIGIT1, 0x3C);
	sdp8(REG_DIGIT2, 0x1E);
	_delay_ms(250);
	sdp8(REG_DIGIT0, 0x18);
	sdp8(REG_DIGIT1, 0x18);
	sdp8(REG_DIGIT2, 0x0C);
	_delay_ms(250);
	sdp8(REG_DIGIT0, 0x00);
	sdp8(REG_DIGIT1, 0x00);
	sdp8(REG_DIGIT2, 0x00);
}

//Found this online - I think it was from http://nikosapi.org/blog/?p=82, although I've found the code used other places as well
//Works great - especially since using the standard rand function was too large for the AATTiny45
/* Use the crappy temperature sensor in the ATtiny45 to
   generate a somewhat random number. */
uint8_t get_random_seed()
{
    uint8_t result = 0;
    PRR &= ~_BV(PRADC); // Power-up the ADC

    ADMUX |= _BV(REFS1); // 1.1V reference
    ADMUX |= _BV(MUX3) | _BV(MUX2) | _BV(MUX1) | _BV(MUX0); // temp sensor
    ADCSRA = _BV(ADEN); // Enable the ADC, Prescaler of 2 for maximum noise

    for (int i=0; i<32; i++){
        ADCSRA |= _BV(ADSC);                   // Start the ADC
        loop_until_bit_is_set( ADCSRA, ADIF ); // Wait for the ADC to complete
        result += ADCL;                        // Get the low bits of the result
        result += ADCH<<8;                     // Add the two high bits
    }

    ADMUX = 0;
    ADCSRA = 0;
    PRR |= _BV(PRADC);  // Turn off the ADC to save power

    return result;
}

//this uses the above random number generator - randomly twinkles the hair - probably my favorite part
void twinkle()
{
	uint8_t randVal = 0;
	for (uint8_t seg = REG_DIGIT0; seg <= REG_DIGIT7; seg++)
	{
		randVal = get_random_seed();
		sdp8(seg,randVal);
		_delay_ms(100);
	}
}

int main(void)
{
	//set up SPI for Max7221
	SPI_MasterInit();
	initsdp8();

	while(1)
	{
		//turn all leds on
		start_glow();
		_delay_ms(2000);
		//glow a few times
		glow();
		//twinkle 10 times
		for (uint8_t i = 0; i < 10; i++)
		{
			twinkle();
		}
		//turn braid off
		glow_off();
		//do it all over again!
	}
}
