/*
 *	LED Control library for Attiny45
 *
 */

#include <avr/io.h>

#define REG_NOOP      0x00      // MAX7221 command registers
#define REG_DIGIT0      0x01
#define REG_DIGIT1      0x02
#define REG_DIGIT2      0x03
#define REG_DIGIT3      0x04
#define REG_DIGIT4      0x05
#define REG_DIGIT5      0x06
#define REG_DIGIT6      0x07
#define REG_DIGIT7      0x08
#define REG_DECODE      0x09      // "decode mode" register
#define REG_INTENSITY      0x0a      // "intensity" register
#define REG_SCAN_LIMIT      0x0b      // "scan limit" register
#define REG_SHUTDOWN      0x0c      // "shutdown" register
#define REG_DISPLAY_TEST   0x0f      // "display test" register

#define DATAOUT		(1<<PB1) //Data Out
#define DATA_PINNUM	PB1
#define SPICLOCK	(1<<PB2) //SCK
#define SCK_PINNUM PB2
#define SLAVESELECT	(1<<PB0) //SS
#define SS_PINNUM PB0

#define SPI_DDR DDRB;

#define cbi(port,pin)  port &= ~_BV(pin)
#define sbi(port,pin)  port |= _BV(pin)
//http://www.avrfreaks.net/index.php?name=PNphpBB2&file=viewtopic&t=39636&start=0
void SPI_MasterInit(void)
{
	//Set pins as output
	DDRB |= DATAOUT|SPICLOCK|SLAVESELECT;

	// set sck high, cs high
	//PORTB |= SPICLOCK|SLAVESELECT;
}
//http://www.avrfreaks.net/index.php?name=PNphpBB2&file=viewtopic&t=67236&start=0
#define USIOIF   6
#define USIWM0   4
#define USICS1   3
#define USICLK   1
#define USITC   0
#undef   DDR_WRITE
#define DDR_WRITE   0xE0
void spi(unsigned char cData)
{
	USIDR = cData;
	USISR = _BV(USIOIF);
	do {
		USICR = (1<<USIWM0)|(1<<USICS1)|(1<<USICLK)|(1<<USITC);
   } while ((USISR & (1<<USIOIF)) == 0);
}
void sdp8(unsigned char posn, unsigned char val)
{
	//TODO: Fix slave select
	PORTB &= ~SLAVESELECT; //pull CS low
	spi(posn);
	spi(val);
	PORTB ^= SLAVESELECT; //pull CS high - this was |= ~Slaveselect in original - not correct for bitwise
}
void all_set(uint8_t val)
{
	sdp8(REG_DIGIT0, val);
	sdp8(REG_DIGIT1, val);
	sdp8(REG_DIGIT2, val);
	sdp8(REG_DIGIT3, val);
	sdp8(REG_DIGIT4, val);
	sdp8(REG_DIGIT5, val);
	sdp8(REG_DIGIT6, val);
	sdp8(REG_DIGIT7, val);
}
void initsdp8(void)
{
	sdp8(REG_INTENSITY, 0x0F);   /* max intensity */
	sdp8(REG_SCAN_LIMIT, 0x07);   /* scan limit set to digit 0 only, 0x07 for all digits*/
	sdp8(REG_DECODE, 0x00);   /* no decode - we're using a matrix*/
	all_set(0x00);
	sdp8(REG_SHUTDOWN, 0x01);   /* not shutdown */
//	sdp8(REG_DISPLAY_TEST, 0x01);   /* start test*/
//	_delay_ms(1000);
//	sdp8(REG_DISPLAY_TEST, 0x00);   /* stop test*/
}
