// An object that wraps the PShape

class Wiggler {

  // The PShape to be "wiggled"
  PShape s;
  // Its location
  float x, y;

  // For 2D Perlin noise
  float yoff = 0;

  // We are using an ArrayList to keep a duplicate copy
  // of vertices original locations.
  ArrayList<PVector> original;


  Wiggler(int size, int r, int g, int b) {
    x = width/2;
    y = height/2; 


    // The "original" locations of the vertices make up a circle
    original = new ArrayList<PVector>();
    for (float a = 0; a < TWO_PI; a+=0.2) {
      PVector v = PVector.fromAngle(a);
      v.mult(size);
      original.add(v);
    }

    //original = new ArrayList<PVector>();
    //for (int i = 0; i < 20; i++) {
    //  int side = i / 5;
    //  int n = i % 5;
    //  PVector v = new PVector();
    //  switch(side) {
    //  case 0:
    //    v = new PVector(n, 0);
    //    break;
    //  case 1: 
    //    v = new PVector(4, n);
    //    break;
    //  case 2: 
    //    v = new PVector(4 - (n * 1), 4);
    //    break;
    //  case 3:
    //    v = new PVector(0, 4-(n*1));
    //    break;
    //  }
    //  v.x -= 2.5;
    //  v.y -= 2.5;
    //  v.mult(size /5);
    //  original.add(v);
    //  }


    // Now make the PShape with those vertices
    s = createShape();
    s.beginShape();
    s.fill(r, g, b);
    s.stroke(255);
    s.strokeWeight(5);
    for (PVector v : original) {
      s.vertex(v.x, v.y,v.x,v.y);
    }
    s.endShape(CLOSE);
  }

  void wiggle() {
    float xoff = 0;
    // Apply an offset to each vertex
    for (int i = 0; i < s.getVertexCount(); i++) {
      // Calculate a new vertex location based on noise around "original" location
      PVector pos = original.get(i);
      float a = TWO_PI*noise(xoff, yoff);
      PVector r = PVector.fromAngle(a);
      r.mult(35);
      r.add(pos);
      // Set the location of each vertex to the new one
      s.setVertex(i, r.x, r.y);
      // increment perlin noise x value
      xoff+= 0.5;
    }
    // Increment perlin noise y value
    yoff += 0.02;
  }

  void display() {
    pushMatrix();
    translate(x, y);
    scale(globalScale);
    shape(s);
    popMatrix();
  }
}